/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.dialog;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarPane;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.Queue;
import org.apache.commons.lang3.tuple.Pair;

class MessagePopupHandler
extends WindowAdapter {
    private static final MessagePopupHandler INSTANCE = new MessagePopupHandler();
    private final Queue<Pair<String, Integer>> queue = new ArrayDeque<Pair<String, Integer>>();
    private boolean isMessagePopupVisible;
    private volatile Window currentMessagePopup;

    private MessagePopupHandler() {
        DataSelectionManager.getInstance().addListener(new PatientChangeListener());
    }

    public static MessagePopupHandler getInstance() {
        return INSTANCE;
    }

    synchronized void showMessagePopup(String string, Integer n) {
        if (this.isMessagePopupVisible) {
            this.queue.offer((Pair<String, Integer>)Pair.of((Object)string, (Object)n));
        } else {
            this.showMessagePopupImpl(string, n);
        }
    }

    private synchronized void showMessagePopupImpl(String string, Integer n) {
        this.isMessagePopupVisible = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><center>");
        stringBuilder.append(string);
        stringBuilder.append("</center></html>");
        EnumSet<SwingUtilities2.FloatingMessageWindowFlags> enumSet = EnumSet.of(SwingUtilities2.FloatingMessageWindowFlags.DISPOSE_ON_CLICK);
        if (JVision2.getMainFrame().isFocused() || LTAUtil.getMainWindow().isFocused()) {
            enumSet.add(SwingUtilities2.FloatingMessageWindowFlags.TO_FRONT);
        }
        EventUtil.invoke(() -> SwingUtilities2.showFloatingMessageWindow((String)stringBuilder.toString(), (Window)JVision2.getMainFrame(), (IComponentFactory)ComponentFactory.instance, (Point)this.getMessagePopupLocation(), (Dimension)GUI.getScaledDiagnosticDimension((int)250, (int)85), (Integer)n, null, (WindowListener)this, (SwingUtilities2.FloatingMessageWindowFlags[])enumSet.toArray(new SwingUtilities2.FloatingMessageWindowFlags[enumSet.size()])));
    }

    synchronized void clearQueue() {
        this.queue.clear();
    }

    void hideMessagePopup() {
        Window window = this.currentMessagePopup;
        if (window != null) {
            window.dispose();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof Window) {
            this.currentMessagePopup = (Window)object;
        }
    }

    @Override
    public synchronized void windowClosed(WindowEvent windowEvent) {
        this.currentMessagePopup = null;
        this.isMessagePopupVisible = false;
        if (!this.queue.isEmpty()) {
            Pair<String, Integer> pair = this.queue.poll();
            this.showMessagePopupImpl((String)pair.getLeft(), (Integer)pair.getRight());
        }
    }

    Point getMessagePopupLocation() {
        Point point;
        Component component = JVision2.getMainFrame().getSeriesPalette(true).getUIComponent();
        if (component.isShowing()) {
            point = component.getLocationOnScreen();
            point.x += 5;
            point.y -= 5;
        } else {
            TopToolbarPane topToolbarPane = JVision2.getMainFrame().getTopToolbar();
            if (topToolbarPane.isShowing()) {
                point = topToolbarPane.getLocationOnScreen();
                point.x += 5;
                point.y += ((Component)topToolbarPane).getHeight() - 5;
            } else {
                point = new Point(5, 5);
            }
        }
        return point;
    }

    private class PatientChangeListener
    extends DataSelectionListenerAdapter {
        private PatientChangeListener() {
        }

        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            MessagePopupHandler.this.clearQueue();
            MessagePopupHandler.this.hideMessagePopup();
        }
    }
}

