/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.dialog;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.progress.ProgressInterface;
import com.tiani.gui.controls.basic.TProgressBar;
import com.tiani.gui.dialog.StandardDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;

public class TProgressDialog
extends StandardDialog
implements ProgressInterface {
    public static final int PROGRESSBAR_RUNNING = 1;
    public static final int PROGRESSBAR_ABORTED = 2;
    private int status = 1;
    protected TProgressBar prog;
    private int[] lookupTable;
    private int lookupOffset;
    private int oldVal;

    public TProgressDialog(Frame frame, int n, int n2, String string, boolean bl) {
        this(frame, n, n2, string, bl, false);
    }

    public TProgressDialog(Frame frame, int n, int n2, String string, boolean bl, boolean bl2) {
        super(frame, string);
        if (bl) {
            this.addCancelButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TProgressDialog.this.status = 2;
                    TProgressDialog.this.setVisible(false);
                }
            });
        }
        this.prog = new TProgressBar();
        this.initProgressBar(n, n2, bl2);
        this.setContent(this.createMainPanel());
        this.setDefaultCloseOperation(2);
        this.pack();
        this.initLocation();
    }

    @Override
    public void dispose() {
        this.status = 2;
        super.dispose();
    }

    public void initProgressBar(int n, int n2, boolean bl) {
        this.prog.setMaximum(n2);
        this.prog.setMinimum(n);
        this.prog.setShowProgressText(true);
        this.lookupOffset = n;
        int n3 = n2 - n + 1;
        this.lookupTable = new int[n3];
        if (bl) {
            int n4 = 0;
            while (n4 < n3) {
                this.lookupTable[n4] = this.lookupOffset + (int)((double)n3 * (Math.log((double)n4 + 1.0) / Math.log((double)n3 + 1.0)));
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                this.lookupTable[n5] = this.lookupOffset + n5;
                ++n5;
            }
        }
        this.oldVal = n - 1;
        this.setValue(n);
    }

    protected JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(ComponentFactory.instance.createEmptyBorder(5));
        this.prog.setPreferredSize(new Dimension(300, 20));
        jPanel.add((Component)this.prog, "Center");
        return jPanel;
    }

    @Override
    public void setValue(int n) {
        this.oldVal = n;
        if (n > 0 && n - this.lookupOffset < this.lookupTable.length) {
            this.prog.setVal(this.lookupTable[n - this.lookupOffset]);
        }
        this.prog.repaint();
    }

    public int getValue() {
        return this.oldVal;
    }

    public int getStatus() {
        return this.status;
    }
}

