/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util;

import com.tiani.config.LayoutConfig;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;

public abstract class LocationUtil {
    public static Dimension getDefaultDialogSize() {
        LayoutConfig layoutConfig = LayoutConfig.getInstance();
        return new Dimension(layoutConfig.getScreenWidth() * 1 / 2, layoutConfig.getScreenHeight() * 3 / 4);
    }

    public static Point getCurrentAbsoluteMousepointerLocation() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        return pointerInfo.getLocation();
    }

    public static boolean isOnCurrentMonitor(Component component) {
        if (component.getParent() == null || component.getWidth() <= 0 || !component.isShowing()) {
            return false;
        }
        Rectangle rectangle = LocationUtil.getAbsoluteMonitorRectangle(component.getLocationOnScreen(), component.getSize());
        Point point = LocationUtil.getCurrentAbsoluteMousepointerLocation();
        return rectangle.contains(point);
    }

    public static Point getProposedDialogLocationCenter() {
        int n = LocationUtil.someAbsoluteXOnCurrentMonitor();
        int n2 = 0;
        return LayoutConfig.getInstance().getBestJVisionMonitorCenter(new Point(n, n2));
    }

    public static void ensureVisibleLocationOverParent(Window window, Window window2) {
        Rectangle rectangle = LocationUtil.getBounds(window);
        Rectangle rectangle2 = LocationUtil.getBounds(window2);
        Rectangle rectangle3 = LocationUtil.ensureVisibleLocationOverParent(rectangle, rectangle2);
        window.setBounds(rectangle3);
    }

    public static Rectangle ensureVisibleLocationOverParent(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = (Rectangle)rectangle.clone();
        if (rectangle.width > rectangle2.width) {
            rectangle3.width = rectangle2.width;
        }
        if (rectangle.height > rectangle2.height) {
            rectangle3.height = rectangle2.height;
        }
        if (rectangle3.x < rectangle2.x) {
            rectangle3.x = rectangle2.x;
        }
        if (rectangle3.y < rectangle2.y) {
            rectangle3.y = rectangle2.y;
        }
        if (rectangle3.x + rectangle3.width > rectangle2.x + rectangle2.width) {
            rectangle3.x = rectangle2.x + rectangle2.width - rectangle3.width;
        }
        if (rectangle3.y + rectangle3.height > rectangle2.y + rectangle2.height) {
            rectangle3.y = rectangle2.y + rectangle2.height - rectangle3.height;
        }
        return rectangle3;
    }

    @SuppressWarnings(value={"NP_NULL_PARAM_DEREF"})
    public static Rectangle ensureVisibleLocation(Rectangle rectangle) {
        Rectangle[] rectangleArray;
        Rectangle rectangle2 = LocationUtil.getAbsoluteMonitorRectangle(new Point(rectangle.x, rectangle.y), new Dimension(rectangle.width, rectangle.height));
        if (rectangle2 == null && (rectangleArray = LocationUtil.getMonitorRectangles()) != null && rectangleArray.length > 0) {
            rectangle2 = rectangleArray[0];
        }
        if (rectangle2 == null) {
            return rectangle;
        }
        return LocationUtil.ensureVisibleLocationOverParent(rectangle, rectangle2);
    }

    public static int getAlignmentSwingConstant(Component component) {
        boolean bl;
        Container container = component.getParent();
        boolean bl2 = bl = component.getWidth() > component.getHeight();
        if (bl) {
            if (component.getY() > container.getHeight() / 2) {
                return 5;
            }
            return 1;
        }
        if (component.getX() > container.getWidth() / 2) {
            return 3;
        }
        return 7;
    }

    public static Rectangle getBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            Dimension dimension = LocationUtil.getSize(component);
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        }
        return rectangle;
    }

    public static Dimension getSize(Component component) {
        Dimension dimension = component.getSize();
        if (dimension == null || dimension.width <= 0 || dimension.height <= 0) {
            dimension = component.getPreferredSize();
        }
        return dimension;
    }

    private static int someAbsoluteXOnCurrentMonitor() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        return pointerInfo.getLocation().x;
    }

    private static Rectangle[] getMonitorRectangles() {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(graphicsDeviceArray.length);
        GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray;
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray2[n2];
            if (graphicsDevice.getType() == 0) {
                arrayList.add(graphicsDevice.getDefaultConfiguration().getBounds());
            }
            ++n2;
        }
        return arrayList.toArray(new Rectangle[arrayList.size()]);
    }

    private static Rectangle find(Point point, Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = rectangleArray;
        int n = rectangleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray2[n2];
            if (rectangle.contains(point)) {
                return rectangle;
            }
            ++n2;
        }
        return null;
    }

    public static Rectangle getAbsoluteMonitorRectangle(Point point, Dimension dimension) {
        Point point2;
        Point point3;
        Rectangle rectangle;
        Rectangle[] rectangleArray = LocationUtil.getMonitorRectangles();
        if (dimension != null && (rectangle = LocationUtil.find(point3 = new Point(point.x + dimension.width / 2, point.y + dimension.height / 2), rectangleArray)) != null) {
            return rectangle;
        }
        point3 = new Point(point);
        rectangle = LocationUtil.find(point3, rectangleArray);
        if (rectangle != null) {
            return rectangle;
        }
        if (dimension != null && (rectangle = LocationUtil.find(point2 = new Point(point.x + dimension.width, point.y + dimension.height), rectangleArray)) != null) {
            return rectangle;
        }
        return null;
    }

    private LocationUtil() {
    }
}

