/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.event;

import com.tiani.gui.util.event.RecursivelyInstallableMouseListenerMixin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;

public class DefaultMouseMoveListener
extends RecursivelyInstallableMouseListenerMixin {
    private boolean isOverComponent;
    private long lastMoveTime = System.currentTimeMillis();
    private boolean dragging;

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastMoveTime = mouseEvent.getWhen();
        this.dragging = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMoveTime = mouseEvent.getWhen();
        this.dragging = true;
    }

    @Override
    public synchronized void mouseEntered(MouseEvent mouseEvent) {
        Dimension dimension = this.getSourceComponentDimension(mouseEvent);
        if (dimension != null && this.isMouseWithin(dimension, mouseEvent)) {
            this.isOverComponent = true;
            this.entered(mouseEvent);
        }
    }

    @Override
    public synchronized void mouseExited(MouseEvent mouseEvent) {
        Dimension dimension = this.getSourceComponentDimension(mouseEvent);
        if (dimension != null && !this.isMouseWithin(dimension, mouseEvent)) {
            this.isOverComponent = false;
            this.exited(mouseEvent);
        }
    }

    protected void entered(MouseEvent mouseEvent) {
    }

    protected void exited(MouseEvent mouseEvent) {
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public synchronized boolean isMouseOver() {
        return this.isOverComponent;
    }

    public long getLastMoveTime() {
        return this.lastMoveTime;
    }

    private Dimension getSourceComponentDimension(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Dimension dimension = component != null ? component.getSize() : null;
        return dimension;
    }

    private boolean isMouseWithin(Dimension dimension, MouseEvent mouseEvent) {
        return mouseEvent.getX() > 0 && mouseEvent.getY() > 0 && mouseEvent.getX() < dimension.width && mouseEvent.getY() < dimension.height;
    }
}

