/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.event.DefaultMouseMoveListener;
import com.tiani.gui.util.event.MouseKnocking;
import com.tiani.gui.util.event.RecursivelyInstallableMouseListenerMixin;
import com.tiani.gui.util.panel.flexible.AbstractVisualizer;
import com.tiani.gui.util.panel.flexible.PopupWindow;
import com.tiani.gui.util.panel.flexible.behaviourcontrol.MouseOverButtonsBehaviourControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

abstract class AbstractPopupVisualizer
extends AbstractVisualizer {
    private static final int MOUSE_IDLE_TIME = 1200;
    private static final int TIMER_INTERVAL = 500;
    private static final int MINIMAL_MOUSEMOVE_INTERVAL = 500;
    private static final ALogger log = ALogger.getLogger(AbstractPopupVisualizer.class);
    private Container parentContainer;
    private Container popupWindow;
    private Component mouseSensor;
    private RecursivelyInstallableMouseListenerMixin mouseListener;
    private DefaultMouseMoveListener mouseExitedPanelDetector;
    private DefaultMouseMoveListener outsideMoveListener;
    private Point currentMousePointRelativeToParentWindow;
    private boolean hidden = true;
    private Timer hideTimeout;
    private long lastToggleEvent;
    private WindowListener frameListener = new WindowAdapter(){

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            this.windowClosing(windowEvent);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (AbstractPopupVisualizer.this.popupWindow != null) {
                AbstractPopupVisualizer.this.setHidden(true);
                if (AbstractPopupVisualizer.this.popupWindow instanceof Window) {
                    try {
                        ((Window)AbstractPopupVisualizer.this.popupWindow).dispose();
                    }
                    catch (Exception exception) {}
                }
                AbstractPopupVisualizer.this.popupWindow = null;
            }
        }
    };

    protected AbstractPopupVisualizer(Container container, Container container2, Component component) {
        super(container);
        if (container2 == null) {
            throw new IllegalArgumentException("Parent container (where to visualize panel) is null");
        }
        this.parentContainer = container2;
        this.mouseSensor = component;
        this.installMouseListener(component);
    }

    protected abstract RecursivelyInstallableMouseListenerMixin newMouseListener(Component var1);

    protected abstract Rectangle calculateAbsolutePopupBounds();

    abstract Rectangle calculateActualAbsolutePopupBounds();

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean bl) {
        this.setHidden(bl, true);
    }

    private void setHidden(boolean bl, boolean bl2) {
        if (bl == this.hidden) {
            return;
        }
        assert (EventQueue.isDispatchThread()) : "Must call setHidden(" + bl + ") from event thread!";
        if (bl) {
            if (!this.checkForOpenCombos()) {
                return;
            }
            if (bl2 && System.currentTimeMillis() - this.lastToggleEvent < 500L) {
                return;
            }
        } else if (!this.hasParentFocus()) {
            return;
        }
        this.lastToggleEvent = System.currentTimeMillis();
        if (bl) {
            this.hidden = true;
            if (this.popupWindow != null) {
                this.popupWindow.setVisible(false);
                this.notifyWasHidden();
            }
        } else {
            this.flexiblePanel.validate();
            if (this.popupWindow == null) {
                this.buildPopupWindow();
            }
            if (this.showPopupWindow()) {
                this.hidden = false;
                this.installHideListeners();
            }
        }
    }

    @Override
    public void deinstall() {
        this.deinstallMouseListener(this.mouseSensor);
        Window window = this.getParentWindow();
        if (window != null) {
            window.removeWindowListener(this.frameListener);
        }
        this.deinstallHideListeners();
        super.deinstall();
    }

    private boolean hasParentFocus() {
        Window window = this.getParentWindow();
        assert (window != null) : "A FlexiblePanel seems to having not been closed after its parent/sensor was removed from Component hierarchy! (Parent Window not found.)";
        if (window.getFocusOwner() != null) {
            return true;
        }
        Window window2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return window2 == window;
    }

    private void buildPopupWindow() {
        this.getParentWindow().removeWindowListener(this.frameListener);
        this.popupWindow = this.newPopupWindow(this.getParentWindow());
        this.getParentWindow().addWindowListener(this.frameListener);
        this.fillPopupWindow();
    }

    private Container newPopupWindow(Window window) {
        PopupWindow popupWindow = window instanceof Dialog ? new PopupWindow((Dialog)window) : new PopupWindow((Frame)window);
        return popupWindow;
    }

    private void fillPopupWindow() {
        Container container;
        Container container2 = this.popupWindow instanceof JFrame ? ((JFrame)this.popupWindow).getContentPane() : (container = this.popupWindow instanceof JDialog ? ((JDialog)this.popupWindow).getContentPane() : this.popupWindow);
        if (container.getComponentCount() <= 0) {
            container.add(this.flexiblePanel);
            this.popupWindow.validate();
        }
    }

    boolean showPopupWindow() {
        Rectangle rectangle = this.calculateAbsolutePopupBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0 || this.popupWindow.getComponentCount() <= 0) {
            log.warn("Popup seems to have no components (" + this.popupWindow.getComponentCount() + ") or returns invisible dimension: " + rectangle);
            return false;
        }
        if (this.popupWindow instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)this.popupWindow;
            jPopupMenu.setLightWeightPopupEnabled(false);
            jPopupMenu.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
            jPopupMenu.show(this.getParentWindow(), rectangle.x - this.getParentWindow().getX(), rectangle.y - this.getParentWindow().getY());
        } else {
            ((Window)this.popupWindow).pack();
            this.popupWindow.setBounds(rectangle);
            this.popupWindow.setVisible(true);
        }
        return true;
    }

    private Window getParentWindow() {
        return SwingUtilities.getWindowAncestor(this.getParentContainer());
    }

    protected Container getParentContainer() {
        return this.parentContainer;
    }

    protected Point getAbsoluteParentWindowLocation() {
        return this.getParentWindow().getLocation();
    }

    protected void setCurrentMousePoint(MouseEvent mouseEvent) {
        this.setCurrentMousePoint(mouseEvent.getComponent(), mouseEvent.getPoint());
    }

    protected void setCurrentMousePoint(Component component, Point point) {
        this.currentMousePointRelativeToParentWindow = SwingUtilities.convertPoint(component, point, this.getParentWindow());
    }

    protected Point getCurrentMousePointRelativeToParentWindow() {
        return this.currentMousePointRelativeToParentWindow;
    }

    private boolean checkForOpenCombos() {
        return this.checkForOpenCombos(this.flexiblePanel);
    }

    private boolean checkForOpenCombos(Component component) {
        if (component instanceof JComboBox && ((JComboBox)component).isPopupVisible()) {
            return false;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (!this.checkForOpenCombos(componentArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private void installMouseListener(Component component) {
        if (this.mouseListener == null) {
            this.mouseListener = this.newMouseListener(component);
        } else {
            this.mouseListener.deinstallFrom(this.mouseSensor);
        }
        this.mouseSensor = component;
        this.mouseListener.installOn(this.mouseSensor, this.flexiblePanel.getClass());
    }

    private void deinstallMouseListener(Component component) {
        if (this.mouseListener != null) {
            this.mouseListener.deinstallFrom(component);
        }
        this.setHidden(true, false);
    }

    private void installHideListeners() {
        this.deinstallHideListeners();
        this.mouseExitedPanelDetector = this.newHidePopupOnMouseExitedPanelListener();
        if (this.mouseExitedPanelDetector == null) {
            this.mouseExitedPanelDetector = new DefaultMouseMoveListener();
        }
        this.mouseExitedPanelDetector.installOn(this.flexiblePanel);
        this.outsideMoveListener = this.newHidePopupOnMouseOutsideListener();
        this.outsideMoveListener.installOn(this.getParentWindow());
        this.hideTimeout = this.newHideTimeout(this.mouseExitedPanelDetector, this.outsideMoveListener);
        if (this.hideTimeout != null) {
            this.hideTimeout.start();
        }
    }

    private void deinstallHideListeners() {
        if (this.hideTimeout != null) {
            this.hideTimeout.stop();
            this.hideTimeout = null;
        }
        if (this.mouseExitedPanelDetector != null) {
            this.mouseExitedPanelDetector.deinstallFrom(this.flexiblePanel);
        }
        if (this.outsideMoveListener != null) {
            this.outsideMoveListener.deinstallFrom(this.getParentWindow());
        }
        this.mouseExitedPanelDetector = null;
        this.outsideMoveListener = null;
    }

    private boolean checkDragState(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x400) != 1024;
    }

    protected DefaultMouseMoveListener newHidePopupOnMouseExitedPanelListener() {
        return new HidePopupOnMouseExitedPanelListener();
    }

    protected DefaultMouseMoveListener newHidePopupOnMouseOutsideListener() {
        return new HidePopupOnMouseOutsideListener();
    }

    protected Timer newHideTimeout(final DefaultMouseMoveListener defaultMouseMoveListener, final DefaultMouseMoveListener defaultMouseMoveListener2) {
        return new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!defaultMouseMoveListener.isMouseOver() && actionEvent.getWhen() - defaultMouseMoveListener.getLastMoveTime() > 1200L) {
                    boolean bl = true;
                    if (!AbstractPopupVisualizer.this.isHidden()) {
                        AbstractPopupVisualizer.this.setHidden(true);
                        bl = AbstractPopupVisualizer.this.isHidden();
                    }
                    if (bl) {
                        AbstractPopupVisualizer.this.hideTimeout.stop();
                        defaultMouseMoveListener.deinstallFrom(AbstractPopupVisualizer.this.flexiblePanel);
                        defaultMouseMoveListener2.deinstallFrom(AbstractPopupVisualizer.this.getParentWindow());
                    }
                }
            }
        });
    }

    private class HidePopupOnMouseExitedPanelListener
    extends DefaultMouseMoveListener {
        private HidePopupOnMouseExitedPanelListener() {
        }

        @Override
        protected void exited(MouseEvent mouseEvent) {
            if (!AbstractPopupVisualizer.this.isHidden() && AbstractPopupVisualizer.this.checkDragState(mouseEvent) && new MouseKnocking(AbstractPopupVisualizer.this.flexiblePanel, mouseEvent).getSide() != null) {
                AbstractPopupVisualizer.this.setHidden(true);
            }
        }
    }

    private class HidePopupOnMouseOutsideListener
    extends DefaultMouseMoveListener {
        private HidePopupOnMouseOutsideListener() {
            this.excludeSubComponentFromListening(JPopupMenu.class);
            this.excludeSubComponentFromListening(MouseOverButtonsBehaviourControl.Panel.class);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!AbstractPopupVisualizer.this.isHidden() && AbstractPopupVisualizer.this.checkDragState(mouseEvent)) {
                AbstractPopupVisualizer.this.setHidden(true);
            }
            super.mouseMoved(mouseEvent);
        }
    }
}

