/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.event.DefaultMouseMoveListener;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.gui.util.panel.flexible.MouseClickPopupVisualizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

class MouseClickDropdownVisualizer
extends MouseClickPopupVisualizer {
    private static final ALogger log = ALogger.getLogger(MouseClickDropdownVisualizer.class);

    MouseClickDropdownVisualizer(FlexiblePanel flexiblePanel, Container container, Component component, MouseClickPopupVisualizer.EventCondition eventCondition) {
        super(flexiblePanel, container, component, eventCondition);
    }

    @Override
    protected DefaultMouseMoveListener newHidePopupOnMouseOutsideListener() {
        return new HideOnClickOutsideMouseListener();
    }

    @Override
    protected DefaultMouseMoveListener newHidePopupOnMouseExitedPanelListener() {
        return null;
    }

    @Override
    protected Timer newHideTimeout(DefaultMouseMoveListener defaultMouseMoveListener, DefaultMouseMoveListener defaultMouseMoveListener2) {
        return null;
    }

    @Override
    protected int getMouseInsideRectangleInset() {
        return 0;
    }

    private class HideOnClickOutsideMouseListener
    extends DefaultMouseMoveListener {
        private HideOnClickOutsideMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!MouseClickDropdownVisualizer.this.isHidden() && this.shouldClosePopup(mouseEvent)) {
                log.debug("popup close by mouseClicked in " + mouseEvent.getComponent().getClass());
                MouseClickDropdownVisualizer.this.setHidden(true);
            }
            super.mouseMoved(mouseEvent);
        }

        private boolean shouldClosePopup(MouseEvent mouseEvent) {
            return !((FlexiblePanel)MouseClickDropdownVisualizer.this.flexiblePanel).isCurrentTriggerComponent(mouseEvent.getComponent());
        }
    }
}

