/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.tiani.gui.util.event.RecursivelyInstallableMouseListenerMixin;
import com.tiani.gui.util.panel.flexible.AbstractPopupVisualizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class MouseClickPopupVisualizer
extends AbstractPopupVisualizer {
    private EventCondition eventCondition;

    protected MouseClickPopupVisualizer(Container container, Container container2, Component component, EventCondition eventCondition) {
        super(container, container2, component);
        this.eventCondition = eventCondition;
    }

    @Override
    protected RecursivelyInstallableMouseListenerMixin newMouseListener(Component component) {
        return new RecursivelyInstallableMouseListenerMixin(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.trigger(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.trigger(mouseEvent);
            }

            private void trigger(MouseEvent mouseEvent) {
                MouseClickPopupVisualizer.this.setCurrentMousePoint(mouseEvent);
                if (MouseClickPopupVisualizer.this.eventCondition == null && mouseEvent.isPopupTrigger() || MouseClickPopupVisualizer.this.eventCondition != null && MouseClickPopupVisualizer.this.eventCondition.isPopupTrigger(mouseEvent)) {
                    MouseClickPopupVisualizer.this.setHidden(false);
                }
            }
        };
    }

    @Override
    protected Rectangle calculateAbsolutePopupBounds() {
        Rectangle rectangle = this.calculateActualAbsolutePopupBounds();
        if (rectangle == null) {
            return null;
        }
        int n = this.getMouseInsideRectangleInset();
        Rectangle rectangle2 = new Rectangle(rectangle.x - n, rectangle.y - n, rectangle.width, rectangle.height);
        return rectangle2;
    }

    @Override
    Rectangle calculateActualAbsolutePopupBounds() {
        Dimension dimension = this.getPreferredPanelSize();
        if (dimension == null) {
            return null;
        }
        Point point = this.getCurrentMousePointRelativeToParentWindow();
        if (point == null) {
            return null;
        }
        int n = point.x;
        int n2 = point.y;
        Point point2 = this.getAbsoluteParentWindowLocation();
        Rectangle rectangle = new Rectangle(point2.x + n, point2.y + n2, dimension.width, dimension.height);
        return rectangle;
    }

    protected int getMouseInsideRectangleInset() {
        return 6;
    }

    static interface EventCondition {
        public boolean isPopupTrigger(MouseEvent var1);
    }
}

