/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.gui.util.panel.flexible;

import com.tiani.gui.util.LocationUtil;
import com.tiani.gui.util.event.DefaultMouseMoveListener;
import com.tiani.gui.util.event.MouseKnocking;
import com.tiani.gui.util.event.RecursivelyInstallableMouseListenerMixin;
import com.tiani.gui.util.panel.flexible.AbstractPopupVisualizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class MouseKnockPopupVisualizer
extends AbstractPopupVisualizer {
    private String alignment;

    protected MouseKnockPopupVisualizer(Container container, Container container2, String string, Component component) {
        super(container, container2, component);
        if (string == null || string.equals("Center")) {
            throw new IllegalArgumentException("Need a mouse knock edge other than " + string);
        }
        this.alignment = string;
    }

    @Override
    protected RecursivelyInstallableMouseListenerMixin newMouseListener(Component component) {
        return new MouseKnockListener(this, component);
    }

    @Override
    protected Rectangle calculateAbsolutePopupBounds() {
        return this.calculateActualAbsolutePopupBounds();
    }

    @Override
    Rectangle calculateActualAbsolutePopupBounds() {
        Dimension dimension = this.getPreferredPanelSize();
        assert (dimension != null && dimension.width > 8 && dimension.height > 8) : "Can not create a mouseknock-popup with zero width (" + (dimension != null ? Integer.toString(dimension.width) : "null") + ") or height (" + (dimension != null ? Integer.toString(dimension.height) : "null") + ")!";
        Container container = this.getParentContainer();
        Rectangle rectangle = LocationUtil.getBounds(container);
        Point point = container.getLocationOnScreen();
        Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
        if (this.alignment.equals("East")) {
            rectangle2.x += rectangle2.width - dimension.width + 1;
        } else if (this.alignment.equals("South")) {
            rectangle2.y += rectangle2.height - dimension.height + 1;
        }
        if (this.alignment.equals("West") || this.alignment.equals("East")) {
            rectangle2.width = dimension.width;
        } else if (this.alignment.equals("North") || this.alignment.equals("South")) {
            rectangle2.height = dimension.height;
        }
        return rectangle2;
    }

    private static class MouseKnockListener
    extends DefaultMouseMoveListener {
        private final Component sensor;
        private final MouseKnockPopupVisualizer popupVisualizer;

        private MouseKnockListener(MouseKnockPopupVisualizer mouseKnockPopupVisualizer, Component component) {
            this.popupVisualizer = mouseKnockPopupVisualizer;
            this.sensor = component;
        }

        @Override
        protected void exited(MouseEvent mouseEvent) {
            String string = this.detectMouseKnocking(mouseEvent);
            if (string != null && string.equals(this.popupVisualizer.alignment) && this.popupVisualizer.isHidden()) {
                this.popupVisualizer.setHidden(false);
            }
        }

        private String detectMouseKnocking(MouseEvent mouseEvent) {
            if (this.isDragging()) {
                return null;
            }
            this.popupVisualizer.setCurrentMousePoint(mouseEvent);
            return new MouseKnocking(this.sensor, mouseEvent).getSide();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            this.exited(mouseEvent);
        }
    }
}

