/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.dnd;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.sync.ISynchronizationPosition;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImagePlaneInformation;
import com.tiani.jvision.dnd.DisplaySetDropHandlerFactory;
import com.tiani.jvision.dnd.IDisplaySetDropHandler;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.VisDisplayUtils;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.dnd.IVisDisplayDropHandler;
import com.tiani.jvision.vis.event.VisNavigationEvent;
import com.tiani.util.message.Message;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;

public class DisplaySetContainerVisDisplayDropHandler
implements IVisDisplayDropHandler {
    private static final ALogger log = ALogger.getLogger(DisplaySetContainerVisDisplayDropHandler.class);

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public boolean dragEnter(DropTargetDragEvent dropTargetDragEvent, VisDisplay2 visDisplay2) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (IDisplaySet.dataFlavor.equals(dataFlavor)) {
                IDisplaySet iDisplaySet = DisplaySetContainerVisDisplayDropHandler.extractDisplaySet(transferable);
                if (iDisplaySet != null && visDisplay2.hasData()) {
                    boolean bl = false;
                    if (!visDisplay2.isShowingDropRegion(VisDisplay2.DropRegionType.INSERT)) {
                        visDisplay2.showDropRegion(VisDisplay2.DropRegionType.INSERT);
                        bl = true;
                    }
                    for (IDisplaySetDropHandler iDisplaySetDropHandler : DisplaySetDropHandlerFactory.getInstance().getDisplaySetDropHandlers()) {
                        VisDisplay2.DropRegionType dropRegionType = iDisplaySetDropHandler.getType();
                        if (visDisplay2.isShowingDropRegion(dropRegionType) || !iDisplaySetDropHandler.isEnabled(visDisplay2, iDisplaySet)) continue;
                        visDisplay2.showDropRegion(dropRegionType);
                        bl = true;
                    }
                    if (!visDisplay2.isShowingDropRegion(VisDisplay2.DropRegionType.REGISTRATION) && DisplaySetContainerVisDisplayDropHandler.isEqualFrameOfReference(visDisplay2, iDisplaySet)) {
                        visDisplay2.showDropRegion(VisDisplay2.DropRegionType.AUTO_SCROLL);
                        bl = true;
                    }
                    if (bl) {
                        visDisplay2.repaint();
                    }
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IDisplaySet extractDisplaySet(Transferable transferable) {
        try {
            return (IDisplaySet)transferable.getTransferData(IDisplaySet.dataFlavor);
        }
        catch (Exception exception) {
            log.error("Extracting display set from Transferable failed", (Throwable)exception);
            return null;
        }
    }

    private static boolean isEqualFrameOfReference(VisDisplay2 visDisplay2, IDisplaySet iDisplaySet) {
        String string = visDisplay2.getData().getDisplaySet().getFrameOfReferenceUID();
        return string != null && string.equals(iDisplaySet.getFrameOfReferenceUID());
    }

    @Override
    public boolean dragOver(DropTargetDragEvent dropTargetDragEvent, VisDisplay2 visDisplay2) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (IDisplaySet.dataFlavor.equals(dataFlavor) && dropTargetDragEvent.getDropAction() == 0x40000000) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (IDisplaySet.dataFlavor.equals(dataFlavor) && dropTargetDragEvent.getDropAction() == 0x40000000) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent, VisDisplay2 visDisplay2) {
        visDisplay2.hideAllDropRegions();
    }

    @Override
    public boolean drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (IDisplaySet.dataFlavor.equals(dataFlavor) && dropTargetDropEvent.getDropAction() == 0x40000000) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int handleDrop(VisDisplay2 visDisplay2, DropTargetDropEvent dropTargetDropEvent) {
        try {
            ISynchronizationPosition iSynchronizationPosition;
            IPatientRepresentation iPatientRepresentation;
            IDisplaySet iDisplaySet = (IDisplaySet)dropTargetDropEvent.getTransferable().getTransferData(IDisplaySet.dataFlavor);
            if (iDisplaySet == null) {
                return 0;
            }
            if (visDisplay2.handleDropAction(dropTargetDropEvent, iDisplaySet)) {
                int n = dropTargetDropEvent.getDropAction();
                return n;
            }
            int[] nArray = visDisplay2.getDropLocation(dropTargetDropEvent);
            int n = nArray[0];
            int n2 = nArray[1];
            boolean bl = visDisplay2.isInsideVisibleDropRegion(VisDisplay2.DropRegionType.AUTO_SCROLL, n, n2);
            if (visDisplay2.isShowingDropRegion(VisDisplay2.DropRegionType.INSERT)) {
                int n3;
                boolean bl2 = visDisplay2.getDropInsertRectBefore().contains(n, n2);
                boolean bl3 = visDisplay2.getDropInsertRectAfter().contains(n, n2);
                if (bl2) {
                    log.debug("INSERT BEFORE");
                }
                if (bl3) {
                    log.debug("INSERT AFTER");
                }
                visDisplay2.hideAllDropRegions();
                if (bl2) {
                    if (!VisDisplayUtils.checkInsertBefore(JVision2.getMainFrame().getDisplays(), visDisplay2, true) && (n3 = Message.yesNo(Messages.getString("QUESTION"), Messages.getString("VISDISPLAY_INSERT_ASK_REMOVE_LAST_DISPLAY"))) != 0) {
                        return 0;
                    }
                    visDisplay2 = VisDisplayUtils.insertDisplayBefore(JVision2.getMainFrame().getDisplays(), visDisplay2, true);
                } else if (bl3) {
                    int n4;
                    n3 = JVision2.getMainFrame().getDisplays().indexOf(visDisplay2);
                    if (n3 >= JVision2.getMainFrame().getDisplays().size() - 1) {
                        return 0;
                    }
                    VisDisplay2 visDisplay22 = JVision2.getMainFrame().getDisplays().get(n3 + 1);
                    if (!VisDisplayUtils.checkInsertBefore(JVision2.getMainFrame().getDisplays(), visDisplay22, true) && (n4 = Message.yesNo(Messages.getString("QUESTION"), Messages.getString("VISDISPLAY_INSERT_ASK_REMOVE_LAST_DISPLAY"))) != 0) {
                        return 0;
                    }
                    visDisplay2 = VisDisplayUtils.insertDisplayBefore(JVision2.getMainFrame().getDisplays(), visDisplay22, true);
                }
            }
            if ((iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient()) != null && iDisplaySet == iPatientRepresentation.getDecompositionRuntime().getKeyImageDisplaySet(iDisplaySet.getStudy())) {
                visDisplay2.setLytMode(visDisplay2.getLyt(), 1, 1, true, false);
            }
            IImagePlaneInformation iImagePlaneInformation = bl && DisplaySetContainerVisDisplayDropHandler.isEqualFrameOfReference(visDisplay2, iDisplaySet) ? visDisplay2.getSynchronizationManager().getActiveImagePlaneInformation() : null;
            visDisplay2.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
            if (iImagePlaneInformation != null && (iSynchronizationPosition = visDisplay2.getSynchronizationManager().searchAppropriateSynchronizationPosition(iImagePlaneInformation)) != null) {
                visDisplay2.getNavigationHandler().handleNavigationEvent(VisNavigationEvent.createAbsoluteMoveEvent(iSynchronizationPosition.getNavigationIndex()));
            }
            int n5 = dropTargetDropEvent.getDropAction();
            return n5;
        }
        catch (Exception exception) {
            log.error("drop", (Throwable)exception);
            return 0;
        }
        finally {
            visDisplay2.hideAllDropRegions();
        }
    }

    @Override
    public int chooseAction(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getSourceActions();
        if ((n & 0x40000000) == 0x40000000) {
            return 0x40000000;
        }
        if ((n & 1) == 1) {
            return 1;
        }
        return dropTargetDragEvent.getDropAction();
    }
}

