/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.event;

import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.event.IZoomablePixelSizeProvider;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.IViewportHandler;
import com.tiani.jvision.image.IVisView;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.renderer.IMatchSizeRenderer;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisData;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;

class RelativeZoomParameter
extends ZoomParameter {
    private final double relativeZoomFactorChange;
    private final double density;
    private final SpacingDef spacing;
    private final boolean isMatchForced;
    private final double[] interchangeableViewportCenter;

    private RelativeZoomParameter(IZoomablePixelSizeProvider iZoomablePixelSizeProvider, double d, double[] dArray, boolean bl) {
        this.relativeZoomFactorChange = d;
        this.interchangeableViewportCenter = dArray;
        this.density = ZoomParameter.getDensity(iZoomablePixelSizeProvider);
        this.spacing = iZoomablePixelSizeProvider.getCurrentSpacingDef();
        this.isMatchForced = bl;
    }

    static RelativeZoomParameter forceMatchSize(IZoomablePixelSizeProvider iZoomablePixelSizeProvider) {
        return new RelativeZoomParameter(iZoomablePixelSizeProvider, Double.NaN, iZoomablePixelSizeProvider.getInterchangeableViewportCenter(), true);
    }

    static RelativeZoomParameter create(IZoomablePixelSizeProvider iZoomablePixelSizeProvider, double d, double[] dArray) {
        return new RelativeZoomParameter(iZoomablePixelSizeProvider, d, dArray, false);
    }

    @Override
    public ZoomParameter.ZoomParameterApplicationResult applyTo(IRDCRenderer iRDCRenderer, IVisView iVisView) {
        return this.applyTo(iRDCRenderer, iVisView, d -> this.applyRelativeZoomFactorChange(d, iRDCRenderer, iVisView), iRDCRenderer::restoreViewportCenterAfterZoom);
    }

    @Override
    public ZoomParameter.ZoomParameterApplicationResult applyTo(IViewportHandler iViewportHandler, View view) {
        DoubleConsumer doubleConsumer = d -> this.applyRelativeZoomFactorChange(d, iViewportHandler, view);
        Consumer<double[]> consumer = dArray -> {
            boolean bl = iViewportHandler.handleTEvent(new TEvent(2), dArray, 0, view);
        };
        Renderer renderer = view.getRenderer();
        if (renderer instanceof IMatchSizeRenderer) {
            return this.applyTo((IMatchSizeRenderer)((Object)renderer), view, doubleConsumer, consumer);
        }
        return this.applyRelativeZoomFactorChange(doubleConsumer, consumer);
    }

    private ZoomParameter.ZoomParameterApplicationResult applyTo(IMatchSizeRenderer iMatchSizeRenderer, IVisView iVisView, DoubleConsumer doubleConsumer, Consumer<double[]> consumer) {
        if (this.isMatchSizeEnabled(iVisView) && iMatchSizeRenderer.isMatchSizeSupported() && this.hasMatchingAspectRatio(iMatchSizeRenderer)) {
            Object object;
            boolean bl;
            int n = iVisView.getcwidth();
            iMatchSizeRenderer.setGeometry(n, iVisView.getcheight(), 0, n);
            double d = ZoomParameter.getDensity(iMatchSizeRenderer) / this.density;
            boolean bl2 = !Double.isNaN(d) && !Double.isInfinite(d);
            boolean bl3 = bl = bl2 && !DoubleEquals.equals((double)d, (double)1.0);
            if (bl) {
                object = iMatchSizeRenderer.getAreaFitHandler();
                if (object != null) {
                    object.unpinZoomFactor();
                }
                this.applyRelativeZoomFactorChange(d, doubleConsumer, consumer);
            }
            object = bl ? ZoomParameter.ZoomParameterApplicationResult.APPLIED : (bl2 ? ZoomParameter.ZoomParameterApplicationResult.NO_CHANGE_NECESSARY : ZoomParameter.ZoomParameterApplicationResult.UNSUPPORTED);
            return object;
        }
        return this.applyRelativeZoomFactorChange(doubleConsumer, consumer);
    }

    private ZoomParameter.ZoomParameterApplicationResult applyRelativeZoomFactorChange(DoubleConsumer doubleConsumer, Consumer<double[]> consumer) {
        if (Double.isNaN(this.relativeZoomFactorChange)) {
            return ZoomParameter.ZoomParameterApplicationResult.UNSUPPORTED;
        }
        this.applyRelativeZoomFactorChange(this.relativeZoomFactorChange, doubleConsumer, consumer);
        return ZoomParameter.ZoomParameterApplicationResult.APPLIED;
    }

    private void applyRelativeZoomFactorChange(double d, DoubleConsumer doubleConsumer, Consumer<double[]> consumer) {
        doubleConsumer.accept(d);
        if (this.interchangeableViewportCenter != null) {
            consumer.accept(this.interchangeableViewportCenter);
        }
    }

    private boolean isMatchSizeEnabled(IVisView iVisView) {
        if (iVisView == null) {
            return false;
        }
        if (this.isMatchForced) {
            return true;
        }
        VisData visData = iVisView.getVis();
        return visData != null && visData.getParent().getVisDisplay().getSynchronizationManager().isMatchSizeOnSynchronisation();
    }

    private boolean hasMatchingAspectRatio(IMatchSizeRenderer iMatchSizeRenderer) {
        return this.spacing != null && DoubleEquals.equals((double)this.spacing.getAspectRatio(), (double)iMatchSizeRenderer.getCurrentSpacingDef().getAspectRatio(), (double)1.0E-4);
    }

    private void applyRelativeZoomFactorChange(double d, IRDCRenderer iRDCRenderer, IVisView iVisView) {
        iRDCRenderer.getAreaFitHandler().applyRelativeZoomFactorChange(d, iRDCRenderer.getActiveImageDef(), iVisView);
    }

    private void applyRelativeZoomFactorChange(double d, IViewportHandler iViewportHandler, View view) {
        iViewportHandler.setZoomFactor(iViewportHandler.getZoomFactor() * d, view);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append('[');
        if (!Double.isNaN(this.density)) {
            stringBuilder.append("density=").append(this.density);
        }
        if (!Double.isNaN(this.relativeZoomFactorChange)) {
            if (!Double.isNaN(this.density)) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("relativeZoomFactorChange=").append(this.relativeZoomFactorChange);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

