/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.event;

import com.tiani.jvision.event.AbsoluteZoomParameter;
import com.tiani.jvision.event.IZoomablePixelSizeProvider;
import com.tiani.jvision.event.RelativeZoomParameter;
import com.tiani.jvision.image.IViewportHandler;
import com.tiani.jvision.image.IVisView;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.IPixelSizeProvider;
import com.tiani.jvision.renderer.IRDCRenderer;

public abstract class ZoomParameter {
    protected ZoomParameter() {
    }

    public static double getDensity(IPixelSizeProvider iPixelSizeProvider) {
        return iPixelSizeProvider.getScreenPixelSizeX();
    }

    public static ZoomParameter matchSize(IZoomablePixelSizeProvider iZoomablePixelSizeProvider) {
        return RelativeZoomParameter.forceMatchSize(iZoomablePixelSizeProvider);
    }

    public static ZoomParameter relative(IZoomablePixelSizeProvider iZoomablePixelSizeProvider, double d) {
        return ZoomParameter.relative(iZoomablePixelSizeProvider, d, iZoomablePixelSizeProvider.getInterchangeableViewportCenter());
    }

    public static ZoomParameter relative(IZoomablePixelSizeProvider iZoomablePixelSizeProvider, double d, double[] dArray) {
        return RelativeZoomParameter.create(iZoomablePixelSizeProvider, d, dArray);
    }

    public static ZoomParameter absolute(double d) {
        return new AbsoluteZoomParameter(d);
    }

    public abstract ZoomParameterApplicationResult applyTo(IRDCRenderer var1, IVisView var2);

    public abstract ZoomParameterApplicationResult applyTo(IViewportHandler var1, View var2);

    public static enum ZoomParameterApplicationResult {
        APPLIED,
        NO_CHANGE_NECESSARY,
        UNSUPPORTED;

    }
}

