/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import java.awt.Color;
import java.awt.event.MouseEvent;

public abstract class AbstractWaitingView
extends View {
    private volatile IFrameObjectData[] fods;
    private boolean destroyed;
    private boolean started = false;
    private boolean failed = false;
    public boolean exportFinished = false;
    private boolean exportStarted = false;
    protected IDisplaySet displaySet;

    protected AbstractWaitingView(IFrameObjectData[] iFrameObjectDataArray, IDisplaySet iDisplaySet) {
        this(iFrameObjectDataArray[0], iFrameObjectDataArray, iDisplaySet);
    }

    protected AbstractWaitingView(IFrameObjectData iFrameObjectData, IFrameObjectData[] iFrameObjectDataArray, IDisplaySet iDisplaySet) {
        super(iFrameObjectData);
        this.fods = iFrameObjectDataArray;
        this.displaySet = iDisplaySet;
        this.destroyed = false;
    }

    protected IFrameObjectData[] getFrames() {
        return this.fods;
    }

    protected void dataFetchFinished() {
        if (this.doFetch()) {
            this.replaceWaitingView(this.createDisplayViews(this.fods));
        }
    }

    protected void replaceWaitingView(View[] viewArray) {
        VisDisplay2 visDisplay2 = this.getDisplay();
        if (visDisplay2 == null) {
            this.failed = true;
            return;
        }
        if (viewArray == null || viewArray.length == 0) {
            visDisplay2.revertToDefaultPlugin();
            return;
        }
        EventUtil.invoke(() -> this.replaceViews(visDisplay2, viewArray));
    }

    protected void replaceViews(VisDisplay2 visDisplay2, View[] viewArray) {
        visDisplay2.replaceView((View)this, viewArray);
        this.onAppendViews(viewArray);
        VisData visData = VisData.getLastModified();
        if (visData != null && visData.getView() == this) {
            viewArray[0].getVis().makeTheLastModified();
        }
    }

    public abstract View[] createDisplayViews(IFrameObjectData[] var1);

    public void onAppendViews(View[] viewArray) {
    }

    @Override
    public ImageState getImageState() {
        return ImageState.getDefaultImageState();
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (this.failed) {
            int n = this.getBounds().width;
            int n2 = this.getBounds().height;
            rGBBufferedImageHolder.graphics.setColor(Color.black);
            rGBBufferedImageHolder.graphics.fillRect(0, 0, n, n2);
            rGBBufferedImageHolder.graphics.drawImage(failIcon, 0, 0, n, n2, null);
            return;
        }
        if (!this.started) {
            this.started = true;
            this.startDataFetching(this.fods);
        }
        rGBBufferedImageHolder.graphics.clearRect(0, 0, rGBBufferedImageHolder.width - 1, rGBBufferedImageHolder.height - 1);
    }

    protected abstract void startDataFetching(IFrameObjectData[] var1);

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.fods != null) {
            this.fods = null;
        }
        this.destroyed = true;
    }

    public final boolean doFetch() {
        return !this.destroyed;
    }

    public final void dataFetchFailed(String string) {
        this.failed = true;
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
        return null;
    }

    @Override
    public final String getVisualType() {
        return "";
    }

    @Override
    public void handleHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
    }

    @Override
    public void handleHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void handleHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
    }

    @Override
    public final boolean isFunctional() {
        return true;
    }

    @Override
    public final void onCanvasSizeChanged(boolean bl) {
    }

    @Override
    public final void reset() {
    }

    @Override
    public void progressNotification(String string, double d) {
        if (!this.exportStarted) {
            this.exportStarted = true;
        }
        super.progressNotification(string, d);
        if (d == 1.0) {
            this.exportFinished = true;
        }
    }

    @Override
    public boolean isCine() {
        return true;
    }
}

