/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ICalibrationData;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.PixelSizeCalibrationDialog;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.ArrayList;

public class CalibrationAction
extends AbstractPAction {
    public static final String ID = "IMAGE_CALIBRATION";

    @Override
    public String getCaption() {
        return Messages.getString("ImgView2.CalibratePixelSize");
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    protected boolean isEnabledImpl() {
        PluginName pluginName;
        VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
        if (visDisplay2 != null && visDisplay2.hasData() && ((pluginName = visDisplay2.getData().getPlugin().getPluginName()) == PluginName.DEFAULT || pluginName == PluginName.ADDSUB)) {
            IImageInformation iImageInformation = AbstractPDataAction.getCurrentImage().getImageInformation();
            boolean bl = iImageInformation.hasImageRegionSpacing();
            boolean bl2 = ImageDef.hasQuadraticPixels(iImageInformation);
            return !bl && bl2;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return !Product.isCDViewer() && !Product.isReducedVersion();
    }

    @Override
    public boolean perform(Component component) {
        VisData visData;
        ICalibrationData iCalibrationData;
        block12: {
            block11: {
                this.notifyActionPerformed();
                iCalibrationData = null;
                visData = AbstractPDataAction.getCurrentImage();
                if (visData != null) break block11;
                return false;
            }
            if (visData.getView() instanceof ImgView2) break block12;
            return false;
        }
        try {
            ImgView2 imgView2 = (ImgView2)visData.getView();
            ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
            for (Overlay overlay : imgView2.getOverlays()) {
                if (!(overlay instanceof ICalibrationData)) continue;
                arrayList.add(overlay);
            }
            if (arrayList.size() == 1) {
                iCalibrationData = (ICalibrationData)arrayList.get(0);
            } else if (arrayList.size() > 1) {
                for (Overlay overlay : arrayList) {
                    if (!(overlay instanceof PresentationObject) || !((PresentationObject)overlay).isSelected()) continue;
                    iCalibrationData = (ICalibrationData)((Object)overlay);
                    break;
                }
            }
            if (iCalibrationData == null) {
                Message.info(Messages.getString(arrayList.size() > 1 ? "VISPOPUP_IMAGE_CALIBRATION_DLG_SELECT_OVERLAY" : "VISPOPUP_IMAGE_CALIBRATION_DLG_NOOVERLAY"));
            } else {
                PixelSizeCalibrationDialog.show(imgView2, iCalibrationData);
            }
        }
        catch (Exception exception) {}
        return true;
    }
}

