/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.listtext.dicomobject.interfaces.ICompositeInformationObject;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ImagePresentationStateInfo;
import com.agfa.pacs.listtext.lta.base.controls.PermissionUtilities;
import com.agfa.pacs.listtext.lta.deletion.DeletionUtils;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.AbstractPresentationStateAction;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.PSChooserAction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class DeletePresentationStateAction
extends AbstractPresentationStateAction {
    private static final ALogger LOGGER = ALogger.getLogger(DeletePresentationStateAction.class);
    private static final String ALL_PS_KEY = "DeleteDicomObjects/DeletePresentationStates";
    private static final String OWN_PS_KEY = "DeleteDicomObjects/DeletePresentationStates/DeleteOwnPresentationStates";
    private static final String MANUFACTURER_NAME = "agfa healthcare";

    public DeletePresentationStateAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        super(pDataScope, pDataProvider);
    }

    @Override
    public String getCaption() {
        return Messages.getString("DeletePresentationStateAction.Caption");
    }

    @Override
    public boolean isAvailable() {
        boolean bl = Permissions.getInstance().isAllowed(ALL_PS_KEY);
        boolean bl2 = Permissions.getInstance().isAllowed(OWN_PS_KEY);
        return bl || bl2;
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    @Override
    int getMinimumRequiredPresentationStateCount() {
        return 1;
    }

    @Override
    boolean isSubmenuExclusive() {
        return false;
    }

    @Override
    List<PAction> getSubactionsImpl() {
        List<IPresentationStateInfo> list = this.getPresentationStates();
        ArrayList<PAction> arrayList = new ArrayList<PAction>(list.size());
        for (IPresentationStateInfo iPresentationStateInfo : list) {
            arrayList.add(new DeletePSAction(iPresentationStateInfo));
        }
        return arrayList;
    }

    @Override
    List<IPresentationStateInfo> getPresentationStates() {
        List<IPresentationStateInfo> list = super.getPresentationStates();
        if (list != null) {
            Iterator<IPresentationStateInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Attributes attributes;
                IPresentationStateInfo iPresentationStateInfo = iterator.next();
                if (!iPresentationStateInfo.isExternal() || iPresentationStateInfo.isTemporary()) {
                    iterator.remove();
                    continue;
                }
                boolean bl2 = Permissions.getInstance().isAllowed(OWN_PS_KEY);
                boolean bl3 = Permissions.getInstance().isAllowed(ALL_PS_KEY);
                if (bl3 == bl2 || (attributes = iPresentationStateInfo.getDataset()) == null) continue;
                String string = attributes.getString(524400);
                String string2 = attributes.getString(528528);
                boolean bl4 = bl = Product.getProductName().equalsIgnoreCase(string2) && (Product.getProductVendor().equalsIgnoreCase(string) || StringUtils.containsIgnoreCase((CharSequence)Product.getProductVendor(), (CharSequence)MANUFACTURER_NAME));
                if ((!bl || bl2) && (bl || bl3)) continue;
                iterator.remove();
            }
        }
        return list;
    }

    @Override
    String getDataActionID() {
        return "DELETE_PRESENTATION_STATE";
    }

    boolean deletePresentationState(Component component, IPresentationStateInfo iPresentationStateInfo) {
        boolean bl = false;
        if (!this.isAvailable()) {
            PermissionUtilities.showPermissionDeniedDialog((Component)component, null);
        } else if (this.askForUserConfirmation(component, iPresentationStateInfo)) {
            List list = iPresentationStateInfo.getDicomInformationObjects();
            if (list.size() == 1) {
                try {
                    bl = this.deletePresentationState(iPresentationStateInfo, (ICompositeInformationObject)list.get(0));
                }
                catch (Exception exception) {
                    LOGGER.error("Deleting presentation state failed.", (Throwable)exception);
                    bl = false;
                }
            }
            if (!bl) {
                this.informUserOfDeletionFailure(component, iPresentationStateInfo);
            }
        }
        return bl;
    }

    private boolean askForUserConfirmation(Component component, IPresentationStateInfo iPresentationStateInfo) {
        return ComponentFactory.instance.showYesNoDialog(Messages.getString("DeletePresentationStateAction.UserConfirmation.Title"), this.getUserMessage("UserConfirmation", iPresentationStateInfo), component);
    }

    private boolean deletePresentationState(IPresentationStateInfo iPresentationStateInfo, ICompositeInformationObject iCompositeInformationObject) {
        IStudyData iStudyData = DataManager.getInstance().getStudyByStudyInstanceUID(iCompositeInformationObject.getStudyIdentifier().getStudyInstanceUID());
        IDataInfoSource iDataInfoSource = null;
        Sequence sequence = iPresentationStateInfo.getDataset().getSequence(528661);
        if (sequence != null && !sequence.isEmpty()) {
            String string = ((Attributes)sequence.get(0)).getString(0x20000E);
            ISeriesData iSeriesData = DataManager.getInstance().getSerie(string);
            if (iSeriesData != null) {
                iDataInfoSource = iSeriesData.getQueryObject().getSource();
            }
        }
        if (iDataInfoSource == null && iStudyData != null) {
            iDataInfoSource = ((IStudyInfo)iStudyData.getQueryObject()).getSource();
        }
        if (iStudyData != null && iDataInfoSource != null && DeletionUtils.deleteInstance((IStudyInfo)((IStudyInfo)iStudyData.getQueryObject()), (IDataInfoSource)iDataInfoSource, (String)iCompositeInformationObject.getSeriesIdentifier().getSeriesInstanceUID(), (String)iCompositeInformationObject.getSOPInstanceUID(), (String)iCompositeInformationObject.getSOPClassUID())) {
            iStudyData.getFramePresentationStateProviderContainer().remove(iPresentationStateInfo);
            this.updatePresentationStateForCurrentDisplay(iPresentationStateInfo);
            return true;
        }
        return false;
    }

    private void updatePresentationStateForCurrentDisplay(IPresentationStateInfo iPresentationStateInfo) {
        VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
        for (VisData visData : visDisplay2.getVis()) {
            View view = visData.getView();
            if (!this.isPresentationStateActive(view, iPresentationStateInfo)) continue;
            this.revertToDefaultPresentationState(visDisplay2);
            break;
        }
        if (visDisplay2.hasAction("PS_CHOOSER")) {
            ((PSChooserAction)visDisplay2.getAction("PS_CHOOSER")).selectionChanged();
        }
    }

    private boolean isPresentationStateActive(View view, IPresentationStateInfo iPresentationStateInfo) {
        return view instanceof ImgView2 && iPresentationStateInfo.contains(((ImgView2)view).getCurrentFramePresentationState().getProviderUID());
    }

    private void revertToDefaultPresentationState(VisDisplay2 visDisplay2) {
        for (VisData visData : visDisplay2.getVis()) {
            View view = visData.getView();
            view.applyPresentationState((IFramePresentationStateSource)ImagePresentationStateInfo.staticInstance);
        }
    }

    private void informUserOfDeletionFailure(Component component, IPresentationStateInfo iPresentationStateInfo) {
        ComponentFactory.instance.showErrorDialog(Messages.getString("DeletePresentationStateAction.DeletionFailure.Title"), this.getUserMessage("DeletionFailure", iPresentationStateInfo), component);
    }

    private String getUserMessage(String string, IPresentationStateInfo iPresentationStateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\'');
        stringBuilder.append(iPresentationStateInfo);
        stringBuilder.append('\'');
        Date date = iPresentationStateInfo.getCreationDateTime();
        if (date != null) {
            stringBuilder.append(' ');
            stringBuilder.append(Messages.getString("DeletePresentationStateAction.from"));
            stringBuilder.append(' ');
            stringBuilder.append(DateTimeUtils.date2String((Date)date));
        }
        return MessageFormat.format(Messages.getString("DeletePresentationStateAction." + string + ".Message"), stringBuilder.toString());
    }

    private class DeletePSAction
    extends AbstractPresentationStateAction.AbstractAnonymousPSAction {
        public DeletePSAction(IPresentationStateInfo iPresentationStateInfo) {
            super(iPresentationStateInfo);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed("DELETE_PRESENTATION_STATE");
            DeletePresentationStateAction.this.deletePresentationState(component, this.ps);
            return true;
        }
    }
}

