/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.IViewDimension;
import com.tiani.jvision.image.IViewportHandler;
import com.tiani.jvision.image.IVisView;
import com.tiani.jvision.image.View;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.vis.VisData;

class EarlyZoomParameter
extends ZoomParameter {
    private final ZoomParameter delegate;
    private final int viewWidth;
    private final int viewHeight;

    EarlyZoomParameter(ZoomParameter zoomParameter, IViewDimension iViewDimension) {
        this.delegate = zoomParameter;
        this.viewWidth = iViewDimension.getcwidth();
        this.viewHeight = iViewDimension.getcheight();
    }

    int getViewWidth() {
        return this.viewWidth;
    }

    int getViewHeight() {
        return this.viewHeight;
    }

    @Override
    public ZoomParameter.ZoomParameterApplicationResult applyTo(IRDCRenderer iRDCRenderer, final IVisView iVisView) {
        return this.delegate.applyTo(iRDCRenderer, new IVisView(){

            @Override
            public int getcwidth() {
                return EarlyZoomParameter.this.getViewWidth();
            }

            @Override
            public int getcheight() {
                return EarlyZoomParameter.this.getViewHeight();
            }

            @Override
            public VisData getVis() {
                return iVisView.getVis();
            }
        });
    }

    @Override
    public ZoomParameter.ZoomParameterApplicationResult applyTo(IViewportHandler iViewportHandler, View view) {
        throw new UnsupportedOperationException("Early events not supported for viewport handler");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[delegate=");
        stringBuilder.append(this.delegate);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

