/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.hap.pacs.data.valuemapping.IValueMappingFactory;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.ImageUtils;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.config.ConfigUtils;
import com.agfa.pacs.impaxee.data.fetcher.FetcherUtils;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.livesync.ILiveSyncPosition;
import com.agfa.pacs.impaxee.livesync.ILiveSyncView;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeActionProvider;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.rotation.FreeRotationAngle;
import com.agfa.pacs.impaxee.rotation.FreeRotationRenderer;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageInformationProvider;
import com.tiani.base.data.RawDataContainer;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.EarlyZoomParameter;
import com.tiani.jvision.image.FakePresentationState;
import com.tiani.jvision.image.ICalibrationData;
import com.tiani.jvision.image.IEarlyEvent;
import com.tiani.jvision.image.LayeredView;
import com.tiani.jvision.image.LossyFramePresentationState;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowHandlerNuk;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.overlay.LeftMarkerPolygonOverlay;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.LocalizerHighlight;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import com.tiani.jvision.overlay.MagnifierOverlay;
import com.tiani.jvision.overlay.MagnifyingGlassOverlay2;
import com.tiani.jvision.overlay.MiniLocalizerOverlay;
import com.tiani.jvision.overlay.OrientationMapping2D;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.PictureInPictureOverlay;
import com.tiani.jvision.overlay.PictureInPictureOverlaySyncData;
import com.tiani.jvision.overlay.PointOverlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RightMarkerPolygonOverlay;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.StatisticsPresentationObject;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.demographics.MappingFactory;
import com.tiani.jvision.overlay.localizer.ActiveLocalizerHandler;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.overlay.localizer.LocalizerFactory;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.overlay.localizer.MiniLocalizerSyncData;
import com.tiani.jvision.overlay.provider.IOverlayProvider;
import com.tiani.jvision.overlay.provider.OverlayProviderFactory;
import com.tiani.jvision.overlay.statistics.OverlayStatisticsAction;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.ResultCacheNode;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.toptoolbar.MagnifierAction;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisHRSetDefault;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class ImgView2
extends LayeredView
implements IFrameListener,
ILiveSyncView {
    private static final ALogger log = ALogger.getLogger(ImgView2.class);
    public static final EnumSet<IImageInformation.ImageClass> LOCALIZER_IMAGE_CLASSES = EnumSet.of(IImageInformation.ImageClass.CT, IImageInformation.ImageClass.MR, IImageInformation.ImageClass.OPT2D);
    private static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    private static final String SELECTION_CONDITION = Config.impaxee.jvision.AUTO.SelectOnLoadCondition.get();
    private static PAction localizerMRDisplay = PActionRegistry.getAction("LOCALIZER_CALCULATION");
    private static final boolean SELECTED_BY_DEFAULT = SELECTION_CONDITION.equals("1==1");
    private static final TIcon videoIcon = new TIcon("/icons/VideoPlayPoster.gif");
    private static final TIcon USVolumeIcon = new TIcon("/icons/USVolumePoster.png");
    protected static final int ST_EMPTY = 0;
    protected static final int ST_POSTER = 1;
    protected static final int ST_COMPLETE = 4;
    protected static final int ST_DESTROYED = 5;
    protected static final int ST_FAILED = 6;
    protected int state = 0;
    protected IRDCRenderer renderer;
    private Localizer topo;
    private PictureInPictureOverlay pip;
    protected MagnifierOverlay magnifyingGlass = null;
    private List<IEarlyEvent> earlyEvents = new ArrayList<IEarlyEvent>(5);
    private List<Object> earlyPayloads = new ArrayList<Object>(5);
    private volatile boolean frameAlreadyAdded = false;

    public ImgView2(IFrameObjectData iFrameObjectData, IDisplaySet iDisplaySet) {
        super(iFrameObjectData);
        this.evaluationContext = new DisplaySetEvaluable(iFrameObjectData, iDisplaySet, (View)this);
        this.addOverlay(new OrientationMapping2D(this));
        this.addOverlay(new RulerMapping(this));
    }

    @Override
    public void notifyHasError(String string) {
        this.state = 6;
        this.invalidate();
        if (this.vis != null && this.vis.isInView()) {
            this.repaint();
        }
    }

    protected void addData(IFrameObjectData iFrameObjectData) {
        if (iFrameObjectData.getRawDataContainer() != null) {
            if (DataManager.isLossyPrefetchingEnabled() && iFrameObjectData.isBeingLossyPrefetched()) {
                this.frameAvailable(iFrameObjectData, null);
                iFrameObjectData.addListener(this);
            } else {
                this.frameAvailable(iFrameObjectData, null);
            }
        } else {
            iFrameObjectData.addListener(this);
        }
    }

    protected boolean isSelectedByDefault() {
        boolean bl = SELECTED_BY_DEFAULT;
        if (!bl) {
            bl = this.isSelectOnLoadAndHavingDisplay(this.getFrameData());
        }
        return bl;
    }

    private void initDefaultSelection() {
        if (this.vis != null) {
            this.vis.setSelected(this.isSelectedByDefault(), true);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void setVis(VisData visData) {
        super.setVis(visData);
        this.frameData = visData.getFrameData();
        this.addData(visData.getFrameData());
        this.initDefaultSelection();
    }

    @Override
    public void visSet(Vis2 vis2) {
        super.visSet(vis2);
        if (vis2 != null && this.magnifyingGlass != null) {
            int n = 0;
            int n2 = 0;
            if (vis2.getMouseHandler() != null && vis2.getMouseHandler().getMousePosition() != null) {
                n = vis2.getMouseHandler().getMousePosition().x;
                n2 = vis2.getMouseHandler().getMousePosition().y;
            }
            this.enableMagnifyingGlassInternal(n, n2);
        }
    }

    private boolean isSelectOnLoadAndHavingDisplay(IFrameObjectData iFrameObjectData) {
        return this.getDisplay() != null && ConfigUtils.evaluate(SELECTION_CONDITION, iFrameObjectData, Config.impaxee.jvision.AUTO.SelectOnLoadCondition.getKey());
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isFunctional() {
        if (this.frameData == null) {
            return false;
        }
        return this.state > 0;
    }

    public boolean canHaveLocalizer() {
        IImageInformation.ImageClass imageClass = this.getImageInformation().getImageClass();
        return LOCALIZER_IMAGE_CLASSES.contains((Object)imageClass);
    }

    public boolean isLocalizerEnabled() {
        return this.topo != null && this.topo.isVisible();
    }

    public void toggleMiniLocalizer() {
        IImageInformationProvider iImageInformationProvider;
        Object object;
        if (!this.isMiniLocalizerSupportedForCurrentPlugin()) {
            String string = this.getVis().getParent().getPlugin().getDescription();
            log.debug("Mini localizer not supported for current plugin: " + string);
            Message.info(Messages.getString("ImgView2.MiniLocalizerNotSupported.Title"), MessageFormat.format(Messages.getString("ImgView2.MiniLocalizerNotSupportedForPlugin.Message"), string));
            return;
        }
        if (!this.isMiniLocalizerEnabled() && this.isFreeRotationActive()) {
            log.debug("Mini localizer not supported while free rotation is active");
            Message.info(Messages.getString("ImgView2.MiniLocalizerNotSupported.Title"), Messages.getString("FreeRotation.MiniLocalizerNotSupported.Message"));
            return;
        }
        if (this.topo == null) {
            object = new ActiveLocalizerHandler(this);
            iImageInformationProvider = new Localizer((ActiveLocalizerHandler)object, this.getImageInformation(), this.getDisplayData().getDisplaySetID());
            iImageInformationProvider.setVisible(false);
            this.activateLocalizer((Localizer)iImageInformationProvider);
        }
        this.topo.setMiniLocalizer(!this.topo.isMiniLocalizer());
        object = new TEvent();
        ((TEvent)object).source = this;
        ((TEvent)object).id = 92;
        iImageInformationProvider = new ResultCacheNode(this.renderert.getPaintRoot().clone());
        MiniLocalizerSyncData miniLocalizerSyncData = new MiniLocalizerSyncData((Renderer)iImageInformationProvider, this.topo);
        TEventDispatch.sendEvent((TEvent)object, (Object)miniLocalizerSyncData, 36);
    }

    public void togglePictureInPicture() {
        if (!this.isPictureInPictureSupportedForCurrentPlugin()) {
            String string = this.getVis().getParent().getPlugin().getDescription();
            log.debug("Picture-in-picture overlay not supported for current plugin: " + string);
            Message.info(Messages.getString("ImgView2.PictureInPictureNotSupported.Title"), MessageFormat.format(Messages.getString("ImgView2.PictureInPictureNotSupportedForPlugin.Message"), string));
            return;
        }
        if (this.isFreeRotationActive()) {
            log.debug("Picture-in-picture overlay not supported while free rotation is active");
            Message.info(Messages.getString("ImgView2.PictureInPictureNotSupported.Title"), Messages.getString("FreeRotation.PictureInPictureNotSupported.Message"));
            return;
        }
        TEvent tEvent = new TEvent();
        tEvent.source = this;
        tEvent.id = 119;
        PictureInPictureOverlaySyncData pictureInPictureOverlaySyncData = this.pip == null ? new PictureInPictureOverlaySyncData() : null;
        TEventDispatch.sendEvent(this.getDisplay(), tEvent, (Object)pictureInPictureOverlaySyncData, false);
    }

    protected boolean isPictureInPictureSupportedForCurrentPlugin() {
        return true;
    }

    protected boolean isMiniLocalizerSupportedForCurrentPlugin() {
        return true;
    }

    public boolean isMiniLocalizerEnabled() {
        if (this.topo == null) {
            return false;
        }
        return this.topo.isMiniLocalizer();
    }

    @Override
    protected BufferedImage getPoster() {
        Image image = null;
        UIDType uIDType = UIDUtilities.getBaseType((String)this.frameData.getSOPClassUID());
        if (uIDType == UIDType.Video) {
            image = videoIcon.getImage();
        } else if (uIDType == UIDType.USVolume) {
            image = USVolumeIcon.getImage();
        }
        if (image != null) {
            return ImageUtils.toBufferedImage((Image)image);
        }
        return null;
    }

    protected void addToRendererTree(IFrameObjectData iFrameObjectData, boolean bl, String string) {
        this.renderer = this.createRenderer(iFrameObjectData, bl);
        if (this.renderer != null) {
            this.renderer.setNodeID(1);
            this.renderer.setBorderLockMode(false);
            this.renderert.setRoot((Renderer)((Object)this.renderer), this);
        }
    }

    protected RDCRenderer createRenderer(IFrameObjectData iFrameObjectData, boolean bl) {
        return RDCRenderer.createRenderer(iFrameObjectData, !bl, ZoomMode.NORMAL);
    }

    protected void initMapping(IEvaluationContext iEvaluationContext) {
        Mapping mapping = MappingFactory.getMapping(iEvaluationContext, false);
        this.setMapping(mapping);
        this.addOverlay(mapping);
    }

    private void initInternal() {
        if (this.state == 6) {
            return;
        }
        try {
            if (this.getMapping() == null) {
                if (this.evaluationContext == null) {
                    log.error("evaluation context null");
                }
                this.initMapping(this.evaluationContext);
            } else {
                this.getMapping().updateContent(this.getEvaluationContext(), true, true);
            }
            this.getMapping().setSize(this.getcwidth(), this.getcheight(), super.getImageState());
            this.initLocalizer();
            EventUtil.invoke(this::sendEarlyEvents);
        }
        catch (Exception exception) {
            log.error("Load failed", (Throwable)exception);
            this.state = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEarlyEvents() {
        ImgView2 imgView2 = this;
        synchronized (imgView2) {
            if (this.earlyEvents != null) {
                this.state = 4;
                if (!this.earlyEvents.isEmpty()) {
                    List<IEarlyEvent> list = this.earlyEvents;
                    List<Object> list2 = this.earlyPayloads;
                    this.earlyEvents = null;
                    this.earlyPayloads = null;
                    int n = 0;
                    ImgView2.setGlobalEnabled(false);
                    while (n < list.size()) {
                        try {
                            IEarlyEvent iEarlyEvent;
                            Object object = list2.get(n);
                            IEarlyEvent iEarlyEvent2 = list.get(n);
                            ++n;
                            if (iEarlyEvent2.isPresentationState()) {
                                iEarlyEvent = (EarlyPresentationState)iEarlyEvent2;
                                this.applyPresentationStateGeneral(iEarlyEvent.presState);
                                continue;
                            }
                            iEarlyEvent = (TEvent)iEarlyEvent2;
                            this.handleTEvent((TEvent)iEarlyEvent, object, 0);
                        }
                        catch (Exception exception) {
                            log.error("Error applying presentation state/early event.", (Throwable)exception);
                        }
                    }
                    ImgView2.setGlobalEnabled(true);
                } else {
                    this.earlyEvents = null;
                }
            } else {
                this.state = 4;
            }
            this.canvasSizeChanged();
            this.invalidate();
            if (this.vis != null && this.vis.isInView()) {
                this.repaint();
            }
            this.actionFinished(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
        IPresentationState iPresentationState = null;
        IFramePresentationState iFramePresentationState = null;
        ImgView2 imgView2 = this;
        synchronized (imgView2) {
            if (iFrameObjectData == this.frameData && this.frameAlreadyAdded) {
                if (!this.allowInstanceDataTwiceInRendererTree()) {
                    if (this.state < 4) {
                        this.initInternal();
                        return false;
                    }
                    if (this.renderer == null || this.renderer.getRawDataContainer() == null) {
                        return false;
                    }
                    if (FetcherUtils.isLossyPrefetchData(iFrameObjectData.getRawDataContainer().getPixelDataFrame())) {
                        return false;
                    }
                    iPresentationState = this.renderer.getPresentationState(this.cwidth, this.cheight);
                    iFramePresentationState = this.renderer.getCurrentFramePresentationState();
                }
            } else {
                this.frameAlreadyAdded = true;
            }
        }
        if (this.state == 5) {
            return true;
        }
        try {
            if (!iFrameObjectData.getImageInformation().containsRenderInformation()) {
                try {
                    log.debug("Fixing ImageInformation.");
                    iFrameObjectData.getImageInformation().reinit(iFrameObjectData.getMainFrame().getDicomObject());
                }
                catch (Exception exception) {
                    log.error("Error fixing ImageInformation.", (Throwable)exception);
                }
            }
            this.addToRendererTree(iFrameObjectData, iPresentationState != null, string);
            this.initValueMapping();
            this.initInternal();
            this.initOverlays();
            if (iPresentationState != null) {
                this.applyPresentationState(this.renderer, new LossyFramePresentationState(iPresentationState, iFramePresentationState, iFrameObjectData.getFramePresentationState()));
            }
            return this.isInView();
        }
        catch (Exception exception) {
            log.error("Load failed", (Throwable)exception);
            this.state = 6;
            return true;
        }
    }

    private void initOverlays() {
        for (IOverlayProvider iOverlayProvider : OverlayProviderFactory.getInstance().getOverlayProviders()) {
            this.initOverlays(iOverlayProvider);
        }
    }

    private void initOverlays(IOverlayProvider iOverlayProvider) {
        Collection<Overlay> collection = iOverlayProvider.createOverlays(this);
        if (collection != null) {
            for (Overlay overlay : collection) {
                this.addOverlay(overlay);
            }
        }
    }

    protected void initValueMapping() {
        if (this.renderer != null) {
            this.renderer.initValueMappings(this.getDisplay());
        }
    }

    protected boolean allowInstanceDataTwiceInRendererTree() {
        return false;
    }

    private void applyPresentationStateToRendererAndAddOverlaysToView(IRDCRenderer iRDCRenderer, IFramePresentationState iFramePresentationState) {
        List<PresentationObject> list = iRDCRenderer.applyPresentationState(iFramePresentationState);
        for (Overlay overlay : list) {
            this.addOverlay(overlay);
        }
        this.updateMapping(false);
    }

    private void applyPresentationStateGeneral(IFramePresentationStateSource iFramePresentationStateSource) {
        Renderer renderer = this.getRenderer();
        if (renderer instanceof IRDCRenderer) {
            IRDCRenderer iRDCRenderer = (IRDCRenderer)((Object)renderer);
            IFrameObjectData iFrameObjectData = iRDCRenderer.getFrameObjectData();
            IPixelDataFrame<?> iPixelDataFrame = iRDCRenderer.getRawDataContainer().getPixelDataFrame();
            IFramePresentationState iFramePresentationState = this.getPresentationState(iFramePresentationStateSource, iFrameObjectData, iPixelDataFrame);
            this.applyPresentationState(iRDCRenderer, iFramePresentationState);
        }
    }

    private void applyPresentationState(IRDCRenderer iRDCRenderer, IFramePresentationState iFramePresentationState) {
        if (iFramePresentationState == null) {
            iRDCRenderer.clearPresentationState(null);
        } else {
            SpatialTransformationModule spatialTransformationModule = iFramePresentationState.getSpatialTransformation();
            if (spatialTransformationModule != null && spatialTransformationModule.hasFreeRotation() && this.initFreeRotation()) {
                iRDCRenderer = this.renderer;
            }
            this.applyPresentationStateToRendererAndAddOverlaysToView(iRDCRenderer, iFramePresentationState);
        }
        this.invalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
        if (iFramePresentationStateSource != null) {
            if (this.state < 4) {
                ImgView2 imgView2 = this;
                synchronized (imgView2) {
                    if (this.state < 4) {
                        this.earlyEvents.add(new EarlyPresentationState(iFramePresentationStateSource));
                        this.earlyPayloads.add(null);
                    } else {
                        this.applyPresentationStateGeneral(iFramePresentationStateSource);
                    }
                }
            } else {
                this.applyPresentationStateGeneral(iFramePresentationStateSource);
            }
        }
    }

    private IFramePresentationState getPresentationState(IFramePresentationStateSource iFramePresentationStateSource, IFrameObjectData iFrameObjectData, IPixelDataFrame<?> iPixelDataFrame) {
        int n = iFrameObjectData.getFrameNumber();
        IFramePresentationState iFramePresentationState = null;
        if (iFramePresentationStateSource != null) {
            iFramePresentationState = iFramePresentationStateSource.getFramePresentationState(iFrameObjectData.getSOPInstanceUID(), iFrameObjectData.getDicomObject(), n, iPixelDataFrame);
        }
        if (iFramePresentationState == null) {
            iFramePresentationState = iFrameObjectData.getMainFrame().getFramePresentationState(n, iPixelDataFrame);
        }
        return iFramePresentationState;
    }

    @Override
    public boolean allowROIs() {
        return this.state == 4;
    }

    @Override
    public void loadFinal() {
        if (this.state >= 4) {
            return;
        }
        if (!this.frameData.isStartedBeingLoaded()) {
            fetcher.changeToHigherPriority(this.frameData, (byte)0);
        }
    }

    private void activateLocalizer(Localizer localizer) {
        this.addGlobalOverlay(localizer);
        LocalizerHighlight localizerHighlight = new LocalizerHighlight(localizer);
        localizer.setLocalizerHighlight(localizerHighlight);
        this.addGlobalOverlay(localizerHighlight);
        this.topo = localizer;
    }

    protected void initLocalizer() {
        IImageInformation iImageInformation = this.frameData.getImageInformation();
        ActiveLocalizerHandler activeLocalizerHandler = LocalizerFactory.getHandler(iImageInformation, this);
        try {
            if (activeLocalizerHandler != null) {
                Localizer localizer = new Localizer(activeLocalizerHandler, iImageInformation, this.getVis().getParent().getDisplaySetID());
                if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MR && !localizerMRDisplay.isSelected()) {
                    localizer.setVisible(false);
                }
                this.activateLocalizer(localizer);
            }
        }
        catch (Exception exception) {
            log.warn("Incomplete or missing localizer data. Omitting.", (Throwable)exception);
        }
    }

    public boolean isFetchingFinal() {
        return this.state > 1;
    }

    @Override
    protected void paintPosterImpl(Graphics graphics, boolean bl) {
        if (this.state == 6) {
            this.paintFailed((Graphics2D)graphics, this.cwidth, this.cheight);
        } else {
            super.paintPosterImpl(graphics, bl);
        }
    }

    private void paintFailed(Graphics2D graphics2D, int n, int n2) {
        double d;
        int n3;
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(0, 0, n, n2);
        int n4 = n3 = Math.min(n, n2);
        if (n3 > 256) {
            d = (double)n3 / 256.0;
            n3 = 256;
            n4 = (int)((double)n4 / d);
        }
        if (n4 > 256) {
            d = (double)n4 / 256.0;
            n4 = 256;
            n3 = (int)((double)n3 / d);
        }
        int n5 = (n - n3) / 2;
        int n6 = (n2 - n4) / 2;
        graphics2D.drawImage(failIcon, n5, n6, n3, n4, null);
    }

    private void paintFailed(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2) {
        this.paintFailed(rGBBufferedImageHolder.graphics, n, n2);
    }

    private void reinitFrame() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImgView2.this.state < 4) {
                    ImgView2.this.frameAvailable(ImgView2.this.frameData, null);
                    log.error("STATE: " + ImgView2.this.state);
                    ImgView2.this.invalidate();
                    ImgView2.this.repaint();
                }
            }
        });
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (this.state < 4 && this.frameData.getRawDataContainer() != null) {
            EventUtil.invokeSynchronous((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ImgView2.this.state < 4) {
                        ImgView2.this.reinitFrame();
                    }
                }
            });
        }
        if (this.state == 6) {
            this.paintFailed(rGBBufferedImageHolder, this.cwidth, this.cheight);
            return;
        }
        if (this.state < 4) {
            return;
        }
        if (this.renderert.getRoot() == null) {
            return;
        }
        rGBBufferedImageHolder.imgInvalid |= this.imgInvalid;
        super.paint(rGBBufferedImageHolder);
        if (this.isLocalizerEnabled()) {
            int n = this.cwidth / 2 - 5;
            int n2 = this.cheight - 18;
            rGBBufferedImageHolder.graphics.setColor(OverlayConfig.mappingColor);
            rGBBufferedImageHolder.graphics.drawLine(n, n2, n + 10, n2 + 10);
            rGBBufferedImageHolder.graphics.drawLine(n, n2 + 4, n + 10, n2 + 14);
            rGBBufferedImageHolder.graphics.drawLine(n, n2 + 8, n + 10, n2 + 18);
        }
        this.imgInvalid = false;
    }

    @Override
    public void cleanUp() {
        this.state = 5;
        super.cleanUp();
        this.renderer = null;
        this.topo = null;
        this.pip = null;
    }

    @Override
    public void actionStarted(ViewEventHandler viewEventHandler) {
        super.actionStarted(viewEventHandler);
    }

    @Override
    public void actionFinished(ViewEventHandler viewEventHandler) {
        if (this.magnifyingGlass != null) {
            MagnifierOverlay magnifierOverlay = this.magnifyingGlass;
            this.magnifyingGlass = null;
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            hashSet.add(magnifierOverlay);
            this.lockBackground(true, hashSet);
            this.magnifyingGlass = magnifierOverlay;
            return;
        }
        super.actionFinished(viewEventHandler);
    }

    @Override
    protected void beforeCanvasSizeChanged() {
        Rectangle rectangle = this.getBounds();
        if (rectangle.width != 1 || rectangle.height != 1) {
            this.handleTEvent(new TEvent(137), new Rectangle(rectangle), 0);
        }
    }

    @Override
    public void onCanvasSizeChanged(boolean bl) {
        int n = this.getcwidth();
        int n2 = this.getcheight();
        if (this.state <= 1 || this.state > 4) {
            if (this.state == 1 && this.getMapping() != null) {
                this.getMapping().setSize(n, n2, null);
            }
            return;
        }
        try {
            if (this.getMapping() != null) {
                this.getMapping().setSize(n, n2, null);
            }
            this.updateMappingOnPaint = true;
            if (this.topo != null) {
                this.topo.setSize(n, n2, this.renderert.getImageState());
            }
            if (this.pip != null) {
                this.pip.getRendererRef().invalidate();
            }
            this.refreshPresentationObjects();
            this.invalidate();
        }
        catch (Exception exception) {
            log.error("ex in state " + this.state, (Throwable)exception);
        }
    }

    @Override
    public IMutableImageState getImageState() {
        if (this.state < 4) {
            return ImageState.getDefaultImageState();
        }
        return this.renderert.getImageState();
    }

    public RawDataContainer getRawDataContainer() {
        return this.frameData.getRawDataContainer();
    }

    @Override
    public List<PAction> getMenuEntries() {
        List<PAction> list = super.getMenuEntries();
        OverlayStatisticsAction overlayStatisticsAction = new OverlayStatisticsAction();
        if (overlayStatisticsAction.isEnabled(this.getVis())) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<StatisticsPresentationObject> stream = this.getOverlayStream(StatisticsPresentationObject.class);){
                if (stream.anyMatch(StatisticsPresentationObject::isUsableForStatisticsDiagram)) {
                    list = new ArrayList<PAction>(list);
                    list.add(overlayStatisticsAction);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return list;
    }

    @Override
    public boolean onEnterView() {
        boolean bl = super.onEnterView();
        if (bl) {
            if (MagnifierAction.isMagnifierEnabled()) {
                this.enableMagnifyingGlass();
            }
            if (this.topo != null) {
                LocalizerManager.notifyLocalizersOfView(this);
            }
        }
        return bl;
    }

    @Override
    public void onExitView() {
        super.onExitView();
        if (this.isMagnifierOn()) {
            this.disableMagnifyingGlass(true);
        }
        if (this.topo != null) {
            this.topo.exitView();
        }
    }

    @Override
    public String getVisualType() {
        return "IMAGE";
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getHRSet(visHRSet, vis2, this);
        }
        if (visHRSet != null && visHRSet.getType().equals("DEF")) {
            return visHRSet;
        }
        return new VisHRSetDefault(vis2);
    }

    @Override
    public Renderer getRenderer() {
        return this.renderert.getRoot();
    }

    public void localizerHandleUpdate(VisDisplayData visDisplayData, DisplayLocalizerInfo.ParallelityCheckResult parallelityCheckResult) {
        if (this.topo != null) {
            this.topo.handleUpdate(visDisplayData, parallelityCheckResult, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTEvent(TEvent tEvent, Object object, int n) {
        IImageInformationProvider iImageInformationProvider;
        if (this.state < 4) {
            if (tEvent.interactionModifier == 2) {
                iImageInformationProvider = this;
                synchronized (iImageInformationProvider) {
                    if (this.state < 4) {
                        if (tEvent.id != 21 && tEvent.id != 81) {
                            if (tEvent.id == 2 && object instanceof ZoomParameter) {
                                object = new EarlyZoomParameter((ZoomParameter)object, this);
                            }
                            this.earlyEvents.add(tEvent);
                            this.earlyPayloads.add(object);
                        }
                        return;
                    }
                }
            } else {
                return;
            }
        }
        if (this.state > 4) {
            return;
        }
        switch (tEvent.id) {
            case 11: {
                this.handleFreeRotationChange((FreeRotationAngle)object);
                break;
            }
            case 107: {
                if (!this.hasColorPalette()) break;
                iImageInformationProvider = this.renderer.getCurrentFramePresentationState();
                Boolean bl = (Boolean)object;
                iImageInformationProvider.setForceLUT(bl);
                this.applyPresentationStateToRendererAndAddOverlaysToView(this.renderer, (IFramePresentationState)iImageInformationProvider);
                this.invalidate();
                this.repaint();
                break;
            }
            case 116: {
                this.setLocalizer((Localizer.LocalizerState)((Object)object));
                break;
            }
            case 92: {
                iImageInformationProvider = ((MiniLocalizerSyncData)object).localizer;
                LocalizerLineOverlay localizerLineOverlay = ((Localizer)iImageInformationProvider).getImageRepresentation(this.frameData.getImageInformation());
                if (localizerLineOverlay != null) {
                    if (((Localizer)iImageInformationProvider).isMiniLocalizer()) {
                        IImageInformationProvider iImageInformationProvider2;
                        if (this.isFreeRotationActive()) {
                            log.warn("Mini localizer not supported while free rotation is active");
                            break;
                        }
                        MiniLocalizerSyncData miniLocalizerSyncData = LocalizerManager.getMiniLocalizerSyncData(this.getDisplay(), (MiniLocalizerSyncData)object);
                        if (miniLocalizerSyncData.renderer == null && miniLocalizerSyncData.localizer.getView() instanceof LayeredView) {
                            iImageInformationProvider2 = (LayeredView)miniLocalizerSyncData.localizer.getView();
                            ResultCacheNode resultCacheNode = new ResultCacheNode(((LayeredView)iImageInformationProvider2).renderert.getPaintRoot().clone());
                            miniLocalizerSyncData.renderer = resultCacheNode;
                        }
                        iImageInformationProvider2 = new MiniLocalizerOverlay(miniLocalizerSyncData, localizerLineOverlay);
                        this.addGlobalOverlay((Overlay)iImageInformationProvider2, 0);
                    } else {
                        for (MiniLocalizerOverlay miniLocalizerOverlay : Overlay.filter(MiniLocalizerOverlay.class, super.getOverlays())) {
                            if (((MiniLocalizerSyncData)object).localizer != miniLocalizerOverlay.getSync().localizer) continue;
                            this.removeOverlay(miniLocalizerOverlay);
                        }
                    }
                }
                this.invalidate();
                this.repaint();
                break;
            }
            case 119: {
                if (object != null) {
                    IRDCRenderer iRDCRenderer = this.getLeafRDC();
                    if (iRDCRenderer instanceof RDCRenderer) {
                        RDCRenderer rDCRenderer = (RDCRenderer)iRDCRenderer;
                        RDCRenderer rDCRenderer2 = rDCRenderer.clone();
                        rDCRenderer2.getAreaFitHandler().resetZoomFactor();
                        rDCRenderer2.getAreaFitHandler().setViewportCenterAlignmentX(AreaFitHandler.ViewportCenterAlignmentX.CENTER);
                        ImageDef imageDef = rDCRenderer2.getActiveImageDef();
                        imageDef.resetTransformedViewportCenter();
                        this.pip = new PictureInPictureOverlay(rDCRenderer2, this, rDCRenderer, (PictureInPictureOverlaySyncData)object);
                        this.addGlobalOverlay(this.pip);
                        EventUtil.invoke((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ImgView2.this.pip.getRendererRef().invalidate();
                                ImgView2.this.repaint();
                            }
                        });
                    } else {
                        log.warn("Creating picture-in-picture overlay not possible for current renderer: " + iRDCRenderer);
                    }
                } else {
                    this.removeOverlay(this.pip);
                    this.pip = null;
                }
                this.invalidate();
                this.repaint();
                break;
            }
            case 95: {
                SpacingDef spacingDef = (SpacingDef)object;
                if (!this.getImageState().spacingDefs().contains(spacingDef)) break;
                this.getImageState().setScreenPixelSize(spacingDef.getDataPixelSizeX(), spacingDef.getDataPixelSizeY());
                this.resetOverlayCachedValues();
                this.getImageState().updated();
                RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
                if (rGBBufferedImageHolder != null) {
                    this.paintOverlays(rGBBufferedImageHolder);
                }
                if (this.getRenderer() != null) {
                    this.getRenderer().handleTEvent(tEvent, object, n, this);
                }
                this.getImageState().updated();
                this.refresh();
                this.invalidate();
                this.repaint();
                break;
            }
            case 120: {
                this.applyValueMapping((IValueMappingFactory)object, this.renderer);
                break;
            }
            case 61: {
                this.handleSUVWindowEvent(tEvent, object, n, this.getWindowHandler());
                break;
            }
            case 135: {
                this.initOverlays((IOverlayProvider)object);
                this.invalidate();
                this.repaint();
                break;
            }
            default: {
                if (tEvent.id == 66 || tEvent.id == 67) {
                    this.resetFreeRotation();
                }
                if (this.magnifyingGlass != null && this.magnifyingGlass.handleTEvent(tEvent, object, n, this)) {
                    return;
                }
                if (this.pip != null) {
                    this.pip.propagateTEvent(tEvent, object, n, this);
                }
                if (object instanceof ViewportDefinition) {
                    ((ViewportDefinition)object).cwidth = this.getcwidth();
                    ((ViewportDefinition)object).cheight = this.getcheight();
                }
                super.handleTEvent(tEvent, object, n);
            }
        }
    }

    public void handleFreeRotationStart() {
        this.initFreeRotation();
    }

    public void handleFreeRotationProgress(FreeRotationAngle freeRotationAngle) {
        this.handleFreeRotationChange(freeRotationAngle);
    }

    public void handleFreeRotationEnd(FreeRotationAngle freeRotationAngle) {
        this.handleFreeRotationChange(freeRotationAngle);
        TEvent tEvent = new TEvent(11);
        tEvent.source = this;
        TEventDispatch.sendEvent(this.getDisplay(), tEvent, freeRotationAngle == null ? null : FreeRotationAngle.create((FreeRotationRenderer)this.renderer), false);
    }

    private void handleFreeRotationChange(FreeRotationAngle freeRotationAngle) {
        if (freeRotationAngle == null) {
            this.resetFreeRotation();
        } else if (this.initFreeRotation()) {
            ((FreeRotationRenderer)this.renderer).applyRotation(freeRotationAngle);
        } else {
            log.warn("Free rotation currently not supported for this view: " + this);
            return;
        }
        this.invalidate();
        this.repaint();
    }

    private boolean isFreeRotationActive() {
        return this.renderer instanceof FreeRotationRenderer;
    }

    private boolean isFreeRotationAllowed() {
        VisDisplayData visDisplayData = this.getDisplayData();
        return visDisplayData != null && visDisplayData.getPlugin().isDefaultPlugin();
    }

    private boolean initFreeRotation() {
        if (!this.isFreeRotationAllowed()) {
            return false;
        }
        if (!this.isFreeRotationActive()) {
            if (this.pip != null) {
                log.debug("Deactivating picture-in-picture overlay for free rotation");
                this.togglePictureInPicture();
            }
            this.replaceRenderer(new FreeRotationRenderer((RDCRenderer)this.renderer, this.cwidth, this.cheight));
        }
        return true;
    }

    private void resetFreeRotation() {
        if (this.isFreeRotationActive()) {
            this.replaceRenderer(this.renderer.disableFreeRotation());
        }
    }

    private void replaceRenderer(IRDCRenderer iRDCRenderer) {
        iRDCRenderer.setNodeID(((Renderer)((Object)this.renderer)).getNodeID());
        this.renderer = iRDCRenderer;
        this.renderert.setRoot((Renderer)((Object)this.renderer), this);
    }

    @Override
    public FilterActions.FilterApplicability getFilterApplicability() {
        if (this.isFreeRotationActive()) {
            return FilterActions.FilterApplicability.deny(Messages.getString("FilterApplicability.DeniedForRotatedImages"));
        }
        return super.getFilterApplicability();
    }

    public void setLocalizer(Localizer.LocalizerState localizerState) {
        VisDisplayData visDisplayData = this.getDisplayData();
        if (this.topo != null) {
            if (this.topo.isVisible() != localizerState.isVisible()) {
                this.topo.setVisible(localizerState.isVisible());
            }
        } else if (localizerState.isForced() && visDisplayData != null) {
            ActiveLocalizerHandler activeLocalizerHandler = new ActiveLocalizerHandler(this);
            Localizer localizer = new Localizer(activeLocalizerHandler, this.getImageInformation(), visDisplayData.getDisplaySetID());
            if (localizerState == Localizer.LocalizerState.ForceOn && this.getImageInformation().getImageClass() == IImageInformation.ImageClass.MR && !localizerMRDisplay.isSelected()) {
                localizer.setVisible(false);
            }
            this.activateLocalizer(localizer);
        }
        this.invalidate();
        if (this.isInView()) {
            this.repaint();
        }
    }

    @Override
    public int[] getImageCoordsAtScreenPosition(int n, int n2) {
        double[] dArray = new double[]{n, n2};
        double[] dArray2 = new double[2];
        this.getImageState().screenToImage(dArray, dArray2, null);
        int n3 = (int)dArray2[0] + 1;
        int n4 = (int)dArray2[1] + 1;
        return new int[]{n3, n4};
    }

    private String getWindowNukMaxAsString() {
        if (this.getWindowHandler() instanceof WindowHandlerNuk) {
            return this.getPercentageOfMaxString(this.getWindowHandler(), this.getWindowHandler().getCenter() + this.getWindowHandler().getWidth() / 2.0);
        }
        return null;
    }

    private String getWindowNukMinAsString() {
        if (this.getWindowHandler() instanceof WindowHandlerNuk) {
            return this.getPercentageOfMaxString(this.getWindowHandler(), this.getWindowHandler().getCenter() - this.getWindowHandler().getWidth() / 2.0);
        }
        return null;
    }

    private String getPercentageOfMaxString(WindowHandlerBase windowHandlerBase, double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.0");
        double d2 = this.renderer.getRawDataContainer().getHistogram().getMax();
        double d3 = windowHandlerBase.dataToLogical(d2);
        double d4 = 100.0 * d / d3;
        return d4 >= 0.0 ? String.valueOf(decimalFormat.format(d4)) : "-";
    }

    private Double getZoomFactor() {
        IRDCRenderer iRDCRenderer = this.getLeafRDC();
        AreaFitHandler areaFitHandler = iRDCRenderer.getAreaFitHandler();
        if (areaFitHandler == null) {
            return null;
        }
        double d = areaFitHandler.getAbsoluteZoomFactorX();
        if (Double.isNaN(d)) {
            return null;
        }
        return d;
    }

    @Override
    public Object resolveString(String string) {
        WindowHandlerBase windowHandlerBase = this.getWindowHandler();
        if (windowHandlerBase != null) {
            if (string.equals("WINDOW_CENTER")) {
                return windowHandlerBase.getCenter();
            }
            if (string.equals("WINDOW_WIDTH")) {
                return windowHandlerBase.getWidth();
            }
            if (string.equals("WINDOW_NUK_MAX")) {
                return this.getWindowNukMaxAsString();
            }
            if (string.equals("WINDOW_NUK_MIN")) {
                return this.getWindowNukMinAsString();
            }
        }
        if (string.equals("ZOOM_FACTOR")) {
            return this.getZoomFactor();
        }
        return super.resolveString(string);
    }

    @Override
    public boolean handleMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 503: {
                if (this.magnifyingGlass == null) break;
                this.magnifyingGlass.setLocation(mouseEvent.getX(), mouseEvent.getY());
                this.repaint();
                return false;
            }
            case 505: {
                if (this.magnifyingGlass == null) break;
                this.disableMagnifyingGlass();
                break;
            }
            case 504: {
                if (!MagnifierAction.isMagnifierEnabled()) break;
                this.enableMagnifyingGlassInternal(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        return super.handleMouseEvent(mouseEvent);
    }

    @Override
    public boolean isSliceThroughHotRegionSupported() {
        return true;
    }

    @Override
    public boolean addingHRsAllowed() {
        return this.magnifyingGlass == null;
    }

    public void enableMagnifyingGlass() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this.getVisView());
        this.enableMagnifyingGlassInternal(point.x, point.y);
    }

    protected void enableMagnifyingGlassInternal(int n, int n2) {
        if (this.renderert.getPaintRoot() == null) {
            return;
        }
        if (this.isCursorInView()) {
            PActionRegistry.getAction(MouseModeActionProvider.NORMAL_MOUSE_MODE).perform(null);
            if (this.magnifyingGlass == null) {
                this.magnifyingGlass = new MagnifyingGlassOverlay2(this.renderert.getPaintRoot(), this.renderert.cloneTree());
                this.addOverlay(this.magnifyingGlass);
                this.magnifyingGlass.setOwner(this);
            }
            Image image = new ImageIcon("").getImage();
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "invisible");
            VisMouseHandler visMouseHandler = this.getVis().getVisual().getMouseHandler();
            visMouseHandler.setCursor(cursor);
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            hashSet.add(this.magnifyingGlass);
            this.getVis().getVisual().removeHRs();
            this.lockBackground(false);
            this.lockBackground(true, hashSet);
            this.magnifyingGlass.setLocation(n - 1, n2 - 1);
            this.repaint();
            this.magnifyingGlass.setLocation(n, n2);
            this.repaint();
        }
    }

    public void disableMagnifyingGlass() {
        this.disableMagnifyingGlass(false);
    }

    private void disableMagnifyingGlass(boolean bl) {
        if (!bl || this.isCursorInView()) {
            try {
                if (this.getDisplayData() != null) {
                    Cursor cursor = this.getDisplayData().getDisplayPlugin().getMouseModeInfo().getCursor(this.getVis().getVisual());
                    VisMouseHandler visMouseHandler = this.getVis().getVisual().getMouseHandler();
                    visMouseHandler.setCursor(cursor);
                }
            }
            catch (Exception exception) {
                log.warn("Error on magnifier disable", (Throwable)exception);
            }
            this.removeOverlay(this.magnifyingGlass);
            this.magnifyingGlass = null;
            this.canvasSizeChanged();
            this.actionFinished(null);
            this.lockBackground(false);
            if (this.getVis() != null) {
                this.getVis().getVisual().addHRs();
            }
            this.repaint();
        }
    }

    @Override
    public boolean startRectangleZoom() {
        return this.renderer.startRectangleZoom();
    }

    private boolean isCursorInView() {
        if (this.getVisView() == null) {
            return false;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point2, this.getVisView());
        Rectangle rectangle = new Rectangle(point2, this.getVisView().getBounds().getSize());
        return rectangle.contains(point);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getBounds().width;
        int n6 = this.getBounds().height;
        super.setBounds(n, n2, n3, n4);
        if ((n5 != this.getBounds().width || n6 != this.getBounds().height) && this.magnifyingGlass != null) {
            MagnifierOverlay magnifierOverlay = this.magnifyingGlass;
            this.magnifyingGlass = null;
            this.lockBackground(false);
            HashSet<Overlay> hashSet = new HashSet<Overlay>();
            hashSet.add(magnifierOverlay);
            this.lockBackground(true, hashSet);
            this.magnifyingGlass = magnifierOverlay;
            return;
        }
    }

    public void applyLUT() {
        this.invalidate();
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    protected IRDCRenderer getLeafRDC() {
        if (this.renderert == null) {
            return null;
        }
        var1_1 = this.renderert.getPaintRoot();
        if (!(var1_1 instanceof IRDCRenderer)) ** GOTO lbl7
        return (IRDCRenderer)var1_1;
lbl-1000:
        // 1 sources

        {
            var1_1 = ((IntermediateNode)var1_1).getChildren().get(0);
lbl7:
            // 2 sources

            ** while (var1_1 instanceof IntermediateNode)
        }
lbl8:
        // 1 sources

        if (var1_1 instanceof IRDCRenderer) {
            return (IRDCRenderer)var1_1;
        }
        return null;
    }

    public WindowHandlerBase getWindowHandler() {
        IRDCRenderer iRDCRenderer = this.getLeafRDC();
        if (iRDCRenderer != null) {
            return iRDCRenderer.getWindowHandler();
        }
        return null;
    }

    public void setCalibration(double d, ICalibrationData iCalibrationData) {
        this.getImageState().updated();
        TEvent tEvent = new TEvent();
        tEvent.id = 65;
        tEvent.source = null;
        tEvent.destinationNodeID = 0;
        this.renderert.handleTEvent(tEvent, iCalibrationData.getCalibrationData(d), 0, this);
        this.onCanvasSizeChanged(true);
        this.resetOverlayCachedValues();
        this.onCalibration();
        this.invalidate();
        this.repaint();
        this.getRenderer().paintOverlays(this.getImageReference(), null, false);
        this.paintOverlays(this.getImageReference());
    }

    protected void onCalibration() {
    }

    @Override
    public void addOverlay(Overlay overlay) {
        super.addOverlay(overlay);
        if (overlay instanceof LeftMarkerPolygonOverlay || overlay instanceof RightMarkerPolygonOverlay) {
            MouseModeActionProvider.handleEscape();
        }
    }

    @Override
    public void addLiveSyncOverlay(PointOverlay pointOverlay) {
        this.addOverlay(pointOverlay);
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        super.removeOverlay(overlay);
        if (overlay == this.pip) {
            this.pip = null;
        }
    }

    @Override
    public void removeLiveSyncOverlay(PointOverlay pointOverlay) {
        this.removeOverlay(pointOverlay);
    }

    @Override
    public boolean isLiveSyncOverlayReuseEnabled(ILiveSyncPosition iLiveSyncPosition) {
        return true;
    }

    public boolean isMagnifierOn() {
        return this.magnifyingGlass != null;
    }

    public MagnifierOverlay getMagnifier() {
        return this.magnifyingGlass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFramePresentationState getCurrentFramePresentationState() {
        if (this.renderer == null) {
            ImgView2 imgView2 = this;
            synchronized (imgView2) {
                if (this.earlyEvents != null) {
                    for (IEarlyEvent iEarlyEvent : this.earlyEvents) {
                        if (!iEarlyEvent.isPresentationState()) continue;
                        return new FakePresentationState(((EarlyPresentationState)iEarlyEvent).presState, this.frameData.getSOPInstanceUID(), this.frameData.getFrameNumber());
                    }
                }
            }
            return null;
        }
        return this.renderer.getCurrentFramePresentationState();
    }

    public boolean hasColorPalette() {
        return this.renderer != null && this.renderer.getImageInformation().hasColorPaletteLUT();
    }

    @Override
    public synchronized IVOILUT createVOILUTForHijackedPresentationState(boolean bl, IPixelDataFrame<?> iPixelDataFrame) {
        IImageInformation iImageInformation;
        if (this.state == 4) {
            IPresentationState iPresentationState;
            if (this.renderer != null && (iPresentationState = this.renderer.getPresentationState()) != null) {
                return iPresentationState.getVOILUT(bl);
            }
            log.error("Runtime inconsitency");
            return null;
        }
        IImageInformation iImageInformation2 = iImageInformation = this.frameData.getImageInformation();
        for (IEarlyEvent object2 : this.earlyEvents) {
            if (!object2.isPresentationState()) continue;
            iImageInformation2 = ((EarlyPresentationState)object2).presState.getFramePresentationState(iImageInformation.getSOPInstanceUID(), this.getFrameData().getDicomObject(), this.frameData.getFrameNumber(), iPixelDataFrame);
            break;
        }
        WindowHandlerBase windowHandlerBase = WindowHandlerBase.getInstance(iImageInformation, iImageInformation2, iImageInformation.isInverse(), iImageInformation.isSigned(), null);
        int n = 0;
        while (n < this.earlyEvents.size()) {
            if (!this.earlyEvents.get(n).isPresentationState()) {
                TEvent tEvent = (TEvent)this.earlyEvents.get(n);
                int n2 = tEvent.id;
                if (n2 == 62 || n2 == 63 || n2 == 64) {
                    windowHandlerBase.handleTEvent(tEvent, this.earlyPayloads.get(n), 0, this);
                }
            }
            ++n;
        }
        return windowHandlerBase.getVOILUTForPresentationState(bl);
    }

    public boolean isComplete() {
        return this.state == 4;
    }

    private static class EarlyPresentationState
    implements IEarlyEvent {
        public final IFramePresentationStateSource presState;

        EarlyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
            this.presState = iFramePresentationStateSource;
        }

        @Override
        public boolean isPresentationState() {
            return true;
        }
    }
}

