/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingFactory;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingProperties;
import com.agfa.hap.pacs.data.valuemapping.SUVMapping;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.impaxee.valuemapping.ValueMappingProperties;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.OrientationMapping;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.renderer.IWindowableRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.RendererTree;
import com.tiani.jvision.vis.VisData;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class LayeredView
extends View {
    private static final PAction DELETE_ALL_ROIS_ACTION = PActionRegistry.getAction("DELETE_ALL_ROIS");
    protected RendererTree renderert = new RendererTree();
    private int eventInProcessRepaintLock = 0;
    protected boolean updateMappingOnPaint = false;
    public static final String MOUSE_WHEEL_EVENT_TRIGGER = "MouseWheel";

    public LayeredView() {
    }

    public LayeredView(IFrameObjectData iFrameObjectData) {
        super(iFrameObjectData);
    }

    @Override
    public IImageInformation getImageInformation() {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getImageInformation();
        }
        return super.getImageInformation();
    }

    @Override
    public IPresentationStateProvider getPresentationStateProvider(PresentationStateType presentationStateType) {
        if (this.renderert.getEventRoot() != null) {
            Renderer renderer = this.renderert.getEventRoot();
            if (!(renderer instanceof IPresentationStateProvider)) {
                return null;
            }
            this.ensureInitializationForPS();
            return (IPresentationStateProvider)((Object)renderer);
        }
        return super.getPresentationStateProvider(presentationStateType);
    }

    private void ensureInitializationForPS() {
        Renderer renderer = this.getRenderer();
        if (renderer != null) {
            Rectangle rectangle = this.getBounds();
            renderer.setGeometry(rectangle.width, rectangle.height, 0, rectangle.width);
        }
    }

    public RendererTree getRendererTree() {
        return this.renderert;
    }

    @Override
    public TransferFunction getTransferFunction() {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getTransferFunction();
        }
        return null;
    }

    @Override
    public List<Overlay> getPresentationObjects() {
        if (this.renderert.getPaintRoot() != null) {
            ArrayList<Overlay> arrayList = new ArrayList<Overlay>(this.renderert.getPaintRoot().getOverlays());
            arrayList.addAll(super.getPresentationObjects());
            return arrayList;
        }
        return super.getPresentationObjects();
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.getPresentationObjects();
    }

    public void removeOverlays(List<? extends Overlay> list) {
        for (Overlay overlay : list) {
            this.removeOverlay(overlay);
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        if (this.renderert.getRoot() != null) {
            this.renderert.getRoot().removeOverlay(overlay);
        }
        super.removeOverlay(overlay);
    }

    @Override
    public void removeAllOverlays() {
        this.removeOverlays(this.getOverlays());
    }

    public void addGlobalOverlays(List<Overlay> list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            this.addGlobalOverlay(list.get(n2));
            ++n2;
        }
    }

    public void addGlobalOverlay(Overlay overlay) {
        super.addOverlay(overlay);
    }

    void addGlobalOverlay(Overlay overlay, int n) {
        super.addOverlay(overlay, n);
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (overlay instanceof Mapping || overlay instanceof RulerMapping || overlay instanceof OrientationMapping) {
            super.addOverlay(overlay);
        } else {
            if (this.renderert.getEventRoot() == null) {
                return;
            }
            this.renderert.getEventRoot().addOverlay(overlay);
            if (overlay instanceof PresentationObject) {
                ((PresentationObject)overlay).presentationObjectAdded(this);
            } else {
                overlay.setOwner(this);
            }
            if (this.lockBackground) {
                if (this.excludeFromLock == null) {
                    this.excludeFromLock = new HashSet(3);
                }
                this.excludeFromLock.add(overlay);
            }
            overlay.setSize(this.getcwidth(), this.getcheight(), overlay.getImageState());
            this.invalidate();
        }
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (paintOverlays && this.renderert.getPaintRoot() != null) {
            this.renderert.getPaintRoot().paintOverlays(rGBBufferedImageHolder, this.excludeFromLock, this.lockBackground);
        }
        super.paintOverlays(rGBBufferedImageHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshPresentationObjects() {
        if (this.getcwidth() == 1) {
            return;
        }
        List list = this.overlays;
        synchronized (list) {
            for (Overlay overlay : this.overlays) {
                overlay.setSize(this.getcwidth(), this.getcheight(), overlay.getImageState());
            }
        }
        if (this.getMapping() != null) {
            this.getMapping().updateContent(this.getEvaluationContext(), true, true);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.renderert != null) {
            this.renderert.cleanUp();
        }
    }

    @Override
    public String getInfoAt(int n, int n2) {
        if (!this.isFunctional() || this.getMouseFollower() == null) {
            return "";
        }
        return this.getMouseFollower().getInfoAt(n, n2, this.getcwidth(), this.getcheight());
    }

    @Override
    public void broadcastPointOfInterest(int n, int n2) {
        if (broadcastPointOfInterest && this.isFunctional()) {
            PickingResult pickingResult = this.renderert.getEventRoot().pick(n, n2);
            if (pickingResult != null && !pickingResult.hasFrameOfReference()) {
                pickingResult = null;
            }
            TEvent tEvent = new TEvent(57);
            tEvent.source = this;
            TEventDispatch.sendEvent(tEvent, (Object)pickingResult, 20);
        }
    }

    @Override
    protected MousePositionDestination getMouseFollower() {
        if (this.renderert.getEventRoot() != null) {
            return this.renderert.getEventRoot().getMouseFollower();
        }
        return null;
    }

    @Override
    public void localWindow(int n, int n2) {
        if (!this.isFunctional()) {
            return;
        }
        TEvent tEvent = new TEvent();
        tEvent.id = 69;
        tEvent.source = null;
        tEvent.interactionModifier = 2;
        tEvent.destinationNodeID = 0;
        this.handleTEvent(tEvent, new Point(n, n2), 0);
    }

    @Override
    public List<IMenuEntry> getLegacyMenuEntries() {
        return this.renderert.getLegacyMenuEntries(this);
    }

    @Override
    public ViewSnapshot renderToSnapshot(int n, int n2, int n3, int n4, double d, double d2, View.OverlayMode overlayMode, boolean bl) {
        ViewSnapshot viewSnapshot;
        this.ensureInitializationForPS();
        if (overlayMode == View.OverlayMode.PRINT_OVERLAY_ALL_AND_ROI) {
            overlayMode = View.OverlayMode.PRINT_OVERLAY_ROI;
            viewSnapshot = this.renderert.renderToSnapshot(n, n2, n3, n4, d, d2, overlayMode, bl);
            viewSnapshot.setOverlayMode(View.OverlayMode.PRINT_OVERLAY_ALL);
        } else {
            viewSnapshot = this.renderert.renderToSnapshot(n, n2, n3, n4, d, d2, overlayMode, bl);
        }
        this.snapGlobalOverlays(viewSnapshot);
        return viewSnapshot;
    }

    private void snapGlobalOverlays(ViewSnapshot viewSnapshot) {
        int n = this.cwidth;
        int n2 = this.cheight;
        this.cwidth = viewSnapshot.getWidth();
        this.cheight = viewSnapshot.getHeight();
        super.refreshPresentationObjects();
        viewSnapshot.applyOverlays(super.getOverlays());
        this.cwidth = n;
        this.cheight = n2;
        super.refreshPresentationObjects();
    }

    @Override
    public int getOptimumViewingWidth() {
        return 10000;
    }

    @Override
    public int getOptimumViewingHeight() {
        return 10000;
    }

    @Override
    public IMutableImageState getImageState() {
        IMutableImageState iMutableImageState = this.renderert.getImageState();
        if (iMutableImageState == null) {
            iMutableImageState = ImageState.getDefaultImageState();
        }
        return iMutableImageState;
    }

    protected OrientationMapping getOrientation() {
        return Overlay.find(OrientationMapping.class, super.getOverlays());
    }

    protected void applyValueMapping(IValueMappingFactory iValueMappingFactory, IWindowableRenderer iWindowableRenderer) {
        if (iWindowableRenderer != null) {
            this.getImageState().setCurrentValueMapping(iValueMappingFactory.createValueMapping((IValueMappingProperties)new ValueMappingProperties(iWindowableRenderer)));
            this.resetOverlayCachedValues();
            this.getImageState().updated();
            RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
            if (rGBBufferedImageHolder != null) {
                this.paintOverlays(rGBBufferedImageHolder);
            }
            this.getImageState().updated();
            if (this.isInView()) {
                this.refresh();
            }
            this.invalidate();
            this.repaint();
        }
    }

    protected void handleSUVWindowEvent(TEvent tEvent, Object object, int n, WindowHandlerBase windowHandlerBase) {
        IValueMapping iValueMapping = this.getImageState().getCurrentValueMapping();
        if (windowHandlerBase != null && iValueMapping instanceof SUVMapping && object instanceof WindowValue) {
            WindowValue windowValue = (WindowValue)object;
            SUVMapping sUVMapping = (SUVMapping)iValueMapping;
            double d = windowValue.getWindowWidth() / 2.0;
            double d2 = sUVMapping.invertMapping(windowValue.getWindowCenter() - d);
            double d3 = sUVMapping.invertMapping(windowValue.getWindowCenter() + d);
            TEvent tEvent2 = new TEvent(tEvent);
            tEvent2.id = 63;
            WindowValue windowValue2 = new WindowValue((d3 + d2) / 2.0, Math.abs(d3 - d2), windowValue.isRelative());
            if (windowHandlerBase.handleTEvent(tEvent2, windowValue2, n, this)) {
                this.invalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void handleTEvent(TEvent tEvent, Object object, int n) {
        ++this.eventInProcessRepaintLock;
        try {
            switch (tEvent.id) {
                case 81: {
                    if (tEvent.source != this) {
                        this.invalidate();
                        this.repaint();
                    }
                    break;
                }
                case 90: {
                    this.renderert.syncAll((Map)object);
                    break;
                }
                default: {
                    if (tEvent.source != this && this.renderert.handleTEvent(tEvent, object, n, this)) {
                        if (tEvent.interactionModifier == 2) {
                            this.invalidate();
                            if (tEvent.id != 62 || object instanceof MouseEvent && ((MouseEvent)object).getID() == 502) {
                                this.actionFinished(null);
                            }
                        }
                        break;
                    }
                    super.handleTEvent(tEvent, object, n);
                    break;
                }
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        if (tEvent.source != this) {
            Mapping mapping = this.getMapping();
            if (mapping != null && this.isInView() && this.isMappingUpdateEnabled(tEvent)) {
                mapping.updateContent(this.getEvaluationContext(), true, false);
            }
            this.handleDelayedRepaint(true, tEvent);
        }
    }

    private boolean isMappingUpdateEnabled(TEvent tEvent) {
        switch (tEvent.interactionModifier) {
            case 2: {
                return true;
            }
            case 1: {
                return tEvent.id == 62 || tEvent.id == 63;
            }
        }
        return false;
    }

    public boolean layerOnHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        return false;
    }

    public boolean layerOnHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean layerOnHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
        return false;
    }

    @Override
    public final void handleHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return;
        }
        ++this.eventInProcessRepaintLock;
        try {
            if ((this.layerOnHotRegionPressed(hotRegion, mouseEvent) || this.renderert.handleHotRegionPressed(hotRegion.getName(), hotRegion.getBounds(), mouseEvent, this)) && !this.isInteraction()) {
                this.actionStarted(null);
                this.invalidate();
                this.repaint();
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        this.handleDelayedRepaint(true, null);
    }

    @Override
    public final void handleHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return;
        }
        ++this.eventInProcessRepaintLock;
        try {
            if ("RESET".equals(hotRegion.getName())) {
                this.getDisplay().getAction("RESET_DISPLAY").perform(null);
                VisData visData = this.getVis();
                if (!visData.isSelected()) {
                    visData.handleTEvent(new TEvent(66), null, 0);
                }
            } else if ("DELETE_ROI".equals(hotRegion.getName())) {
                DELETE_ALL_ROIS_ACTION.perform(null);
                this.actionFinished();
            } else if (this.layerOnHotRegionReleased(hotRegion, mouseEvent, n, n2) || this.renderert.handleHotRegionReleased(hotRegion.getName(), mouseEvent, n, n2, this)) {
                this.actionFinished(null);
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        this.handleDelayedRepaint(true, null);
    }

    @Override
    public final void handleHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        Mapping mapping;
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return;
        }
        ++this.eventInProcessRepaintLock;
        try {
            if (this.layerOnHotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4) || this.renderert.handleHotRegionDragged(hotRegion.getName(), mouseEvent, n, n2, n3, n4, this)) {
                this.invalidate();
                this.delayedRepaint |= 1;
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        if (hotRegion.getName().equals("ZOOM") && (mapping = this.getMapping()) != null) {
            mapping.updateContent(this.getEvaluationContext(), false, false);
        }
        this.handleDelayedRepaint(true, null);
    }

    @Override
    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return false;
        }
        return this.renderert.wantsMouseWheelEvent(mouseWheelEvent);
    }

    @Override
    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent) {
        if (!this.isFunctional() || this.renderert.getRoot() == null) {
            return false;
        }
        ++this.eventInProcessRepaintLock;
        boolean bl = false;
        try {
            bl = this.renderert.handleMouseWheel(mouseWheelEvent, this);
            if (bl) {
                this.invalidate();
            }
        }
        finally {
            --this.eventInProcessRepaintLock;
        }
        if (bl) {
            this.handleDelayedRepaint(true, MOUSE_WHEEL_EVENT_TRIGGER);
        }
        return bl;
    }

    protected void handleDelayedRepaint(boolean bl, Object object) {
        if (this.eventInProcessRepaintLock > 0) {
            return;
        }
        if (this.delayedRepaint > 1) {
            this.delayedRepaint = 0;
            if (bl) {
                this.invalidate();
                this.repaint();
            }
            TEvent tEvent = new TEvent();
            tEvent.id = 81;
            tEvent.source = this;
            TEventDispatch.sendEvent(tEvent, object);
        }
        if (this.delayedRepaint > 0) {
            this.delayedRepaint = 0;
            if (bl) {
                this.invalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void onCanvasSizeChanged(boolean bl) {
        if (!this.isFunctional()) {
            return;
        }
        this.refreshPresentationObjects();
        if (this.getMapping() != null) {
            this.getMapping().setSize(this.getcwidth(), this.getcheight(), null);
            this.updateMappingOnPaint = true;
            this.getMapping().updateContent(this.getEvaluationContext(), true, false);
        }
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        rGBBufferedImageHolder.imgInvalid |= this.imgInvalid;
        if (!rGBBufferedImageHolder.imgInvalid) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        this.renderert.paint(rGBBufferedImageHolder, n, n2, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline, this.isPreviewRendering());
        if (this.updateMappingOnPaint && this.getMapping() != null) {
            this.updateMappingOnPaint = false;
            this.getMapping().updateContent(this.getEvaluationContext(), true, false);
        }
        this.paintOverlays(rGBBufferedImageHolder);
        this.imgInvalid = false;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isFunctional() {
        return this.renderert.getRoot() != null;
    }

    @Override
    public Color getBackground() {
        if (this.renderert.getPaintRoot() != null) {
            return this.renderert.getPaintRoot().getBackgroundColor();
        }
        return super.getBackground();
    }
}

