/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ILocalizerPlane;
import com.tiani.jvision.overlay.LocalizerLineOverlay;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class LocalizerPlane
implements ILocalizerPlane {
    private static final ALogger log = ALogger.getLogger(LocalizerPlane.class);
    private static final double LIMIT = 10000.0;
    private static final double ANGLE_LIMIT = Math.toRadians(30.0);
    private Point3d origin;
    private Vector3d xv;
    private Vector3d yv;
    private Vector3d normal;
    private double sf1;
    private double sf2;
    private String frameOfReferenceUID;

    public LocalizerPlane(IImageInformation iImageInformation) throws IllegalLocalizerData {
        try {
            double[] dArray = iImageInformation.getPixelSpacing();
            this.sf1 = 1.0 / dArray[1];
            this.sf2 = 1.0 / dArray[0];
            this.origin = iImageInformation.getPointOrigin();
            this.xv = iImageInformation.getVectorU();
            this.yv = iImageInformation.getVectorV();
            if (this.xv == null || this.yv == null) {
                throw new IllegalLocalizerData();
            }
            this.normal = iImageInformation.getPlaneNormalUV();
            this.frameOfReferenceUID = iImageInformation.getFrameOfReferenceUID();
            this.xv.normalize();
            this.yv.normalize();
        }
        catch (Exception exception) {
            throw new IllegalLocalizerData();
        }
    }

    @Override
    public LocalizerLineOverlay getImageRepresentation(IImageInformation iImageInformation, boolean bl) {
        Object object;
        if (this.frameOfReferenceUID == null || !this.frameOfReferenceUID.equals(iImageInformation.getFrameOfReferenceUID())) {
            return null;
        }
        Point3d point3d = iImageInformation.getPointOrigin();
        Vector3d vector3d = iImageInformation.getScaledSizedVectorU();
        Vector3d vector3d2 = iImageInformation.getScaledSizedVectorV();
        if (vector3d == null || vector3d2 == null || point3d == null) {
            return null;
        }
        if (bl) {
            double d;
            object = iImageInformation.getPlaneNormalUV();
            double d2 = this.normal.x * object.x + this.normal.y * object.y + this.normal.z * object.z;
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            if ((d = Math.abs(Math.acos(d2))) < ANGLE_LIMIT) {
                return null;
            }
        }
        object = this.intersectRay(point3d, vector3d2);
        Point3d point3d2 = new Point3d(point3d);
        point3d2.add((Tuple3d)vector3d);
        double[] dArray = this.intersectRay(point3d2, vector3d2);
        boolean bl2 = false;
        if (object == null || Math.abs((double)(object[0] * this.sf1)) > 10000.0 || Math.abs((double)(object[1] * this.sf2)) > 10000.0 || dArray == null || Math.abs(dArray[0] * this.sf1) > 10000.0 || Math.abs(dArray[1] * this.sf2) > 10000.0) {
            object = this.intersectRay(point3d, vector3d);
            point3d2.set((Tuple3d)point3d);
            point3d2.add((Tuple3d)vector3d2);
            dArray = this.intersectRay(point3d2, vector3d);
            bl2 = true;
            if (object == null || dArray == null) {
                return null;
            }
        }
        if (bl2 && (Math.abs((double)(object[0] * this.sf1)) > 10000.0 || Math.abs((double)(object[1] * this.sf2)) > 10000.0 || Math.abs(dArray[0] * this.sf1) > 10000.0 || Math.abs(dArray[1] * this.sf2) > 10000.0)) {
            return null;
        }
        LocalizerLineOverlay localizerLineOverlay = new LocalizerLineOverlay((double)(object[0] * this.sf1), (double)(object[1] * this.sf2), dArray[0] * this.sf1, dArray[1] * this.sf2, iImageInformation.getInstanceNumber(), iImageInformation.getFrameNumber());
        return localizerLineOverlay;
    }

    private double determinant(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return d * (d5 * d9 - d6 * d8) + d2 * (d6 * d7 - d4 * d9) + d3 * (d4 * d8 - d5 * d7);
    }

    private double[] intersectRay(Point3d point3d, Vector3d vector3d) {
        double d;
        double d2;
        double d3;
        block3: {
            double[] dArray = new double[]{point3d.x - this.origin.x, point3d.y - this.origin.y, point3d.z - this.origin.z};
            try {
                d3 = this.determinant(this.xv.x, this.yv.x, vector3d.x, this.xv.y, this.yv.y, vector3d.y, this.xv.z, this.yv.z, vector3d.z);
                d2 = this.determinant(dArray[0], this.yv.x, vector3d.x, dArray[1], this.yv.y, vector3d.y, dArray[2], this.yv.z, vector3d.z);
                d = this.determinant(this.xv.x, dArray[0], vector3d.x, this.xv.y, dArray[1], vector3d.y, this.xv.z, dArray[2], vector3d.z);
                if (d3 != 0.0) break block3;
                return null;
            }
            catch (Exception exception) {
                log.error("LocalizerPlane", (Throwable)exception);
                return null;
            }
        }
        return new double[]{d2 / d3, d / d3};
    }

    public static class IllegalLocalizerData
    extends Exception {
    }
}

