/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.listtext.dicomobject.module.equipment.IManufacturerInfo;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.BitmapDisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.presentation.DisplayShutter;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.InternalManufacturerInfo;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class LossyFramePresentationState
implements IFramePresentationState {
    private IPresentationState ps;
    private IFramePresentationState currentPS;
    private IFramePresentationState imagePS;

    public LossyFramePresentationState(IPresentationState iPresentationState, IFramePresentationState iFramePresentationState, IFramePresentationState iFramePresentationState2) {
        this.ps = iPresentationState;
        this.currentPS = iFramePresentationState.isTemporary() ? iFramePresentationState2 : iFramePresentationState;
        this.imagePS = iFramePresentationState2;
    }

    public IVOILUT getVOILUT() {
        return this.currentPS.getVOILUT();
    }

    public IManufacturerInfo getManufacturer() {
        return InternalManufacturerInfo.INSTANCE;
    }

    public IVOILUT getVOILUT(IHistogramProvider iHistogramProvider) {
        return this.currentPS.getVOILUT(iHistogramProvider);
    }

    public void setVOILUT(IVOILUT iVOILUT) {
        this.currentPS.setVOILUT(iVOILUT);
    }

    public boolean getForceLUT() {
        return this.currentPS.getForceLUT();
    }

    public void setForceLUT(boolean bl) {
        this.currentPS.setForceLUT(bl);
    }

    public ModalityLUT getModalityLUT() {
        return this.currentPS.getModalityLUT();
    }

    public void setModalityLUT(ModalityLUT modalityLUT) {
        this.currentPS.setModalityLUT(modalityLUT);
    }

    public PresentationLUT getPresentationLUT() {
        PresentationLUT presentationLUT = this.ps.getPresentationLUT();
        if (presentationLUT != null) {
            return presentationLUT;
        }
        return this.imagePS.getPresentationLUT();
    }

    public IColorLookupTableSource getPaletteColorLUT() {
        return this.imagePS.getPaletteColorLUT();
    }

    public String getProviderUID() {
        return this.currentPS.getProviderUID();
    }

    public List<OverlayFrame> getOverlayFrames() {
        return this.imagePS.getOverlayFrames();
    }

    public DisplayShutter getDisplayShutter() {
        return this.imagePS.getDisplayShutter();
    }

    public DisplayedArea getDisplayedArea() {
        DisplayedArea displayedArea = this.ps.createDisplayedArea();
        ALogger.getLogger(LossyFramePresentationState.class).debug("Applying displayed area: {}", (Object)displayedArea);
        return displayedArea;
    }

    public List<GraphicAnnotation> getGraphicAnnotations() {
        return this.ps.getGraphicAnnotations(this.getGraphicLayers(), PresentationStateType.TEMPORARY);
    }

    public SpatialTransformationModule getSpatialTransformation() {
        return this.ps.createSpatialTransformationModule();
    }

    public List<GraphicLayer> getGraphicLayers() {
        return new ArrayList<GraphicLayer>();
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isTemporary() {
        return true;
    }

    public String getLabel() {
        return null;
    }

    public DisplayShutterModule getDisplayShutterModule() {
        return this.imagePS.getDisplayShutterModule();
    }

    public BitmapDisplayShutterModule getBitmapDisplayShutterModule() {
        return this.imagePS.getBitmapDisplayShutterModule();
    }

    public OverlayFrame getBitmapDisplayShutterOverlayFrame() {
        return this.imagePS.getBitmapDisplayShutterOverlayFrame();
    }
}

