/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.event.IZoomablePixelSizeProvider;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.info.IPixelSizeProvider;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.renderer.IMatchSizeRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;

public class MatchSizeAction
extends AbstractPAction {
    private static final ALogger LOG = ALogger.getLogger(MatchSizeAction.class);
    public static final String ID = "MATCH_SIZE";

    public MatchSizeAction() {
        super("zoom_equalize.svg");
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getGroupName() {
        return PAction.IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getCaption() {
        return Messages.getString("MatchSizeAction.MatchSize");
    }

    @Override
    public String getToolTipText() {
        return this.getCaption();
    }

    @Override
    public boolean perform(Component component) {
        Object object;
        this.notifyActionPerformed();
        double d = 0.0;
        ZoomParameter zoomParameter = null;
        double d2 = 0.0;
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        ArrayList<VisDisplay2> arrayList2 = new ArrayList<VisDisplay2>(JVision2.getMainFrame().getDisplays());
        for (VisDisplay2 visDisplay2 : arrayList2) {
            Renderer renderer;
            if (!visDisplay2.hasData() || !((renderer = visDisplay2.getVisView(0).getView().getRenderer()) instanceof IMatchSizeRenderer) || !(object = (IMatchSizeRenderer)((Object)renderer)).isMatchSizeSupported()) continue;
            double d3 = object.getCurrentSpacingDef().getAspectRatio();
            if (d2 == 0.0) {
                d2 = d3;
            } else if (!DoubleEquals.equals((double)d2, (double)d3, (double)1.0E-4)) {
                LOG.info("Aspect ratio different, no matching");
                return false;
            }
            double d4 = ZoomParameter.getDensity((IPixelSizeProvider)object);
            if (zoomParameter == null || d4 > d) {
                d = d4;
                zoomParameter = ZoomParameter.matchSize((IZoomablePixelSizeProvider)object);
            }
            arrayList.add(visDisplay2);
        }
        if (zoomParameter != null) {
            LOG.info("Same size matching: " + zoomParameter);
            for (VisDisplay2 visDisplay2 : arrayList) {
                visDisplay2.getSynchronizationManager().enableMatchSizeOnSynchronisation();
                object = new TEvent(2);
                ((TEvent)object).interactionModifier = 2;
                TEventDispatch.sendEvent(visDisplay2, (TEvent)object, zoomParameter, false);
            }
        }
        return true;
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(90, 8);
    }

    @Override
    public boolean invokableByHangingProtocol() {
        return true;
    }
}

