/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransformer;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImagePlaneInformation;
import com.tiani.jvision.image.View;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class PickingResult {
    protected Point3d entry;
    protected Point3d exit;
    protected Point3d point;
    private final String frameOfReferenceUID;

    public PickingResult(Point3d point3d, Point3d point3d2, Point3d point3d3, String string) {
        this.entry = point3d;
        this.exit = point3d2;
        this.point = point3d3;
        this.frameOfReferenceUID = string == null || string.isEmpty() ? null : string;
    }

    public Point3d getPoint(View view) {
        return this.getPoint(PickingResult.getFrameOfReferenceUID(view), view.getWorldToWorldTransformer());
    }

    public Point3d getPoint(String string, IWorldToWorldTransformer iWorldToWorldTransformer) {
        Point3d point3d = this.getRayHit();
        if (this.frameOfReferenceUID == null || string == null || this.frameOfReferenceUID.equals(string)) {
            return point3d;
        }
        if (iWorldToWorldTransformer.convertPoint(point3d, this.frameOfReferenceUID, string)) {
            return point3d;
        }
        return null;
    }

    public Point3d getRayEntry() {
        return new Point3d(this.entry);
    }

    public Point3d getRayExit() {
        return new Point3d(this.exit);
    }

    public Point3d getRayHit() {
        return new Point3d(this.point);
    }

    public boolean isCompatibleFrameOfReference(View view) {
        return this.isCompatibleFrameOfReference(PickingResult.getFrameOfReferenceUID(view), view.getWorldToWorldTransformer());
    }

    public boolean isCompatibleFrameOfReference(String string, IWorldToWorldTransformer iWorldToWorldTransformer) {
        return iWorldToWorldTransformer.isConversionSupported(this.frameOfReferenceUID, string);
    }

    public boolean hasFrameOfReference() {
        return this.frameOfReferenceUID != null;
    }

    public final Vector3d projectToPlane(View view) {
        return this.projectToPlane(view.getImageInformation(), view.getWorldToWorldTransformer());
    }

    public final Vector3d projectToPlane(IImagePlaneInformation iImagePlaneInformation, IWorldToWorldTransformer iWorldToWorldTransformer) {
        Point3d point3d = this.getRayHit();
        if (!iWorldToWorldTransformer.convertPoint(point3d, this.frameOfReferenceUID, iImagePlaneInformation.getFrameOfReferenceUID())) {
            return null;
        }
        Vector3d vector3d = iImagePlaneInformation.getVectorCenter();
        Vector3d vector3d2 = iImagePlaneInformation.getPlaneNormalUV();
        if (vector3d == null || vector3d2 == null) {
            return null;
        }
        Vector3d vector3d3 = new Vector3d((Tuple3d)point3d);
        vector3d3.sub((Tuple3d)vector3d);
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.normalize();
        double d = vector3d4.dot(vector3d3);
        vector3d4.scale(d);
        vector3d3.set((Tuple3d)point3d);
        vector3d3.sub((Tuple3d)vector3d4);
        return vector3d3;
    }

    public final Double getDistanceFromPlane(View view) {
        return this.getDistanceFromPlane(view.getImageInformation(), view.getWorldToWorldTransformer());
    }

    public final Double getDistanceFromPlane(IImagePlaneInformation iImagePlaneInformation, IWorldToWorldTransformer iWorldToWorldTransformer) {
        Point3d point3d = this.getRayHit();
        if (!iWorldToWorldTransformer.convertPoint(point3d, this.frameOfReferenceUID, iImagePlaneInformation.getFrameOfReferenceUID())) {
            return null;
        }
        Vector3d vector3d = this.projectToPlane(iImagePlaneInformation, iWorldToWorldTransformer);
        if (vector3d == null) {
            return null;
        }
        vector3d.sub((Tuple3d)point3d);
        return vector3d.length();
    }

    public static final Vector2d worldToImage(Tuple3d tuple3d, IImageInformation iImageInformation) {
        Vector3d vector3d = iImageInformation.getScaledVectorU();
        Vector3d vector3d2 = iImageInformation.getScaledVectorV();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d2, vector3d);
        Matrix3d matrix3d = new Matrix3d(vector3d.x, vector3d2.x, vector3d3.x, vector3d.y, vector3d2.y, vector3d3.y, vector3d.z, vector3d2.z, vector3d3.z);
        matrix3d.invert();
        tuple3d.sub((Tuple3d)iImageInformation.getVectorOrigin());
        matrix3d.transform(tuple3d);
        return new Vector2d(tuple3d.x, tuple3d.y);
    }

    private static String getFrameOfReferenceUID(View view) {
        return view.getImageInformation().getFrameOfReferenceUID();
    }
}

