/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.image.ICalibrationData;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PixelSizeCalibrationDialog
extends StandardDialog
implements KeyListener {
    public static final String AUTOMATED_TESTING_CALIBRATION_VALUE_PROPERTY_KEY = "test.calibration.value";
    private static final boolean IS_AUTOMATED_TESTING = Product.isRunningAutoTests();
    private JTextField calTF;
    private final ICalibrationData refPO;
    private final ImgView2 view;
    private double result = -1.0;

    private PixelSizeCalibrationDialog(ImgView2 imgView2, ICalibrationData iCalibrationData, double d) {
        super((Frame)JVision2.getMainFrame(), Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_TITLE"));
        this.view = imgView2;
        this.refPO = iCalibrationData;
        this.addOKButton(new OKAction(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_APPLY")));
        this.addCancelButton(new CancelAction(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_CANCEL")));
        this.setContent(this.createMainPanel(d));
        this.pack();
        this.initLocation();
    }

    public static void show(ImgView2 imgView2, ICalibrationData iCalibrationData) {
        PixelSizeCalibrationDialog.show(imgView2, iCalibrationData, -1.0);
    }

    public static double show(ImgView2 imgView2, ICalibrationData iCalibrationData, double d) {
        PixelSizeCalibrationDialog pixelSizeCalibrationDialog = new PixelSizeCalibrationDialog(imgView2, iCalibrationData, d);
        if (IS_AUTOMATED_TESTING) {
            double d2;
            block8: {
                d2 = d;
                String string = System.getProperty(AUTOMATED_TESTING_CALIBRATION_VALUE_PROPERTY_KEY);
                if (string != null) {
                    try {
                        try {
                            d2 = Double.parseDouble(string);
                        }
                        catch (Exception exception) {
                            ALogger.getLogger(PixelSizeCalibrationDialog.class).warn("Parsing calibration value failed: " + string, (Throwable)exception);
                            System.clearProperty(AUTOMATED_TESTING_CALIBRATION_VALUE_PROPERTY_KEY);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        System.clearProperty(AUTOMATED_TESTING_CALIBRATION_VALUE_PROPERTY_KEY);
                        throw throwable;
                    }
                    System.clearProperty(AUTOMATED_TESTING_CALIBRATION_VALUE_PROPERTY_KEY);
                }
            }
            pixelSizeCalibrationDialog.performCalibration(d2);
        } else {
            pixelSizeCalibrationDialog.setVisible(true);
        }
        return pixelSizeCalibrationDialog.result;
    }

    private JPanel createMainPanel(double d) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(ComponentFactory.instance.createEmptyBorder(5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)ComponentFactory.instance.createLabel(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_REFERENCE")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = ComponentFactory.instance.createLabel(PresentationObject.formatValue(this.refPO.getOriginalLength()));
        jLabel.setHorizontalAlignment(4);
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setPreferredSize(new Dimension(Math.max(GUI.getScaledDiagnosticInt((int)50), dimension.width), dimension.height));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        JLabel jLabel2 = ComponentFactory.instance.createLabel(this.refPO.getOriginalUnit());
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)ComponentFactory.instance.createLabel(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_DLG_CALIBRATED")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.calTF = ComponentFactory.instance.createTextField();
        this.calTF.setHorizontalAlignment(4);
        this.calTF.addActionListener(this::setResult);
        if (d > 0.0) {
            this.calTF.setText(PresentationObject.formatValue(d));
        }
        jPanel.add((Component)this.calTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        JLabel jLabel3 = ComponentFactory.instance.createLabel(SpacingDef.Unit.mm_man.toString());
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PixelSizeCalibrationDialog.this.calTF.requestFocus();
            }
        });
        this.calTF.addKeyListener(this);
        return jPanel;
    }

    void setResult(ActionEvent actionEvent) {
        double d;
        try {
            d = Double.parseDouble(Pattern.COMMA.matcher(this.calTF.getText()).replaceAll("."));
        }
        catch (NumberFormatException numberFormatException) {
            d = -1.0;
        }
        this.performCalibration(d);
    }

    void performCalibration(double d) {
        this.result = d;
        if (this.result > 0.0) {
            this.setVisible(false);
            this.view.setCalibration(this.result, this.refPO);
        } else {
            Message.info(Messages.getString("VISPOPUP_IMAGE_CALIBRATION_ERR_MESSAGE"));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String string) {
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PixelSizeCalibrationDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String string) {
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PixelSizeCalibrationDialog.this.setResult(actionEvent);
        }
    }
}

