/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.Orientation;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class PlanarContext {
    private static final double eps = 0.001;
    private Vector3d u;
    private Vector3d v;
    private Point3d p;
    private Vector3d normal;
    private double xc;
    private double yc;
    private final double gtx;
    private final double gty;
    private final double zscale;
    private final double[] voxelSize;
    private Transform3D s2v;
    private Transform3D v2s;
    private Vector3d temp = new Vector3d();
    private Orientation orientation;
    private long modificationCount;

    public PlanarContext(PlanarContext planarContext) {
        this.u = new Vector3d(planarContext.u);
        this.v = new Vector3d(planarContext.v);
        this.p = new Point3d(planarContext.p);
        this.normal = new Vector3d(planarContext.normal);
        this.xc = planarContext.xc;
        this.yc = planarContext.yc;
        this.gtx = planarContext.gtx;
        this.gty = planarContext.gty;
        this.zscale = planarContext.zscale;
        this.voxelSize = planarContext.voxelSize;
        this.updateTransforms();
    }

    public PlanarContext(double d, double d2, double d3, double[] dArray) {
        this.gtx = d;
        this.gty = d2;
        this.zscale = d3;
        this.voxelSize = (double[])dArray.clone();
        this.u = new Vector3d();
        this.v = new Vector3d();
        this.p = new Point3d();
        this.normal = new Vector3d();
    }

    public long getModificationCount() {
        return this.modificationCount;
    }

    public Transform3D getIsoVoxelToScreenTransform() {
        return new Transform3D(this.v2s);
    }

    public Transform3D getScreenToIsoVoxelTransform() {
        return new Transform3D(this.s2v);
    }

    private void updateTransforms() {
        Vector3d vector3d = new Vector3d(this.u);
        vector3d.cross(this.u, this.v);
        vector3d.normalize();
        vector3d.scale(this.u.length());
        double[] dArray = new double[]{this.u.x, this.v.x, vector3d.x, 0.0, this.u.y, this.v.y, vector3d.y, 0.0, this.u.z, this.v.z, vector3d.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.s2v = new Transform3D(dArray);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(-this.xc, -this.yc, 0.0));
        this.s2v.mul(this.s2v, transform3D);
        transform3D.setTranslation(new Vector3d((Tuple3d)this.p));
        this.s2v.mul(transform3D, this.s2v);
        this.v2s = new Transform3D(this.s2v);
        this.v2s.invert();
        ++this.modificationCount;
    }

    public double getZScale() {
        return this.zscale;
    }

    public Vector4d getP() {
        return new Vector4d(this.p.x, this.p.y, this.p.z, 0.0);
    }

    public Vector4d getU() {
        return new Vector4d(this.u.x, this.u.y, this.u.z, 0.0);
    }

    public Vector4d getV() {
        return new Vector4d(this.v.x, this.v.y, this.v.z, 0.0);
    }

    public Vector4d getNormal() {
        return new Vector4d(this.normal.x, this.normal.y, this.normal.z, 0.0);
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = Orientation.getOrientation3D(this.normal);
        }
        return this.orientation;
    }

    public double getXc() {
        return this.xc;
    }

    public double getYc() {
        return this.yc;
    }

    public double getGTX() {
        return this.gtx;
    }

    public double getGTY() {
        return this.gty;
    }

    public boolean isEquivalent(PlanarContext planarContext) {
        if (planarContext == null) {
            return false;
        }
        return this.isCoplanar(planarContext.u) && this.isCoplanar(planarContext.v) && this.isInPlane(planarContext.p);
    }

    public boolean isCoplanar(Vector3d vector3d) {
        return Math.abs(this.normal.angle(vector3d) - 1.5707963267948966) < 0.001;
    }

    public boolean isSame(PlanarContext planarContext) {
        return planarContext != null && this.u.equals((Tuple3d)planarContext.u) && this.v.equals((Tuple3d)planarContext.v) && this.p.equals((Tuple3d)planarContext.p) && DoubleEquals.equals((double)this.xc, (double)planarContext.xc) && DoubleEquals.equals((double)this.yc, (double)planarContext.yc);
    }

    private boolean isInPlane(Point3d point3d) {
        this.temp.set((Tuple3d)this.p);
        this.temp.sub((Tuple3d)point3d);
        return this.temp.length() < 0.001 || this.isCoplanar(this.temp);
    }

    public void setP(Vector4d vector4d) {
        this.p.x = vector4d.x;
        this.p.y = vector4d.y;
        this.p.z = vector4d.z;
        this.updateTransforms();
    }

    public void setTransform(Vector4d vector4d, Vector4d vector4d2, Vector4d vector4d3, double d, double d2) {
        this.p.x = vector4d.x;
        this.p.y = vector4d.y;
        this.p.z = vector4d.z;
        this.u.x = vector4d2.x;
        this.u.y = vector4d2.y;
        this.u.z = vector4d2.z;
        this.v.x = vector4d3.x;
        this.v.y = vector4d3.y;
        this.v.z = vector4d3.z;
        this.xc = d;
        this.yc = d2;
        this.normal.cross(this.u, this.v);
        this.orientation = null;
        this.updateTransforms();
    }

    public double getPixelSizeX() {
        return this.getLengthInMM((Tuple3d)this.u);
    }

    public double getPixelSizeY() {
        return this.getLengthInMM((Tuple3d)this.v);
    }

    public double getPixelSizeZ() {
        Vector3d vector3d = new Vector3d(this.normal);
        vector3d.normalize();
        return this.getLengthInMM((Tuple3d)vector3d);
    }

    private double getLengthInMM(Tuple3d tuple3d) {
        return Math.sqrt(tuple3d.x * this.voxelSize[0] * tuple3d.x * this.voxelSize[0] + tuple3d.y * this.voxelSize[1] * tuple3d.y * this.voxelSize[1] + tuple3d.z * this.voxelSize[2] * tuple3d.z * this.voxelSize[2] / this.zscale / this.zscale);
    }

    public void screenToIsoVolume(double d, double d2, double[] dArray) {
        this.screenToVolume(d, d2, dArray);
        dArray[2] = dArray[2] * this.zscale;
        dArray[0] = dArray[0] + this.gtx * dArray[2];
        dArray[1] = dArray[1] + this.gty * dArray[2];
    }

    public double[] screenToIsoVolume(double d, double d2) {
        double[] dArray = new double[3];
        Vector4d vector4d = new Vector4d(d, d2, 0.0, 1.0);
        this.s2v.transform(vector4d);
        dArray[0] = vector4d.x;
        dArray[1] = vector4d.y;
        dArray[2] = vector4d.z;
        return dArray;
    }

    public double[] screenToVolume(double d, double d2) {
        double[] dArray = new double[3];
        this.screenToVolume(d, d2, dArray);
        return dArray;
    }

    public void screenToVolume(double d, double d2, double[] dArray) {
        Vector4d vector4d = new Vector4d(d, d2, 0.0, 1.0);
        this.s2v.transform(vector4d);
        dArray[0] = vector4d.x;
        dArray[1] = vector4d.y;
        dArray[2] = vector4d.z / this.zscale;
    }

    public void volumeIsoToScreen(double d, double d2, double d3, double[] dArray) {
        Vector4d vector4d = new Vector4d(d, d2, d3, 1.0);
        this.v2s.transform(vector4d);
        dArray[0] = vector4d.x;
        dArray[1] = vector4d.y;
    }

    public double[] volumeIsoToScreen(double d, double d2, double d3) {
        double[] dArray = new double[2];
        this.volumeIsoToScreen(d, d2, d3, dArray);
        return dArray;
    }

    public double[] volumeIsoToScreen(Tuple3d tuple3d) {
        return this.volumeIsoToScreen(tuple3d.x, tuple3d.y, tuple3d.z);
    }

    public double[] volumeIsoToScreen(Tuple4d tuple4d) {
        return this.volumeIsoToScreen(tuple4d.x, tuple4d.y, tuple4d.z);
    }

    public double[] volumeToScreen(double d, double d2, double d3) {
        double[] dArray = new double[2];
        this.volumeToScreen(d, d2, d3, dArray);
        return dArray;
    }

    public void volumeToScreen(double d, double d2, double d3, double[] dArray) {
        Vector4d vector4d = new Vector4d(d, d2, d3 * this.zscale, 1.0);
        this.v2s.transform(vector4d);
        dArray[0] = vector4d.x;
        dArray[1] = vector4d.y;
    }

    public void screenToVolume(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double[] dArray6 = new double[]{0.0, 0.0, 0.0};
        int n = 0;
        while (n < dArray.length) {
            this.screenToVolume(dArray[n], dArray2[n], dArray6);
            dArray3[n] = dArray6[0];
            dArray4[n] = dArray6[1];
            dArray5[n] = dArray6[2];
            ++n;
        }
    }

    public Point3d projectToPlane(Tuple3d tuple3d) {
        Vector3d vector3d = new Vector3d(tuple3d);
        vector3d.sub((Tuple3d)this.p);
        Vector3d vector3d2 = new Vector3d(this.normal);
        vector3d2.normalize();
        double d = vector3d2.dot(vector3d);
        vector3d2.scale(d);
        vector3d.set(tuple3d);
        vector3d.sub((Tuple3d)vector3d2);
        return new Point3d((Tuple3d)vector3d);
    }

    public double distanceFromPlane(Tuple3d tuple3d) {
        Point3d point3d = this.projectToPlane(tuple3d);
        point3d.sub(tuple3d);
        return new Vector3d((Tuple3d)point3d).length();
    }

    public double signedDistanceFromPlane(Tuple3d tuple3d) {
        Point3d point3d = this.projectToPlane(tuple3d);
        point3d.sub(tuple3d);
        Vector3d vector3d = new Vector3d((Tuple3d)point3d);
        double d = vector3d.dot(this.normal);
        if (d < 0.0) {
            return -vector3d.length();
        }
        return vector3d.length();
    }

    public double[] getVoxelSize() {
        return this.voxelSize;
    }
}

