/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.data.shared.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.tiani.jvision.image.PaletteColorLUT;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowTransferFunction;
import org.dcm4che3.data.Attributes;

public class SegmentedPaletteColorLUT
extends PaletteColorLUT {
    private int center;
    private int width;

    public SegmentedPaletteColorLUT(IColorLookupTableSource iColorLookupTableSource, int n, WindowDef windowDef, int n2, boolean bl) {
        super(iColorLookupTableSource, n, bl);
        this.paddingValue = n2;
        this.setWindow(windowDef);
    }

    public SegmentedPaletteColorLUT(SegmentedPaletteColorLUT segmentedPaletteColorLUT) {
        super(segmentedPaletteColorLUT);
        this.center = segmentedPaletteColorLUT.center;
        this.width = segmentedPaletteColorLUT.width;
    }

    private byte[] scale(ILookupTable iLookupTable, int n, int n2) {
        int[] nArray = iLookupTable.getLUT();
        byte[] byArray = new byte[this.grays];
        int n3 = iLookupTable.getOutputBits() - 8;
        int n4 = Math.min(n2, this.grays);
        int n5 = n2 >= 0 ? 0 : -n2;
        int n6 = 0;
        while (n6 < n4) {
            byArray[n5++] = (byte)(nArray[0] >> n3);
            ++n6;
        }
        n6 = 0;
        while (n6 < n) {
            int n7 = (int)((long)n6 * 256L * (long)nArray.length / (long)n);
            int n8 = n7 / 256;
            int n9 = n7 & 0xFF;
            if (n5 >= byArray.length || n8 >= nArray.length - 1) break;
            if (n5 >= 0) {
                byArray[n5] = (byte)((nArray[n8] * (256 - n9) + nArray[n8 + 1] * n9) / 256 >> n3);
            }
            ++n5;
            ++n6;
        }
        while (n5 < byArray.length) {
            if (n5 >= 0) {
                byArray[n5] = (byte)(nArray[nArray.length - 1] >> n3);
            }
            ++n5;
        }
        return byArray;
    }

    @Override
    public final void setWindow(WindowDef windowDef) {
        int n = windowDef.getDataCenter();
        int n2 = windowDef.getDataWidth();
        if (n != this.center || n2 != this.width) {
            this.width = n2;
            this.center = n;
            this.ccRed = this.scale(this.redLUT, this.width + 1, this.center - (this.width >> 1));
            this.ccGreen = this.scale(this.greenLUT, this.width + 1, this.center - (this.width >> 1));
            this.ccBlue = this.scale(this.blueLUT, this.width + 1, this.center - (this.width >> 1));
            this.modified = true;
        }
    }

    @Override
    public WindowTransferFunction getClone() {
        return new SegmentedPaletteColorLUT(this);
    }

    public int getCenter() {
        return this.center;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void storeTo(Attributes attributes) {
        PaletteColorLUTModule paletteColorLUTModule = new PaletteColorLUTModule();
        paletteColorLUTModule.setTo(IColorLookupTableSource.Channel.Red, this.redLUT);
        paletteColorLUTModule.setTo(IColorLookupTableSource.Channel.Green, this.greenLUT);
        paletteColorLUTModule.setTo(IColorLookupTableSource.Channel.Blue, this.blueLUT);
        paletteColorLUTModule.writeTo(attributes);
    }

    @Override
    public WindowDef getWindowDef() {
        return new WindowDef(this.getGrays(), (double)this.center / (double)this.getGrays(), (double)this.width / (double)this.getGrays());
    }
}

