/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.jvision.vis.PresentationStateStorePanel;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.List;

public class StorePresentationStateAction
extends AbstractPAction {
    public static final String ID = "STORE_PRESENTATION_STATE";

    @Override
    public String getCaption() {
        return Messages.getString("ACTION_STORE_ROIS_AS_PRESENTATION_STATES");
    }

    @Override
    public String getGroupName() {
        return WORKFLOW_HANDLING_GROUP;
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(83, 1);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public boolean isAvailable() {
        return Permissions.getInstance().isAllowed("ImageArea/AllowedToSavePresentationStates") && StorageLicense.canStorePR();
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    protected boolean isEnabledImpl() {
        return !AbstractPDataAction.getCurrentDisplay().getData().getDisplayPlugin().isAggregating();
    }

    private void storeROIsAsPresentationState() {
        List<VisData> list = AbstractPDataAction.getVisDatas(PDataScope.SelectedImages);
        if (list.isEmpty()) {
            Message.info(Messages.getString("VISPOPUP_NO_SELECTED_IMAGES"));
            return;
        }
        if (Product.isRunningAutoTests()) {
            new PresentationStateStorePanel(list).save(false);
        } else {
            PresentationStateStorePanel.createDialog(list).setVisible(true);
        }
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        this.storeROIsAsPresentationState();
        VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
        if (visDisplay2 != null) {
            visDisplay2.updatePSState();
        }
        return true;
    }
}

