/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.AgeUtil;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransformer;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransformerProvider;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.keyimages.IKeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.impaxee.sync.SynchronizationManager;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.util.graphics.FontUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.ClippingShape;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageInformationProvider;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.gui.controls.basic.TProgressBar;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.IPresentationObjectCopyListener;
import com.tiani.jvision.image.IView;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.IVisView;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.PresentationObjectCopyData;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.ViewEventHandler;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.multimedia.Capturable;
import com.tiani.jvision.overlay.IOverlayOwner;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlaySynchronizationMode;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.SyncablePresentationObject;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.overlay.localizer.MyWeakReference;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.toptoolbar.LoopModeActionProvider;
import com.tiani.jvision.vis.IVisDisplayProvider;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.workers.ProgressListener;
import com.tiani.util.expressions.IEvaluablePrivateData;
import com.tiani.util.expressions.IEvaluationContext;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Stream;
import javax.swing.Timer;
import org.dcm4che3.data.Attributes;

public abstract class View
implements Cloneable,
IImageInformationProvider,
IVisDisplayProvider,
IView,
IVisView,
IWorldToWorldTransformerProvider,
IEvaluablePrivateData,
ProgressListener,
IOverlayOwner {
    private static final ALogger log = ALogger.getLogger(View.class);
    public static final int UNDEFINED_SIZE = 1;
    protected static final Image failIcon = new TIcon("/icons/load_failed.gif").getImage();
    protected static LevelOfDetail levelOfDetailForDemographics = Config.impaxee.jvision.MAPPING.LevelOfDetail.get() == null ? LevelOfDetail.ALL : LevelOfDetail.valueOf(Config.impaxee.jvision.MAPPING.LevelOfDetail.get());
    private static boolean globalEnabled = true;
    private static final Set<PluginName> DIRECTLY_RENDERABLE_PLUGINS_FOR_EXPORT = EnumSet.of(PluginName.DEFAULT, PluginName.ANIM2D);
    protected static boolean broadcastPointOfInterest = false;
    private static final int FAST_LIVE_SYNC_DELAY = (int)Config.impaxee.jvision.DISPLAY.FastLiveSyncDelay.get();
    private static Timer timerFastLiveSync;
    protected static boolean paintOverlays;
    protected IFrameObjectData frameData;
    protected List<Overlay> overlays = new Vector<Overlay>(5);
    protected IEvaluationContext evaluationContext;
    protected IViewMouseHandler mouseHandler = new ViewMouseHandler(this);
    private Mapping map;
    protected int cwidth = 1;
    protected int cheight = 1;
    protected int delayedRepaint = 0;
    private Rectangle bounds = new Rectangle(0, 0, 1, 1);
    public boolean imgInvalid = false;
    protected boolean lockBackground;
    private boolean hasRemovedPO = false;
    private RGBBufferedImageHolder myImage;
    public Collection<Overlay> excludeFromLock;
    private InViewData inView;
    private List<ViewEventHandler> teventListeners = null;
    public Capturable captureDestination;
    protected VisData vis;

    static {
        paintOverlays = true;
    }

    public static void setGlobalEnabled(boolean bl) {
        globalEnabled = bl;
    }

    public static void togglePointOfInterest() {
        boolean bl = broadcastPointOfInterest = !broadcastPointOfInterest;
        if (broadcastPointOfInterest && LoopModeActionProvider.getCurrentLoopMode() != LoopModeActionProvider.LoopMode.STOP) {
            log.warn("For livesync disable looping/switching");
            LoopModeActionProvider.setCurrentLoopMode(LoopModeActionProvider.LoopMode.STOP);
        }
        PActionRegistry.getAction("LiveSync").fireSelectionChanged();
        if (!broadcastPointOfInterest) {
            TEvent tEvent = new TEvent(57);
            TEventDispatch.sendEvent(tEvent, null, 20);
        }
    }

    public static boolean isPointOfInterestBroadcasting() {
        return broadcastPointOfInterest;
    }

    public static void setLevelOfDetailForDemographics(LevelOfDetail levelOfDetail) {
        levelOfDetailForDemographics = levelOfDetail;
    }

    public static void setPaintOverlays(boolean bl) {
        paintOverlays = bl;
    }

    public static boolean getPaintOverlays() {
        return paintOverlays;
    }

    public static LevelOfDetail getLevelOfDetailForDemographics() {
        if (!paintOverlays) {
            return LevelOfDetail.NONE;
        }
        return levelOfDetailForDemographics;
    }

    public View() {
    }

    public View(IFrameObjectData iFrameObjectData) {
        this();
        this.frameData = iFrameObjectData;
    }

    public IFrameObjectData getFrameData() {
        return this.frameData;
    }

    @Override
    public IImageInformation getImageInformation() {
        if (this.frameData == null) {
            return null;
        }
        return this.frameData.getImageInformation();
    }

    public IEvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public void setEvaluationContext(IEvaluationContext iEvaluationContext) {
        this.evaluationContext = iEvaluationContext;
    }

    public Histogram getHistogram() {
        return this.frameData.getRawDataContainer().getHistogram();
    }

    public Color getBackground() {
        return Color.BLACK;
    }

    public IViewMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public void presentationObjectCreationDone(PresentationObject presentationObject) {
    }

    public void presentationObjectModified(PresentationObject presentationObject) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    public Renderer getLeafRenderer() {
        Renderer renderer = this.getRenderer();
        if (renderer == null) {
            return null;
        }
        return renderer.getLeaf();
    }

    public boolean isInView() {
        return this.inView != null;
    }

    public String getInfoAt(int n, int n2) {
        return "";
    }

    public int[] getImageCoordsAtScreenPosition(int n, int n2) {
        return null;
    }

    public void broadcastPointOfInterest(int n, int n2) {
    }

    public Mapping getMapping() {
        return this.map;
    }

    public void setMapping(Mapping mapping) {
        this.map = mapping;
    }

    public abstract void reset();

    public void actionStarted(ViewEventHandler viewEventHandler) {
        if (this.inView != null && !this.inView.interaction) {
            this.inView.interaction = true;
            this.inView.bgWasLockedOnStart = this.lockBackground;
            if (this.lockBackground) {
                this.inView.wasExcludedOnStart = this.excludeFromLock;
                this.lockBackground(false);
            }
        }
    }

    public void actionFinished(ViewEventHandler viewEventHandler) {
        this.actionFinished();
    }

    void actionFinished(boolean bl) {
        if (this.inView != null && this.inView.interaction) {
            this.inView.interaction = false;
            this.imgInvalid = bl;
            if (this.map != null) {
                this.map.updateContent(this.evaluationContext, true, false);
            }
            if (this.inView.bgWasLockedOnStart) {
                this.lockBackground(true, this.inView.wasExcludedOnStart);
                this.inView.wasExcludedOnStart = null;
                this.inView.bgWasLockedOnStart = false;
            }
            if (this.vis != null && this.vis.getVisual() != null && globalEnabled) {
                this.vis.getVisual().addHRs();
            }
        }
    }

    public void updateMapping(boolean bl) {
        if (this.map != null) {
            this.map.updateContent(this.evaluationContext, true, bl);
        }
        if (this.vis != null && this.vis.getVisual() != null) {
            this.invalidate();
            this.repaint();
        }
    }

    public EnumSet<CAPTURE_STATES> captureStates() {
        return EnumSet.allOf(CAPTURE_STATES.class);
    }

    public boolean captureSpatialTransformation(IDisplayState iDisplayState, boolean bl) {
        return false;
    }

    public void actionFinished() {
        if (this.map != null && this.isInView()) {
            this.map.updateContent(this.evaluationContext, true, false);
        }
        if (this.inView != null && this.inView.interaction) {
            this.inView.interaction = false;
            this.imgInvalid = true;
            if (this.inView.bgWasLockedOnStart) {
                this.lockBackground(true, this.inView.wasExcludedOnStart);
                this.inView.wasExcludedOnStart = null;
                this.inView.bgWasLockedOnStart = false;
            }
        }
        if (this.vis != null && this.vis.getVisual() != null && globalEnabled) {
            this.vis.getVisual().addHRs();
        }
    }

    public void refreshPresentationObjects() {
        if (this.cwidth == 1 || this.overlays == null) {
            return;
        }
        IMutableImageState iMutableImageState = this.getImageState();
        int n = 0;
        while (n < this.overlays.size()) {
            this.overlays.get(n).setSize(this.cwidth, this.cheight, iMutableImageState);
            ++n;
        }
        if (this.map != null) {
            this.map.updateContent(this.evaluationContext, true, false);
        }
    }

    @Override
    public abstract IMutableImageState getImageState();

    public void cleanUp() {
        try {
            if (this.captureDestination != null) {
                this.captureDestination.stop();
            }
            this.captureDestination = null;
            this.teventListeners = null;
            this.mouseHandler.destruct();
            this.map = null;
            while (!this.overlays.isEmpty()) {
                this.removeOverlay(this.overlays.get(this.overlays.size() - 1));
            }
            this.overlays.clear();
            this.evaluationContext = null;
            this.vis = null;
        }
        catch (Throwable throwable) {
            log.error("Clean up", throwable);
        }
    }

    public boolean onEnterView() {
        if (this.inView == null) {
            this.inView = new InViewData();
            return true;
        }
        return false;
    }

    public void onExitView() {
        this.inView = null;
        this.lockBackground = false;
        if (this.myImage != null) {
            this.myImage.release();
            this.myImage = null;
        }
        EventQueue.invokeLater(this.getMouseHandler()::onExitView);
    }

    public abstract String getVisualType();

    @Override
    public Object resolveString(String string) {
        if (string.equals("TYPE")) {
            return this.getVisualType();
        }
        if (string.equals("OUTPUT_DEVICE")) {
            return "screen";
        }
        if (string.equals("DIAG_RELEVANT")) {
            IKeyImageInfo iKeyImageInfo = this.getFrameData().getKeyImageInfo();
            if (iKeyImageInfo != null && iKeyImageInfo.isMarked(KeyImageType.OfInterest)) {
                return "DIAG_RELEVANT";
            }
        } else {
            if (string.equals("MPI_ID")) {
                return Base.determineMPI_ID((Attributes)this.getImageInformation().getDataset());
            }
            if (string.equals("PATIENT_AGE")) {
                return this.calculatePatientAge();
            }
            if (string.equals("DISPLAY_SET_TYPE")) {
                try {
                    return this.getDisplayData().getDisplaySet().getDisplaySetType().getValue();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (string.equals("CURRENT_STUDY")) {
                if (this.isBaseStudy()) {
                    return " ";
                }
                return null;
            }
            if (string.equals("CURRENT_RUN")) {
                return this.getDisplayData().get4DProperties().getSecondaryIndex() + 1;
            }
            if (string.equals("CURRENT_POSITION_IN_TIME_RUN")) {
                return this.getDisplayData().indexOf(this.getVis()) + 1;
            }
        }
        return null;
    }

    private String calculatePatientAge() {
        Attributes attributes = this.getImageInformation().getDataset();
        Date date = DateTimeUtils.getStudyDateTime((Attributes)attributes);
        Date date2 = Dcm4cheUtils.getDate((int)0x100030, (Attributes)attributes);
        if (date != null && date2 != null) {
            return AgeUtil.getAgeLocalized((Date)date2, (LocalDate)date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
        if (attributes.containsValue(0x101010)) {
            return attributes.getString(0x101010);
        }
        return null;
    }

    private boolean isBaseStudy() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        return iHanging != null && this.getFrameData().getParent().getParent() == iHanging.getStudyContainer().getBaseStudy();
    }

    public boolean allowROIs() {
        return false;
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    public <U extends Overlay> List<U> getOverlays(Class<U> clazz) {
        return Overlay.filter(clazz, this.getOverlays());
    }

    public <U extends Overlay> Stream<U> getOverlayStream(Class<U> clazz) {
        return this.getOverlays().stream().filter(clazz::isInstance).map(clazz::cast);
    }

    public PresentationObject getShutterPO() {
        for (PresentationObject presentationObject : this.getOverlays(PresentationObject.class)) {
            if (!presentationObject.isShutter()) continue;
            return presentationObject;
        }
        return null;
    }

    public void addOverlay(Overlay overlay) {
        if (overlay == null) {
            return;
        }
        overlay.presentationObjectAdded(this);
        if (overlay instanceof PresentationObject) {
            if (((PresentationObject)overlay).isShutter()) {
                if (this.getShutterPO() != null) {
                    this.removeOverlay(this.getShutterPO());
                }
                this.overlays.add(0, overlay);
            } else {
                this.overlays.add(overlay);
            }
        } else {
            this.overlays.add(overlay);
        }
        overlay.setSize(this.cwidth, this.cheight, this.getImageState());
        if (this.lockBackground && this.excludeFromLock != null) {
            this.excludeFromLock.add(overlay);
        }
    }

    public void addOverlay(Overlay overlay, int n) {
        if (this.overlays.isEmpty() || this.overlays.get(this.overlays.size() - 1) != overlay) {
            overlay.presentationObjectAdded(this);
            if (overlay instanceof PresentationObject) {
                if (((PresentationObject)overlay).isShutter()) {
                    if (this.getShutterPO() != null) {
                        this.removeOverlay(this.getShutterPO());
                    }
                    this.overlays.add(0, overlay);
                } else {
                    this.overlays.add(n, overlay);
                }
            } else {
                this.overlays.add(n, overlay);
            }
            overlay.setSize(this.cwidth, this.cheight, this.getImageState());
            if (this.lockBackground && this.excludeFromLock != null) {
                this.excludeFromLock.add(overlay);
            }
        }
    }

    public void removeOverlay(Overlay overlay) {
        PresentationObject presentationObject;
        this.mouseHandler.cancelPresentationObjectCreation();
        if (this.overlays == null) {
            return;
        }
        if (this.overlays.remove(overlay)) {
            overlay.presentationObjectRemoved(this);
        }
        if (this.lockBackground && this.excludeFromLock != null) {
            this.excludeFromLock.remove(overlay);
        }
        if (overlay instanceof PresentationObject && (presentationObject = (PresentationObject)overlay).isROI() && presentationObject.isSaved()) {
            this.hasRemovedPO = true;
        }
        this.invalidate();
    }

    public boolean hasRemovedPO() {
        return this.hasRemovedPO;
    }

    public void removeAllOverlays() {
        while (!this.overlays.isEmpty()) {
            this.removeOverlay(this.overlays.get(0));
        }
    }

    @Override
    public int getcwidth() {
        return this.cwidth;
    }

    @Override
    public int getcheight() {
        return this.cheight;
    }

    public void updateGeometry() {
        Renderer renderer = this.getRenderer();
        if (renderer != null && this.cwidth > 1 && this.cheight > 1) {
            renderer.setGeometry(this.cwidth, this.cheight, 0, this.cwidth);
        }
    }

    protected void beforeCanvasSizeChanged() {
    }

    public abstract void onCanvasSizeChanged(boolean var1);

    public void canvasSizeChanged() {
        boolean bl = this.cwidth != this.bounds.width || this.cheight != this.bounds.height;
        this.cwidth = this.getBounds().width;
        this.cheight = this.getBounds().height;
        this.onCanvasSizeChanged(bl);
    }

    public Rectangle getBoundsForVis() {
        return this.getBounds();
    }

    public void setBoundsForVis(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3 + 2, n4 + 2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if ((n4 -= 2) <= 0 || (n3 -= 2) <= 0) {
            return;
        }
        boolean bl = false;
        if (this.getBounds().width == n3 && this.getBounds().height == n4) {
            this.bounds.x = n;
            this.bounds.y = n2;
            this.bounds.width = n3;
            this.bounds.height = n4;
            this.cwidth = n3;
            this.cheight = n4;
        } else {
            this.beforeCanvasSizeChanged();
            this.bounds.x = n;
            this.bounds.y = n2;
            this.bounds.width = n3;
            this.bounds.height = n4;
            this.cwidth = n3;
            this.cheight = n4;
            if (this.map != null) {
                this.map.setSize(n3, n4, this.getImageState());
            }
            bl = true;
        }
        if (bl) {
            this.canvasSizeChanged();
            bl = false;
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isImgInvalid() {
        return this.imgInvalid;
    }

    public void setImgInvalid(boolean bl) {
        this.imgInvalid = bl;
    }

    public void delayedRepaint() {
        this.delayedRepaint |= 1;
    }

    public void delayedRepaintBroadcast() {
        this.delayedRepaint |= 2;
    }

    @Override
    public void invalidate() {
        this.imgInvalid = true;
    }

    protected boolean isPreviewRendering() {
        return this.isInteraction();
    }

    public boolean isInteraction() {
        return this.inView != null && this.inView.interaction;
    }

    public void setInteraction(boolean bl) {
        this.inView.interaction = bl;
    }

    public RGBBufferedImageHolder getImageReference() {
        return this.myImage;
    }

    public BufferedImage captureImage() {
        return this.getImage();
    }

    public BufferedImage getImage() {
        if (this.myImage == null || this.myImage.width != this.bounds.width || this.myImage.height != this.bounds.height) {
            if (this.myImage != null) {
                this.myImage.release();
            }
            try {
                this.myImage = new RGBBufferedImageHolder(this.bounds.width, this.bounds.height);
                this.myImage.locked = false;
                this.myImage.imgInvalid = true;
            }
            catch (Throwable throwable) {
                log.error("Get Image", throwable);
                this.myImage = null;
                return null;
            }
        }
        this.paintContent(this.myImage);
        if (this.myImage == null) {
            return null;
        }
        return this.myImage.image;
    }

    @Override
    public void repaint() {
        if (!globalEnabled) {
            return;
        }
        try {
            if (this.vis != null && (this.myImage == null || this.vis.isInView())) {
                EventUtil.invoke(() -> {
                    if (this.vis != null) {
                        this.vis.paintForVisual();
                    }
                });
            }
        }
        catch (Exception exception) {
            log.error("Repainting view {} failed", (Object)this, (Object)exception);
        }
    }

    public abstract void paint(RGBBufferedImageHolder var1);

    public void paintPoster(Graphics graphics) {
        this.paintPosterImpl(graphics, UIDUtilities.getBaseType((String)this.frameData.getSOPClassUID()) != UIDType.Video);
    }

    public boolean isRenderableForExport() {
        return DIRECTLY_RENDERABLE_PLUGINS_FOR_EXPORT.contains((Object)this.getVis().getParent().getPlugin().getPluginName());
    }

    public boolean addingHRsAllowed() {
        return true;
    }

    public void lockBackground(boolean bl) {
        this.lockBackground(bl, null);
    }

    public void lockBackground(boolean bl, Collection<Overlay> collection) {
        if (bl) {
            if (!this.lockBackground) {
                this.excludeFromLock = collection;
            } else if (this.excludeFromLock != null) {
                if (collection != null) {
                    this.excludeFromLock.addAll(collection);
                }
            } else {
                this.excludeFromLock = collection;
            }
            this.lockBackground = false;
            this.invalidate();
            this.getImage();
            if (this.inView != null) {
                RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
                if (rGBBufferedImageHolder != null) {
                    int[] nArray = rGBBufferedImageHolder.data;
                    this.inView.lockedBgBuffer = (int[])nArray.clone();
                } else {
                    this.inView.lockedBgBuffer = null;
                }
            }
        } else {
            this.excludeFromLock = null;
            if (this.inView != null) {
                this.inView.lockedBgBuffer = null;
            }
        }
        this.lockBackground = bl;
    }

    private void paintContent(RGBBufferedImageHolder rGBBufferedImageHolder) {
        block8: {
            try {
                boolean bl;
                boolean bl2 = bl = this.imgInvalid || this.lockBackground;
                if (!this.lockBackground) {
                    this.paint(rGBBufferedImageHolder);
                } else {
                    rGBBufferedImageHolder.locked = true;
                    int[] nArray = rGBBufferedImageHolder.data;
                    if ((nArray.length != this.inView.lockedBgBuffer.length || this.imgInvalid) && !LocalizerManager.isFastRepaintInProgress()) {
                        Collection<Overlay> collection = this.excludeFromLock;
                        Capturable capturable = this.captureDestination;
                        this.captureDestination = null;
                        this.lockBackground(false);
                        this.lockBackground(true, collection);
                        this.imgInvalid = false;
                        this.captureDestination = capturable;
                    }
                    if (this.inView.lockedBgBuffer.length <= nArray.length) {
                        System.arraycopy(this.inView.lockedBgBuffer, 0, nArray, 0, nArray.length);
                    }
                    this.paintOverlays(rGBBufferedImageHolder);
                }
                boolean bl3 = rGBBufferedImageHolder.imgInvalid = !this.isFunctional();
                if (bl && this.captureDestination != null) {
                    this.captureDestination.frame(this, rGBBufferedImageHolder);
                }
            }
            catch (Throwable throwable) {
                log.error("View", throwable);
                ExceptionHandlerFactory.getInstance().handleException(throwable);
                if (rGBBufferedImageHolder == null) break block8;
                rGBBufferedImageHolder.clear();
            }
        }
        if (this.myImage != null && this.myImage.imgInvalid && this.isFunctional()) {
            log.warn("image invalid on exit!");
            this.myImage.clear();
        }
    }

    public void refresh() {
        if (this.myImage != null) {
            this.myImage.imgInvalid = true;
            this.getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder) {
        if (this.overlays != null) {
            List<Overlay> list = this.overlays;
            synchronized (list) {
                for (Overlay overlay : this.overlays) {
                    if (!paintOverlays && !(overlay instanceof Mapping)) continue;
                    if (this.excludeFromLock == null) {
                        overlay.paint(rGBBufferedImageHolder);
                        continue;
                    }
                    if (!this.lockBackground) {
                        if (this.excludeFromLock.contains(overlay)) continue;
                        overlay.paint(rGBBufferedImageHolder);
                        continue;
                    }
                    if (!this.excludeFromLock.contains(overlay)) continue;
                    overlay.paint(rGBBufferedImageHolder);
                }
            }
        }
    }

    public boolean handleMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.inView.lastDenied = false;
                return this.handleMousePressed(mouseEvent);
            }
            case 506: {
                if (!this.acceptMouseEvent(mouseEvent)) {
                    return false;
                }
                boolean bl = this.handleMouseDragged(mouseEvent);
                this.mouseEventComplete(mouseEvent);
                return bl;
            }
            case 502: {
                if (this.inView.lastDenied) {
                    this.handleMouseDragged(mouseEvent);
                }
                return this.handleMouseReleased(mouseEvent);
            }
            case 500: {
                return this.handleMouseClicked(mouseEvent);
            }
        }
        return false;
    }

    public boolean handleMousePressed(MouseEvent mouseEvent) {
        return false;
    }

    public boolean handleMouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean handleMouseDragged(MouseEvent mouseEvent) {
        return false;
    }

    public boolean handleMouseReleased(MouseEvent mouseEvent) {
        return false;
    }

    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    public boolean startRectangleZoom() {
        return true;
    }

    public boolean showContextMenu() {
        return true;
    }

    public void sendLiveSyncEvent(Point point) {
        PickingResult pickingResult = this.getRenderer().pick(point.getX(), point.getY());
        View.sendLiveSyncEvent(pickingResult, this.isLiveSyncEventRequiredForSourceView() ? null : this);
    }

    public static void sendLiveSyncEvent(PickingResult pickingResult, Object object) {
        if (pickingResult != null && pickingResult.hasFrameOfReference()) {
            TEvent tEvent = new TEvent(57);
            tEvent.source = object;
            TEventDispatch.sendEvent(tEvent, (Object)pickingResult, 20);
            View.startFastLiveSyncTimer();
        }
    }

    private static void startFastLiveSyncTimer() {
        if (timerFastLiveSync == null) {
            timerFastLiveSync = new Timer(FAST_LIVE_SYNC_DELAY, View::hideFastLiveSyncCross);
            timerFastLiveSync.setRepeats(false);
            timerFastLiveSync.start();
        } else {
            timerFastLiveSync.restart();
        }
    }

    private static void hideFastLiveSyncCross(ActionEvent actionEvent) {
        timerFastLiveSync.stop();
        timerFastLiveSync = null;
        TEventDispatch.sendEvent(new TEvent(57), null, 20);
    }

    protected boolean isLiveSyncEventRequiredForSourceView() {
        return false;
    }

    public void addViewEventListener(ViewEventHandler viewEventHandler) {
        if (this.teventListeners == null) {
            this.teventListeners = new Vector<ViewEventHandler>(2);
        }
        if (!this.teventListeners.contains(viewEventHandler)) {
            this.teventListeners.add(viewEventHandler);
        }
    }

    public void removeViewEventListener(ViewEventHandler viewEventHandler) {
        if (this.teventListeners == null) {
            return;
        }
        this.teventListeners.remove(viewEventHandler);
    }

    public abstract VisHRSet getHRSet(VisHRSet var1, Vis2 var2);

    public Capturable getCaptureDestination() {
        return this.captureDestination;
    }

    public void setCaptureDestination(Capturable capturable) {
        if (capturable != null) {
            RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
            this.captureDestination = !capturable.start(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height) ? null : capturable;
        } else {
            if (this.captureDestination != null) {
                this.captureDestination.stop();
            }
            this.captureDestination = capturable;
        }
    }

    public boolean setCaptureDestination(Capturable capturable, double d) {
        if (capturable != null) {
            this.captureDestination = capturable;
            RGBBufferedImageHolder rGBBufferedImageHolder = this.getImageReference();
            capturable.setNumberOfFramesPerSecond(d);
            this.setNumberOfFrames(capturable);
            if (!this.captureDestination.start(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height)) {
                this.captureDestination = null;
            }
        } else {
            if (this.captureDestination != null) {
                this.captureDestination.stop();
            }
            this.captureDestination = capturable;
        }
        return this.captureDestination != null;
    }

    protected void setNumberOfFrames(Capturable capturable) {
        capturable.setNumberOfFrames(this.getDisplay().getVisCount());
    }

    public List<IMenuEntry> getLegacyMenuEntries() {
        return new ArrayList<IMenuEntry>(2);
    }

    public List<PAction> getMenuEntries() {
        if (this.frameData == null) {
            return Collections.emptyList();
        }
        return this.frameData.getMenuEntries();
    }

    public List<IMenuEntry> getMenuEntriesForPO(PresentationObject presentationObject) {
        return Collections.emptyList();
    }

    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        this.inView.lastDxAbs = 0;
        this.inView.lastDyAbs = 0;
        this.handleHotRegionPressed(hotRegion, mouseEvent);
    }

    public abstract void handleHotRegionPressed(HotRegion var1, MouseEvent var2);

    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        if (!this.acceptMouseEvent(mouseEvent)) {
            InViewData inViewData = this.inView;
            inViewData.lostdxRel = inViewData.lostdxRel + n3;
            InViewData inViewData2 = this.inView;
            inViewData2.lostdyRel = inViewData2.lostdyRel + n4;
            return;
        }
        if (n3 * this.inView.lostdxRel >= 0) {
            n3 += this.inView.lostdxRel;
        }
        if (n4 * this.inView.lostdyRel >= 0) {
            n4 += this.inView.lostdyRel;
        }
        this.inView.lostdyRel = 0;
        this.inView.lostdxRel = 0;
        this.inView.lastDxAbs = n;
        this.inView.lastDyAbs = n2;
        this.handleHotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4);
        this.mouseEventComplete(mouseEvent);
    }

    public abstract void handleHotRegionDragged(HotRegion var1, MouseEvent var2, int var3, int var4, int var5, int var6);

    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        this.handleHotRegionReleased(hotRegion, mouseEvent, this.inView.lastDxAbs, this.inView.lastDyAbs);
    }

    public abstract void handleHotRegionReleased(HotRegion var1, MouseEvent var2, int var3, int var4);

    public boolean isSliceThroughHotRegionSupported() {
        return false;
    }

    public IPresentationStateProvider getPresentationStateProvider(PresentationStateType presentationStateType) {
        return null;
    }

    public void applySessionPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
        this.applyPresentationState(iFramePresentationStateSource);
    }

    public void applyPresentationState(IFramePresentationStateSource iFramePresentationStateSource) {
    }

    public boolean getLastDenied() {
        return this.inView.lastDenied;
    }

    public void mouseEventComplete(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            this.inView.systemDuration = System.currentTimeMillis() - this.inView.lastStartMillis;
            this.inView.lastMouseEventWhen = mouseEvent.getWhen() + this.inView.systemDuration;
        } else {
            this.inView.lastMouseEventWhen = System.currentTimeMillis();
        }
    }

    public boolean acceptMouseEvent(MouseEvent mouseEvent) {
        this.inView.lastDenied = mouseEvent.getWhen() < this.inView.lastMouseEventWhen;
        if (!this.inView.lastDenied) {
            this.inView.lastStartMillis = System.currentTimeMillis();
        }
        return !this.inView.lastDenied;
    }

    public void handleTEvent(TEvent tEvent, Object object, int n) {
        if (this.teventListeners != null) {
            int n2 = 0;
            while (n2 < this.teventListeners.size()) {
                this.teventListeners.get(n2).handleTEvent(tEvent, object, n, this);
                ++n2;
            }
        }
        switch (tEvent.id) {
            case 95: {
                SpacingDef spacingDef = (SpacingDef)object;
                if (!this.getImageState().spacingDefs().contains(spacingDef)) break;
                this.getImageState().setScreenPixelSize(spacingDef.getDataPixelSizeX(), spacingDef.getDataPixelSizeY());
                this.resetOverlayCachedValues();
                this.getImageState().updated();
                this.paintOverlays(this.myImage);
                if (this.getRenderer() != null) {
                    this.getRenderer().handleTEvent(tEvent, object, n, this);
                }
                this.getImageState().updated();
                this.refresh();
                this.invalidate();
                this.repaint();
                break;
            }
            case 123: {
                PresentationObjectCopyData presentationObjectCopyData = (PresentationObjectCopyData)object;
                presentationObjectCopyData.notifyListeners(this.copyPresentationObject(presentationObjectCopyData.getPresentationObject(), presentationObjectCopyData.getMode()));
            }
        }
    }

    public void setVis(VisData visData) {
        this.vis = visData;
        if (!this.isFunctional()) {
            this.init();
        }
    }

    public void init() {
    }

    @Override
    public VisDisplay2 getDisplay() {
        if (this.vis == null || this.vis.getParent() == null) {
            return null;
        }
        return this.vis.getParent().getVisDisplay();
    }

    public VisDisplayData getDisplayData() {
        if (this.vis == null) {
            return null;
        }
        return this.vis.getParent();
    }

    @Override
    public final IWorldToWorldTransformer getWorldToWorldTransformer() {
        return this.getDisplayData().getDisplayPlugin().getWorldToWorldTransformer();
    }

    @Override
    public VisData getVis() {
        return this.vis;
    }

    public Vis2 getVisView() {
        if (this.vis == null) {
            return null;
        }
        return this.vis.getVisual();
    }

    @Override
    public boolean isDisplayed() {
        return this.vis != null;
    }

    public int getOptimumViewingWidth() {
        return 512;
    }

    public int getOptimumViewingHeight() {
        return 512;
    }

    public boolean isColor() {
        return this.getTransferFunction() == null || this.getTransferFunction().getClass() != WindowTransferFunction.class;
    }

    public synchronized void print(Graphics graphics, Rectangle rectangle, boolean bl, int n, boolean bl2) {
        Rectangle rectangle2 = new Rectangle(this.getBounds());
        this.setBounds(0, 0, rectangle.width, rectangle.height);
        this.invalidate();
        RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(rectangle.width, rectangle.height);
        int n2 = 0;
        while (n2 < this.overlays.size()) {
            Overlay overlay = this.overlays.get(n2);
            overlay.setPrintFont(rGBBufferedImageHolder.graphics, rectangle, n);
            ++n2;
        }
        if (this.getMapping() != null) {
            this.getMapping().setPrintFont(rGBBufferedImageHolder.graphics, rectangle, n);
        }
        this.setBounds(0, 0, rectangle.width + 2, rectangle.height + 2);
        if (this.getMapping() != null) {
            this.getMapping().updateContent(true, false);
        }
        this.paint(rGBBufferedImageHolder);
        graphics.drawImage(rGBBufferedImageHolder.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        n2 = 0;
        while (n2 < this.overlays.size()) {
            this.overlays.get(n2).resetPrintFont();
            ++n2;
        }
        rGBBufferedImageHolder.release();
        this.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public ViewSnapshot renderToSnapshot(int n, int n2, int n3, int n4, double d, double d2, OverlayMode overlayMode, boolean bl) {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        this.print(bufferedImage.getGraphics(), rectangle, false, 0, false);
        if (!bl) {
            object = this.getOverlays();
            Iterator<Overlay> iterator = object.iterator();
            while (iterator.hasNext()) {
                Overlay overlay = iterator.next();
                if (!overlay.captureAsRGB()) continue;
                bl = true;
                break;
            }
        }
        object = new ViewSnapshot(overlayMode, n, n2, bl);
        ((ViewSnapshot)object).setDataBuffer(((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData());
        return object;
    }

    public void localWindow(int n, int n2) {
    }

    public TransferFunction getTransferFunction() {
        return null;
    }

    public List<Overlay> getPresentationObjects() {
        return this.overlays;
    }

    public List<Overlay> getVisiblePresentationObjects() {
        return this.getPresentationObjects();
    }

    public void broadcastUpdate(Object object) {
        TEvent tEvent = new TEvent();
        tEvent.id = 71;
        tEvent.source = this;
        TEventDispatch.sendEvent(tEvent, object);
    }

    protected MousePositionDestination getMouseFollower() {
        return null;
    }

    @Override
    public void progressNotification(String string, double d) {
        EventUtil.invoke(() -> this.progressNotificationImpl(string, d));
    }

    private void progressNotificationImpl(String string, double d) {
        InViewData inViewData = this.inView;
        if (inViewData == null) {
            this.inView = inViewData = new InViewData();
        }
        if (inViewData.progress == null && (int)(d * 100.0) < 100) {
            inViewData.progress = new TProgressBar();
            inViewData.progress.setFont(FontUtils.getAgfaFontSmall());
            inViewData.progress.setMinimum(0);
            inViewData.progress.setMaximum(100);
            inViewData.progress.setShowProgressText(true);
        }
        if ((int)(d * 100.0) >= 100) {
            inViewData.progress = null;
        } else {
            inViewData.progress.setProgressText(String.valueOf(string) + ": ");
            inViewData.progress.setVal((int)(d * 100.0));
        }
        if (this.getVisView() != null) {
            this.getVisView().repaint();
        }
    }

    @Override
    public Component getProgressDisplay() {
        if (this.inView == null) {
            return null;
        }
        return this.inView.progress;
    }

    public void resetOverlayCachedValues() {
        List<Overlay> list = this.getPresentationObjects();
        for (Overlay overlay : list) {
            if (overlay == null) continue;
            overlay.resetCachedValues();
        }
    }

    public PresentationObject getSelectedPO() {
        for (PresentationObject presentationObject : Overlay.filter(PresentationObject.class, this.getPresentationObjects())) {
            if (!presentationObject.isSelected()) continue;
            return presentationObject;
        }
        return null;
    }

    public boolean copyToOtherDisplays(SyncablePresentationObject syncablePresentationObject) {
        SynchronizationManager.CompatibilityMode compatibilityMode = SynchronizationManager.CompatibilityMode.FRAME_OF_REFERENCE_TRANSFORM_AVAILABLE;
        return this.copyToDestinations(syncablePresentationObject, compatibilityMode.getOverlaySynchronizationMode(), SynchronizationManager.getInstance().getCompatibleDisplaySets(this.getVis(), JVision2.getMainFrame().getDisplays(), compatibilityMode), new IPresentationObjectCopyListener[0]);
    }

    public boolean copyToDestinations(SyncablePresentationObject syncablePresentationObject, OverlaySynchronizationMode overlaySynchronizationMode, List<VisData> list, IPresentationObjectCopyListener ... iPresentationObjectCopyListenerArray) {
        if (list.isEmpty()) {
            return false;
        }
        PresentationObjectCopyData presentationObjectCopyData = new PresentationObjectCopyData(syncablePresentationObject, overlaySynchronizationMode, iPresentationObjectCopyListenerArray);
        for (VisData visData : list) {
            this.copyToVis(visData, presentationObjectCopyData);
            VisDisplay2 visDisplay2 = visData.getParent().getVisDisplay();
            visDisplay2.setNavigationPosition(visData.getParent().indexOf(visData), new VisDisplay2.NavigationPositionOption[0]);
            visDisplay2.invalidate();
            visDisplay2.repaint();
        }
        return true;
    }

    public void copyToSelectedVis(PresentationObject presentationObject, OverlaySynchronizationMode overlaySynchronizationMode) {
        PresentationObjectCopyData presentationObjectCopyData = new PresentationObjectCopyData(presentationObject, overlaySynchronizationMode, new IPresentationObjectCopyListener[0]);
        List<VisData> list = this.getDisplay().getVis();
        for (VisData visData : list) {
            View view = visData.getView();
            if (!visData.isSelected() || view == this) continue;
            this.copyToVis(visData, presentationObjectCopyData);
        }
    }

    private void copyToVis(VisData visData, PresentationObjectCopyData presentationObjectCopyData) {
        View view = visData.getView();
        if (!visData.isLoaded()) {
            visData.loadFinal();
        }
        try {
            TEvent tEvent = new TEvent();
            tEvent.id = 123;
            tEvent.source = this;
            view.handleTEvent(tEvent, presentationObjectCopyData, 0);
        }
        catch (Exception exception) {
            log.error("Copying overlay failed.", (Throwable)exception);
        }
    }

    public PresentationObject copyPresentationObject(PresentationObject presentationObject, OverlaySynchronizationMode overlaySynchronizationMode) {
        Object object;
        IImageInformationProvider iImageInformationProvider;
        Renderer renderer = this.getRenderer();
        if (renderer instanceof IRDCRenderer) {
            iImageInformationProvider = presentationObject.getView();
            ((IRDCRenderer)((Object)renderer)).setGeometry(((View)iImageInformationProvider).getcwidth(), ((View)iImageInformationProvider).getcheight(), 0, ((View)iImageInformationProvider).getcwidth());
        }
        iImageInformationProvider = presentationObject.copyTo(this, overlaySynchronizationMode);
        this.addOverlay((Overlay)iImageInformationProvider);
        if (((PresentationObject)iImageInformationProvider).getHistogramOverlay() != null && ((PresentationObject)iImageInformationProvider).getHistogramOverlay().isVisible()) {
            object = new ImageRegion((ClippingShape)((Object)iImageInformationProvider));
            IImageRegionProperties iImageRegionProperties = null;
            Renderer renderer2 = renderer;
            if (renderer2.getRegionSource() != null) {
                iImageRegionProperties = renderer2.getRegionSource().getImageRegionProperties((ImageRegion)object, ((Overlay)iImageInformationProvider).getViewHeight(), ((Overlay)iImageInformationProvider).getViewHeight(), renderer2.getImageState().getCurrentValueMapping());
            }
            if (iImageRegionProperties != null && iImageRegionProperties.getHistogram() != null) {
                ((PresentationObject)iImageInformationProvider).getHistogramOverlay().setHistogram(iImageRegionProperties.getHistogram());
                ((PresentationObject)iImageInformationProvider).setShapeChanged(true);
            }
        }
        if (((PresentationObject)iImageInformationProvider).getDataProfilePlot() != null) {
            ((PresentationObject)iImageInformationProvider).getDataProfilePlot().setPointSequence((PointSequence)((Object)iImageInformationProvider));
            ((PresentationObject)iImageInformationProvider).setShapeChanged(true);
        }
        if ((object = ((PresentationObject)iImageInformationProvider).getCompanions()) != null) {
            int n = 0;
            while (n < ((Overlay[])object).length) {
                if (object[n] != null) {
                    if (object[n] instanceof PresentationObject) {
                        ((PresentationObject)object[n]).setShapeChanged(true);
                    }
                    this.addOverlay(object[n]);
                }
                ++n;
            }
        }
        ((PresentationObject)iImageInformationProvider).setShapeChanged(true);
        this.invalidate();
        ((PresentationObject)iImageInformationProvider).updateLegend();
        this.setImgInvalid(true);
        this.repaint();
        return iImageInformationProvider;
    }

    public boolean isLockBackground() {
        return this.lockBackground;
    }

    public Collection<Overlay> getExcludeFromLock() {
        return this.excludeFromLock;
    }

    public void setExcludeFromLock(Collection<Overlay> collection) {
        this.excludeFromLock = collection;
    }

    public void visSet(Vis2 vis2) {
        if (vis2 == null) {
            this.lockBackground(false);
        } else {
            IViewMouseHandler iViewMouseHandler = this.getMouseHandler();
            if (iViewMouseHandler.POselectedOnThisView()) {
                PresentationObject presentationObject = this.getDisplay().getSelectedPO();
                if (presentationObject == null && iViewMouseHandler instanceof ViewMouseHandler) {
                    presentationObject = ((ViewMouseHandler)iViewMouseHandler).getActivePO();
                }
                iViewMouseHandler.lockBackgroundForPOandCompanions(presentationObject);
            }
        }
        if (vis2 == null && this.frameData != null && this.frameData.getRawDataContainer() != null) {
            this.frameData.getRawDataContainer().resetHistogram();
        }
    }

    @SuppressWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"})
    public boolean equals(Object object) {
        if (object instanceof MyWeakReference) {
            View view = (View)((MyWeakReference)object).get();
            return this == view;
        }
        return super.equals(object);
    }

    public boolean repaintViewAfterEachWindowingEvent() {
        return false;
    }

    public boolean visBorderEnabled() {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public List<PAction> getViewContextMenuButtonActions() {
        return new ArrayList<PAction>();
    }

    public IVOILUT createVOILUTForHijackedPresentationState(boolean bl, IPixelDataFrame<?> iPixelDataFrame) {
        return null;
    }

    public List<PAction> getViewContextMenuTextActions() {
        return new ArrayList<PAction>(1);
    }

    public boolean isCine() {
        return false;
    }

    public FilterActions.FilterApplicability getFilterApplicability() {
        IImageInformation iImageInformation = this.getImageInformation();
        if (iImageInformation != null && iImageInformation.getPhotometricInterpretation().isColor()) {
            return FilterActions.FilterApplicability.deny(Messages.getString("FilterApplicability.DeniedForColorImages"));
        }
        return FilterActions.FilterApplicability.allow();
    }

    public boolean allowsBroadcastOfWindowLevel() {
        return true;
    }

    protected BufferedImage getPoster() {
        return null;
    }

    protected void paintPosterImpl(Graphics graphics, boolean bl) {
        BufferedImage bufferedImage = this.getPoster();
        if (bufferedImage == null) {
            return;
        }
        double d = (double)bufferedImage.getWidth() / (double)this.cwidth;
        double d2 = (double)bufferedImage.getHeight() / (double)this.cheight;
        if (bl) {
            int n = this.cwidth;
            int n2 = this.cheight;
            int n3 = 0;
            int n4 = 0;
            if (d > d2) {
                n4 = (this.cheight - (int)((double)bufferedImage.getHeight() / d)) / 2;
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.cwidth, n4);
                graphics.fillRect(0, this.cheight - n4, this.cwidth, n4);
                n2 = (int)((double)bufferedImage.getHeight() / d);
            } else {
                n3 = (this.cwidth - (int)((double)bufferedImage.getWidth() / d2)) / 2;
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, n3, this.cheight);
                graphics.fillRect(this.cwidth - n3, 0, n3, this.cheight);
                n = (int)((double)bufferedImage.getWidth() / d2);
            }
            bufferedImage = (BufferedImage)IconUtil.scaleImage((Image)bufferedImage, (int)n, (int)n2);
            graphics.drawImage(bufferedImage, n3, n4, n, n2, null);
        } else {
            float f;
            int n = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            if (this.cwidth < n) {
                f = (float)this.cwidth / (float)n;
                n5 = (int)((float)n5 * f);
                n = this.cwidth;
            }
            if (this.cheight < n5) {
                f = (float)this.cheight / (float)n5;
                n = (int)((float)n * f);
                n5 = this.cheight;
            }
            int n6 = (this.cwidth - n) / 2;
            int n7 = (this.cheight - n5) / 2;
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n6, this.cheight);
            graphics.fillRect(this.cwidth - n6, 0, n6, this.cheight);
            graphics.drawImage(bufferedImage, n6, n7, n, n5, null);
        }
    }

    public static enum CAPTURE_STATES {
        ZOOM_PAN,
        WINDOW_LEVEL,
        INVERT,
        TRANSFORMATION,
        FILTER;

    }

    private static class InViewData {
        private int lostdxRel;
        private int lostdyRel;
        private boolean interaction;
        private int lastDxAbs;
        private int lastDyAbs;
        private boolean lastDenied;
        private long lastMouseEventWhen;
        private long lastStartMillis;
        private long systemDuration;
        private TProgressBar progress;
        private int[] lockedBgBuffer;
        private boolean bgWasLockedOnStart;
        private Collection<Overlay> wasExcludedOnStart;

        private InViewData() {
        }
    }

    public static enum OverlayMode {
        PRINT_BURN_MAPPINGS,
        PRINT_OVERLAY_ALL,
        PRINT_OVERLAY_ROI,
        PRINT_OVERLAY_NONE,
        PRINT_OVERLAY_ALL_AND_ROI,
        PRINT_BURN_ROI;

    }
}

