/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.IViewportHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import javax.vecmath.Vector2d;
import org.apache.commons.lang3.exception.CloneFailedException;

public abstract class ViewportHandler
implements IViewportHandler {
    private static final double MAXIMUM_ZOOM_FACTOR = 32.0;
    protected int myNodeID = 0;
    protected float centerX;
    protected float centerY;

    protected ViewportHandler() {
    }

    @Override
    public ViewportHandler clone() {
        try {
            return (ViewportHandler)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneFailedException("Cloning viewport handler failed", (Throwable)cloneNotSupportedException);
        }
    }

    @Override
    public void setNodeID(int n) {
        this.myNodeID = n;
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.source == view) {
            return false;
        }
        switch (tEvent.id) {
            case 17: {
                if (!(object instanceof ViewportDefinition)) break;
                ViewportDefinition viewportDefinition = (ViewportDefinition)object;
                this.normalizedZoom(viewportDefinition.relXo, viewportDefinition.relYo, viewportDefinition.relWidth, viewportDefinition.relHeight, view);
                break;
            }
            case 2: {
                if (tEvent.interactionModifier != 2) break;
                if (object instanceof ZoomParameter) {
                    ((ZoomParameter)object).applyTo(this, view);
                    this.endZooming(view);
                } else {
                    this.panNormalized(((double[])object)[0], ((double[])object)[1], view);
                    this.endPanning(view);
                }
                return true;
            }
        }
        return false;
    }

    protected void startZooming(View view) {
        view.actionStarted(this);
    }

    protected void startPanning(View view) {
        view.actionStarted(this);
    }

    protected void endZooming(View view) {
        if (this.myNodeID == 0) {
            view.actionFinished(this);
        }
    }

    protected void endPanning(View view) {
        if (this.myNodeID == 0) {
            view.actionFinished(this);
        }
    }

    private void getZoomRectModeCenter(double d, Vector2d vector2d, Vector2d vector2d2) {
        vector2d2.x = 1.0 / d;
        vector2d2.y = 1.0 / d;
        vector2d.x = (double)this.centerX - vector2d2.x / 2.0;
        vector2d.y = (double)this.centerY - vector2d2.y / 2.0;
    }

    protected void startActiveCenterZoom(ZoomType zoomType, double d, View view) {
        this.startZooming(view);
        this.centerX = 0.5f;
        this.centerY = 0.5f;
        this.sendActiveCenterZoomEvent(zoomType, view, 0);
    }

    protected void progressActiveCenterZoom(ZoomType zoomType, double d, View view) {
        this.applyAbsoluteZoomFactor(d, view);
        this.sendActiveCenterZoomEvent(zoomType, view, 1);
    }

    protected void endActiveCenterZoom(ZoomType zoomType, double d, View view) {
        this.endZooming(view);
        this.applyAbsoluteZoomFactor(d, view);
        this.sendActiveCenterZoomEvent(zoomType, view, 2);
    }

    private void applyAbsoluteZoomFactor(double d, View view) {
        Vector2d vector2d = new Vector2d();
        Vector2d vector2d2 = new Vector2d();
        this.getZoomRectModeCenter(this.restrictZoomFactor(d), vector2d, vector2d2);
        this.normalizedZoom(vector2d.x, vector2d.y, vector2d2.x, vector2d2.y, view);
    }

    private void sendActiveCenterZoomEvent(ZoomType zoomType, View view, int n) {
        TEvent tEvent = new TEvent();
        tEvent.source = view;
        tEvent.id = 2;
        tEvent.destinationNodeID = this.myNodeID;
        tEvent.interactionModifier = n;
        TEventDispatch.sendEvent(tEvent, this.createZoomParameterForActiveCenterZoomEvent(zoomType, view));
    }

    protected ZoomParameter createZoomParameterForActiveCenterZoomEvent(ZoomType zoomType, View view) {
        return ZoomParameter.absolute(this.getZoomFactor());
    }

    @Override
    public void setZoomFactor(double d, View view) {
        double d2 = 1.0 / this.restrictZoomFactor(d);
        this.normalizedZoom(0.0, 0.0, d2, d2, view);
    }

    protected double restrictZoomFactor(double d) {
        if (d > 32.0) {
            return 32.0;
        }
        return d;
    }

    protected abstract void normalizedZoom(double var1, double var3, double var5, double var7, View var9);

    public abstract void startActivePanning(View var1);

    public abstract void panRelative(double var1, double var3, View var5);

    public abstract void panNormalized(double var1, double var3, View var5);

    public abstract void endActivePanning(View var1);

    public static enum ZoomType {
        HOT_REGION,
        MOUSE_WHEEL;

    }
}

