/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.plugin.ExportProgressStateModel;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.FileUtil;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.jvision.image.AbstractWaitingView;
import com.tiani.jvision.vis.VisDisplay2;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public abstract class WaitForImagesView
extends AbstractWaitingView
implements IObjectListener {
    private static final ALogger log = ALogger.getLogger(WaitForImagesView.class);
    private static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    protected IFrameObjectData lightWeightFirstImage;
    protected int defaultIconHeight = GUI.getScaledDiagnosticInt((int)64);
    private int totalObjectCount;
    private Set<String> instanceUIDs = null;

    public WaitForImagesView(IFrameObjectData[] iFrameObjectDataArray, IDisplaySet iDisplaySet) {
        super(iFrameObjectDataArray, iDisplaySet);
        this.lightWeightFirstImage = iFrameObjectDataArray[0];
        this.instanceUIDs = Collections.synchronizedSet(new HashSet(iFrameObjectDataArray.length));
        IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
            this.instanceUIDs.add(iFrameObjectData.getSOPInstanceUID());
            ++n2;
        }
        this.totalObjectCount = this.instanceUIDs.size();
    }

    @Override
    protected void startDataFetching(final IFrameObjectData[] iFrameObjectDataArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WaitForImagesView.this.addDatas(iFrameObjectDataArray);
            }
        };
        new Thread(runnable, "WaitingForImagesView").start();
    }

    protected void addDatas(IFrameObjectData[] iFrameObjectDataArray) {
        ArrayList<IImageObjectData> arrayList = new ArrayList<IImageObjectData>();
        HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
        IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iDataObject = iFrameObjectDataArray2[n2];
            hashSet.add(iDataObject.getMainFrame());
            ++n2;
        }
        for (IImageObjectData iImageObjectData : hashSet) {
            iImageObjectData.addListener(this);
            if (iImageObjectData.isFullyLoaded()) continue;
            arrayList.add(iImageObjectData);
        }
        if (!arrayList.isEmpty()) {
            fetcher.changeToHigherPriorityIfExists(arrayList, (byte)1);
        }
    }

    @Override
    public void lossyObjectFinished(IObjectData iObjectData) {
    }

    @Override
    public void objectFinished(IObjectData iObjectData) {
        this.instanceUIDs.remove(iObjectData.getSOPInstanceUID());
        if (this.instanceUIDs.isEmpty() && !this.multipleSeriesPossible()) {
            this.dataFetchFinished();
        }
    }

    @Override
    public void cleanUp() {
        this.instanceUIDs.clear();
        super.cleanUp();
    }

    public double getLoadFraction() {
        return 1.0 - (double)this.instanceUIDs.size() / (double)this.totalObjectCount;
    }

    public void startExternalApplication() {
    }

    public void exportDisplaySets(List<IDisplaySet> list, File file, boolean bl) {
        ArrayList<IObjectData> arrayList = new ArrayList<IObjectData>();
        HashSet<String> hashSet = new HashSet<String>();
        for (IDisplaySet object2 : list) {
            IFrameObjectData[] iFrameObjectDataArray = object2.getObjects();
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                IImageObjectData iImageObjectData = iFrameObjectData.getMainFrame();
                if (!hashSet.contains(iImageObjectData.getKey())) {
                    arrayList.add(iImageObjectData);
                    hashSet.add(iImageObjectData.getKey());
                }
                ++n2;
            }
        }
        ExportProgressStateModel exportProgressStateModel = new ExportProgressStateModel(this);
        DataManager.getInstance().getFetcher().exportDicomObjects(arrayList, file, bl, exportProgressStateModel);
    }

    public boolean multipleSeriesPossible() {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isAlreadyRunning(String var1_1) {
        var1_1 = var1_1.toLowerCase(Locale.ENGLISH);
        try {
            var2_2 = null;
            try {
                var2_2 = Runtime.getRuntime().exec(new String[]{"tasklist.exe"});
            }
            catch (IOException v0) {
                var2_2 = Runtime.getRuntime().exec(new String[]{"tlist.exe"});
            }
            var3_4 = null;
            var4_6 = null;
            try {
                block18: {
                    var5_9 = new InputStreamReader(var2_2.getInputStream());
                    try {
                        var6_10 = new BufferedReader(var5_9);
                        try {
                            ** GOTO lbl33
                        }
                        finally {
                            if (var6_10 != null) {
                                var6_10.close();
                            }
                        }
                    }
                    catch (Throwable var4_7) {
                        if (var3_4 == null) {
                            var3_4 = var4_7;
                        } else if (var3_4 != var4_7) {
                            var3_4.addSuppressed(var4_7);
                        }
                        if (var5_9 == null) throw var3_4;
                        var5_9.close();
                        throw var3_4;
                    }
                    if (var5_9 == null) ** GOTO lbl-1000
                    var5_9.close();
lbl-1000:
                    // 2 sources

                    {
                        return true;
lbl33:
                        // 1 sources

                        var7_11 = var6_10.readLine();
                        if (var7_11 == null) break block18;
                    }
                }
                if (var5_9 == null) return false;
                var5_9.close();
                return false;
            }
            catch (Throwable var4_8) {
                if (var3_4 == null) {
                    var3_4 = var4_8;
                    throw var3_4;
                }
                if (var3_4 == var4_8) throw var3_4;
                var3_4.addSuppressed(var4_8);
                throw var3_4;
            }
        }
        catch (Exception var2_3) {
            WaitForImagesView.log.warn("Problem determining if the process " + var1_1 + " is already running", (Throwable)var2_3);
        }
        return false;
    }

    protected static File clearOrCreateDirectory(String string) {
        return WaitForImagesView.clearOrCreateDirectory(string, null);
    }

    protected static File clearOrCreateDirectoryIgnoringNonEmptySubdirectories(String string) {
        return WaitForImagesView.clearOrCreateDirectory(string, file -> true);
    }

    protected static File clearOrCreateDirectory(String string, Predicate<File> predicate) {
        File file = new File(string);
        if (file.exists()) {
            if (predicate == null) {
                FileUtil.remove((File)file);
            } else {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    Arrays.stream(fileArray).filter(predicate).forEach(File::delete);
                }
            }
        }
        if (!file.mkdirs()) {
            log.warn("Creating directory failed: " + string);
        }
        return file;
    }

    protected class ProcessAliveListener
    extends Thread {
        private Process p;

        public ProcessAliveListener(Process process) {
            this.setPriority(1);
            this.setDaemon(true);
            this.p = process;
        }

        @Override
        public void run() {
            try {
                this.p.waitFor();
                log.info("External application ended!");
                VisDisplay2 visDisplay2 = WaitForImagesView.this.getDisplay();
                if (visDisplay2 != null) {
                    visDisplay2.revertToDefaultPlugin();
                }
            }
            catch (InterruptedException interruptedException) {
                log.warn("Waiting for process termination was interrupted", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
    }
}

