/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowValue;

public class WindowHandlerNuk
extends WindowHandlerBase {
    private static final int MINIMUM_PIXEL_DISTANCE = 5;
    private double windowMax = Double.NaN;
    private double windowMin;

    WindowHandlerNuk(IImageInformation iImageInformation, WindowDef windowDef) {
        super(iImageInformation, (ILUTContainer)iImageInformation, iImageInformation.isInverse(), iImageInformation.isSigned(), windowDef);
    }

    WindowHandlerNuk(IImageInformation iImageInformation) {
        super(iImageInformation, (ILUTContainer)iImageInformation, iImageInformation.isInverse(), iImageInformation.isSigned(), (IHistogramProvider)null);
    }

    WindowHandlerNuk(IImageInformation iImageInformation, ILUTContainer iLUTContainer, boolean bl, boolean bl2, IHistogramProvider iHistogramProvider) {
        super(iImageInformation, iLUTContainer, bl, bl2, iHistogramProvider);
    }

    protected WindowHandlerNuk(WindowHandlerBase windowHandlerBase) {
        super(windowHandlerBase);
    }

    @Override
    public String getWindowDescription() {
        return "LU = " + this.formatWindowValue(this.window.getCenter() - this.window.getWidth() / 2.0) + " / " + this.formatWindowValue(this.window.getCenter() + this.window.getWidth() / 2.0) + " " + this.window.getUnit();
    }

    @Override
    protected void initWindowSens(IImageInformation iImageInformation) {
        this.mouseWindowSens = this.window.getGrays();
    }

    @Override
    protected WindowValue mWindow(int n, int n2, boolean bl, boolean bl2) {
        double d = this.mouseWindowSens;
        if (bl) {
            d = this.window.getGrays() * 2;
        }
        int n3 = Math.abs(clickPosX - n);
        int n4 = Math.abs(clickPosY - n2);
        if (n3 > 5 && n3 > n4) {
            double d2 = (double)clickCenter - (double)clickWidth * 0.5;
            double d3 = (double)clickWidth + (double)(wwSign * (n - clickPosX)) / d;
            double d4 = d2 + d3 * 0.5;
            this.updateWindow(d4, d3);
            return null;
        }
        if (n4 > 5 && n4 > n3) {
            double d5 = (double)clickCenter + (double)clickWidth * 0.5;
            double d6 = (double)clickWidth + (double)(wwSign * (n2 - clickPosY)) / d;
            double d7 = d5 - d6 * 0.5;
            this.updateWindow(d7, d6);
            return null;
        }
        return null;
    }

    @Override
    protected void updateWindow(double d, double d2) {
        if (!Double.isNaN(this.windowMax)) {
            double d3 = d + d2 / 2.0;
            double d4 = d - d2 / 2.0;
            boolean bl = false;
            if (d3 > this.windowMax) {
                d3 = this.windowMax;
                bl = true;
            }
            if (d3 < this.windowMin) {
                d3 = this.windowMin;
                bl = true;
            }
            if (d4 > this.windowMax) {
                d4 = this.windowMax;
                bl = true;
            }
            if (d4 < this.windowMin) {
                d4 = this.windowMin;
                bl = true;
            }
            if (bl) {
                d = (d3 + d4) / 2.0;
                d2 = d3 - d4;
            }
        }
        super.updateWindow(d, d2);
    }

    @Override
    public void reset(ILUTContainer iLUTContainer) {
        super.reset(iLUTContainer);
        this.applyWindowLimits();
    }

    public void limitWindowing(double d, double d2) {
        this.windowMax = this.logicalToData(d2) / (double)this.window.getGrays();
        this.windowMin = this.logicalToData(d) / (double)this.window.getGrays();
        if (this.window.isSigned()) {
            this.windowMax += 0.5;
            this.windowMin += 0.5;
        }
        this.applyWindowLimits();
    }

    private void applyWindowLimits() {
        if (!Double.isNaN(this.windowMax)) {
            this.updateWindow((this.windowMin + this.windowMax) / 2.0, this.windowMax - this.windowMin);
        }
    }
}

