/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gsts.ILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILookupTable;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowHandler;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowTransferFunction;
import com.tiani.jvision.image.WindowValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class WindowHandlerVOILUT
extends WindowHandlerBase {
    private int minValue;
    private int maxValue;
    private int minBorder;
    private int maxBorder;
    private int len;

    protected WindowHandlerVOILUT(WindowHandlerBase windowHandlerBase) {
        super(windowHandlerBase);
        if (windowHandlerBase instanceof WindowHandlerVOILUT) {
            WindowHandlerVOILUT windowHandlerVOILUT = (WindowHandlerVOILUT)windowHandlerBase;
            this.minBorder = windowHandlerVOILUT.minBorder;
            this.maxBorder = windowHandlerVOILUT.maxBorder;
            this.minValue = windowHandlerVOILUT.minValue;
            this.maxValue = windowHandlerVOILUT.maxValue;
            this.len = windowHandlerVOILUT.len;
            this.initWindow();
        } else if (windowHandlerBase.getGSTS().getVOILUT() != null) {
            this.init();
        }
    }

    private void initWindow() {
        this.performRelativeWindowing = true;
        double d = (double)((this.maxBorder + this.minBorder) / 2) / (double)this.len;
        double d2 = (double)(this.maxBorder - this.minBorder + 1) / (double)this.len;
        this.window.setNormalizedCenter(d);
        this.window.setNormalizedWidth(d2);
    }

    private void init() {
        this.detectBorders();
        this.initWindow();
    }

    private void detectBorders() {
        int n;
        short[] sArray = this.getGSTS().getVOILUT().getData();
        this.minValue = sArray[0] & 0xFFFF;
        this.maxValue = sArray[sArray.length - 1] & 0xFFFF;
        this.minBorder = 0;
        this.maxBorder = sArray.length - 1;
        int n2 = 0;
        while (n2 < sArray.length) {
            n = sArray[n2] & 0xFFFF;
            if (this.minValue != n) break;
            this.minBorder = n2++;
        }
        n2 = sArray.length - 1;
        while (n2 >= 0) {
            n = sArray[n2] & 0xFFFF;
            if (this.maxValue != n) break;
            this.maxBorder = n2--;
        }
        this.len = sArray.length;
    }

    @Override
    public String getWindowDescription() {
        if (WindowHandler.reverseValues) {
            return "WC = " + this.formatWindowValue(this.window.getWidth()) + " / " + this.formatWindowValue(this.window.getCenter());
        }
        return "CW = " + this.formatWindowValue(this.window.getCenter()) + " / " + this.formatWindowValue(this.window.getWidth());
    }

    @Override
    protected boolean canWindowVOILUT() {
        return this.getGSTS().getActiveOriginalVOILUT().isMonotoneous();
    }

    @Override
    protected WindowValue mWindow(int n, int n2, boolean bl, boolean bl2) {
        WindowValue windowValue = this.getNormalizedWindowFromMousePosition(n, n2, bl);
        this.windowVOILUT(windowValue.getWindowCenter(), windowValue.getWindowWidth());
        return new WindowValue(this.window.getNormalizedCenter() / this.origWindowDef.getNormalizedCenter(), this.window.getNormalizedWidth() / this.origWindowDef.getNormalizedWidth(), true);
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        boolean bl = super.handleTEvent(tEvent, object, n, view);
        if (tEvent.id == 64 && this.getGSTS().getVOILUT() != null) {
            this.init();
        }
        return bl;
    }

    @Override
    protected void handleBroadCastedWindowValue(WindowValue windowValue) {
        if (windowValue.isRelative()) {
            this.windowVOILUT(this.origWindowDef.getNormalizedCenter() * windowValue.getWindowCenter(), this.origWindowDef.getNormalizedWidth() * windowValue.getWindowWidth());
        } else {
            super.handleBroadCastedWindowValue(windowValue);
        }
    }

    private void windowVOILUT(double d, double d2) {
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.getGSTS();
        if (!grayScaleTransformationSequence.isVOILUTEnabled()) {
            this.window.setNormalizedCenter(d);
            this.window.setNormalizedWidth(d2);
            return;
        }
        short[] sArray = grayScaleTransformationSequence.getActiveOriginalVOILUT().getData();
        short[] sArray2 = DataCacheProviderFactory.getMemoryPool().allocShorts((long)this.len);
        int n = (int)Math.round((d - d2 / 2.0) * (double)this.len);
        int n2 = (int)Math.round((d + d2 / 2.0) * (double)this.len);
        int n3 = n2 - n;
        int n4 = n;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.len) {
            n = this.len - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.len) {
            n2 = this.len - 1;
        }
        int n5 = 0;
        while (n5 < n) {
            sArray2[n5] = (short)this.minValue;
            ++n5;
        }
        n5 = this.len - 1;
        while (n5 > n2) {
            sArray2[n5] = (short)this.maxValue;
            --n5;
        }
        n5 = this.maxBorder - this.minBorder;
        int n6 = n;
        while (n6 <= n2) {
            try {
                float f = (float)(n6 - n4) / (float)n3 * (float)n5 + (float)this.minBorder;
                int n7 = (int)f;
                sArray2[n6] = n7 < 0 ? (short)this.minValue : (n7 >= this.len - 1 ? (short)this.maxValue : (n3 == 0 ? (short)((this.minValue + this.maxValue) / 2) : (short)Math.round((float)(sArray[n7] & 0xFFFF) * ((float)(n7 + 1) - f) + (float)(sArray[n7 + 1] & 0xFFFF) * (f - (float)n7))));
            }
            catch (RuntimeException runtimeException) {
                log.info("EEE");
            }
            ++n6;
        }
        grayScaleTransformationSequence.windowVOILUT(sArray2);
        this.window.setNormalizedCenter(d);
        this.window.setNormalizedWidth(d2);
        DataCacheProviderFactory.getMemoryPool().free(sArray2);
    }

    @Override
    public IVOILUT getVOILUTForPresentationState(boolean bl) {
        if (!bl) {
            return null;
        }
        GrayScaleTransformationSequence grayScaleTransformationSequence = this.getGSTS();
        ILUT iLUT = grayScaleTransformationSequence.getVOILUT();
        if (iLUT == null || iLUT.getData() == null) {
            return null;
        }
        VOILUT vOILUT = VOILUT.createEmpty();
        vOILUT.voiLookupTables().add(this.createVOILookupTable(iLUT));
        ILUT[] iLUTArray = grayScaleTransformationSequence.getOriginalVOILUTs();
        int n = iLUTArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILUT iLUT2 = iLUTArray[n2];
            if (!grayScaleTransformationSequence.isWindowPresetActive(iLUT2.getDescription())) {
                vOILUT.voiLookupTables().add(this.createVOILookupTable(iLUT2));
            }
            ++n2;
        }
        vOILUT.setWindowLevelPresets(this.getWindowLevelPresetsForPresentationStateImpl());
        vOILUT.setVoiLutFunction(grayScaleTransformationSequence.getVOILUTFunction());
        return vOILUT;
    }

    private VOILookupTable createVOILookupTable(ILUT iLUT) {
        VOILookupTable vOILookupTable = new VOILookupTable();
        vOILookupTable.setLUTDescriptor(new int[]{this.len == 0 ? 0 : this.len, iLUT.getLUTDescriptor()[1], 16});
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.len * 2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asShortBuffer().put(iLUT.getData());
        vOILookupTable.setLUTData(byteBuffer.array());
        vOILookupTable.setLUTExplanation(iLUT.getDescription());
        return vOILookupTable;
    }

    @Override
    public void setTransferFunction(WindowTransferFunction windowTransferFunction) {
    }

    @Override
    public void reset(ILUTContainer iLUTContainer) {
        if (iLUTContainer == null) {
            GrayScaleTransformationSequence grayScaleTransformationSequence = this.getGSTS();
            grayScaleTransformationSequence.reset(null);
            this.init();
        } else if (iLUTContainer instanceof IImageInformation) {
            IImageInformation iImageInformation = (IImageInformation)iLUTContainer;
            this.tf = new WindowTransferFunction(iLUTContainer, iImageInformation, iImageInformation.isInverse(), iImageInformation.isSigned(), null);
            this.window = this.tf.getGSTS().getWindowDef();
            this.init();
        } else {
            super.reset(iLUTContainer);
        }
    }
}

