/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.image.IViewDimension;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.ViewPort;
import java.awt.Rectangle;

public abstract class AreaFitHandler
implements Cloneable {
    private ViewportCenterAlignmentX vpCenterAlignX = ViewportCenterAlignmentX.CENTER;
    protected double zoomFactorX;
    protected double zoomFactorY;
    protected OutputDeviceMetric outputDevice;
    protected boolean borderLockMode = true;

    public AreaFitHandler() {
        this.outputDevice = OutputDeviceMetric.screen;
    }

    AreaFitHandler(OutputDeviceMetric outputDeviceMetric) {
        this.outputDevice = outputDeviceMetric;
    }

    AreaFitHandler(AreaFitHandler areaFitHandler) {
        this.initFrom(areaFitHandler);
    }

    public AreaFitHandler getClone() {
        try {
            return (AreaFitHandler)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ALogger.getLogger(AreaFitHandler.class).error("Cloning area fit handler failed", (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public void set(AreaFitHandler areaFitHandler) {
        this.initFrom(areaFitHandler);
    }

    private void initFrom(AreaFitHandler areaFitHandler) {
        this.zoomFactorX = areaFitHandler.zoomFactorX;
        this.zoomFactorY = areaFitHandler.zoomFactorY;
        this.borderLockMode = areaFitHandler.borderLockMode;
        this.outputDevice = areaFitHandler.outputDevice;
        this.vpCenterAlignX = areaFitHandler.vpCenterAlignX;
        if (this.outputDevice.screenAR > 1.0) {
            this.zoomFactorX *= this.outputDevice.screenAR;
        }
        if (this.outputDevice.screenAR < 1.0) {
            this.zoomFactorY /= this.outputDevice.screenAR;
        }
    }

    public void setBorderLockMode(boolean bl) {
        this.borderLockMode = bl;
    }

    public ViewportCenterAlignmentX getViewportCenterAlignmentX() {
        return this.vpCenterAlignX;
    }

    public void setViewportCenterAlignmentX(ViewportCenterAlignmentX viewportCenterAlignmentX) {
        this.vpCenterAlignX = viewportCenterAlignmentX;
    }

    public void calculateViewPortAndImageBounds(ImageDef imageDef, ViewPort viewPort, Rectangle rectangle, int n, int n2) {
        this.updateZoomFactor(imageDef, n, n2);
        this.checkViewPortCenter(imageDef, n, n2);
        this.updateViewPort(imageDef, viewPort, rectangle, n, n2);
    }

    private void updateViewPort(ImageDef imageDef, ViewPort viewPort, Rectangle rectangle, int n, int n2) {
        if (imageDef == null) {
            return;
        }
        double d = (double)n / 2.0;
        double d2 = (double)n2 / 2.0;
        if (ViewportCenterAlignmentX.LEFT == this.vpCenterAlignX) {
            d = 0.0;
        } else if (ViewportCenterAlignmentX.RIGHT == this.vpCenterAlignX) {
            d = n;
        }
        double[] dArray = imageDef.getTransformedViewportCenter();
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = this.getAbsoluteZoomFactorX();
        double d6 = this.getAbsoluteZoomFactorY();
        rectangle.x = (int)Math.round(d - d3 * (double)imageDef.getDisplayedColumns() * d5);
        if (rectangle.x < 0) {
            viewPort.x = (double)(-rectangle.x) / d5;
            rectangle.x = 0;
        } else {
            viewPort.x = 0.0;
        }
        rectangle.y = (int)Math.round(d2 - d4 * (double)imageDef.getDisplayedRows() * d6);
        if (rectangle.y <= 0) {
            viewPort.y = (double)(-rectangle.y) / d6;
            rectangle.y = 0;
        } else {
            viewPort.y = 0.0;
        }
        rectangle.width = (int)Math.round((double)imageDef.getDisplayedColumns() * d5);
        if (rectangle.width > n - rectangle.x) {
            viewPort.width = (double)(n - rectangle.x) / d5;
            rectangle.width = n - rectangle.x;
        } else {
            viewPort.width = imageDef.getDisplayedColumns();
        }
        rectangle.height = (int)Math.round((double)imageDef.getDisplayedRows() * d6);
        if (rectangle.height > n2 - rectangle.y) {
            viewPort.height = (double)(n2 - rectangle.y) / d6;
            rectangle.height = n2 - rectangle.y;
        } else {
            viewPort.height = imageDef.getDisplayedRows();
        }
        if (this.borderLockMode) {
            if (viewPort.height + viewPort.y > (double)imageDef.getDisplayedRows()) {
                viewPort.y = (double)imageDef.getDisplayedRows() - viewPort.height;
            }
            if (viewPort.width + viewPort.x > (double)imageDef.getDisplayedColumns()) {
                viewPort.x = (double)imageDef.getDisplayedColumns() - viewPort.width;
            }
        } else {
            double d7;
            if (viewPort.height + viewPort.y > (double)imageDef.getDisplayedRows()) {
                d7 = viewPort.height;
                viewPort.height = (double)imageDef.getDisplayedRows() - viewPort.y;
                d7 = viewPort.height / d7;
                rectangle.height = (int)Math.round(d7 * (double)rectangle.height);
            }
            if (viewPort.width + viewPort.x > (double)imageDef.getDisplayedColumns()) {
                d7 = viewPort.width;
                viewPort.width = (double)imageDef.getDisplayedColumns() - viewPort.x;
                d7 = viewPort.width / d7;
                rectangle.width = (int)Math.round(d7 * (double)rectangle.width);
            }
        }
        if (Math.abs(viewPort.width - (double)rectangle.width) <= 1.0 && (double)rectangle.width + viewPort.x < (double)imageDef.getDisplayedColumns()) {
            viewPort.width = rectangle.width;
        }
        if (Math.abs(viewPort.height - (double)rectangle.height) <= 1.0 && (double)rectangle.height + viewPort.y < (double)imageDef.getDisplayedRows()) {
            viewPort.height = rectangle.height;
        }
    }

    public void prepareCanvasSizeChange(ImageDef imageDef, int n, int n2) {
        this.updateZoomFactor(imageDef, n, n2);
    }

    protected abstract void updateZoomFactor(ImageDef var1, int var2, int var3);

    protected void setAbsoluteZoomFactor(double d) {
        if (this.outputDevice.screenAR > 1.0) {
            this.zoomFactorX = d / this.outputDevice.screenAR;
            this.zoomFactorY = d;
        } else {
            this.zoomFactorX = d;
            this.zoomFactorY = d * this.outputDevice.screenAR;
        }
    }

    protected void checkViewPortCenter(ImageDef imageDef, int n, int n2) {
        if (imageDef == null || !this.borderLockMode) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        double d = this.getAbsoluteZoomFactorX() * (double)imageDef.getDisplayedColumns();
        double d2 = this.getAbsoluteZoomFactorY() * (double)imageDef.getDisplayedRows();
        double d3 = imageDef.getTransformedViewportCenter()[0];
        double d4 = imageDef.getTransformedViewportCenter()[1];
        if (d < (double)n) {
            bl = true;
            d3 = 0.5;
        }
        if (d2 < (double)n2) {
            d4 = 0.5;
            bl2 = true;
        }
        double d5 = 0.0;
        d5 = d3 < 0.5 ? d3 * d : (1.0 - d3) * d;
        if (d5 < (double)(n / 2) && !bl) {
            d3 = d3 < 0.5 ? (double)(n / 2) / d : 1.0 - (double)(n / 2) / d;
        }
        double d6 = 0.0;
        d6 = d4 < 0.5 ? d4 * d2 : (1.0 - d4) * d2;
        if (d6 < (double)(n2 / 2) && !bl2) {
            d4 = d4 < 0.5 ? (double)(n2 / 2) / d2 : 1.0 - (double)(n2 / 2) / d2;
        }
        imageDef.setTransformedViewportCenter(d3, d4);
    }

    public abstract boolean isDefaultZoomFactor();

    public abstract double restrictZoomFactor(double var1);

    public abstract void pinZoomFactor();

    public abstract void unpinZoomFactor();

    public abstract void applyRelativeZoomFactorChange(double var1, ImageDef var3, IViewDimension var4);

    public abstract void setZoomFactor(double var1, ImageDef var3, IViewDimension var4);

    public abstract void resetZoomFactor();

    public double getAbsoluteZoomFactorX() {
        return this.zoomFactorX;
    }

    public double getAbsoluteZoomFactorY() {
        return this.zoomFactorY;
    }

    public void setOutputDevice(OutputDeviceMetric outputDeviceMetric) {
        this.outputDevice = outputDeviceMetric;
    }

    public OutputDeviceMetric getOutputDevice() {
        return this.outputDevice;
    }

    public boolean isUnrestrictedZoom() {
        return false;
    }

    public static enum ViewportCenterAlignmentX {
        CENTER{

            @Override
            public double calculateViewportCenterX(int n, int n2, int n3) {
                return (double)(n + n2 - 1) / (double)(2 * n3);
            }
        }
        ,
        LEFT{

            @Override
            public double calculateViewportCenterX(int n, int n2, int n3) {
                return (double)n / (double)n3;
            }
        }
        ,
        RIGHT{

            @Override
            public double calculateViewportCenterX(int n, int n2, int n3) {
                return (double)n2 / (double)n3;
            }
        };


        public abstract double calculateViewportCenterX(int var1, int var2, int var3);
    }
}

