/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.agfa.pacs.impaxee.presentationstate.PresentationStateImageBounds;
import com.agfa.pacs.math.Matrix2d;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.image.DoubleDimension;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import javax.vecmath.Vector2d;

final class DisplayedArea {
    private final DoubleRectangle relativeBounds;
    private DoubleDimension pinnedDimension;

    private DisplayedArea(double d, double d2, double d3, double d4) {
        this.relativeBounds = new DoubleRectangle(d, d2, d3, d4);
    }

    static DisplayedArea createFullImage() {
        return new DisplayedArea(0.0, 0.0, 1.0, 1.0);
    }

    static DisplayedArea createFromPS(ImageDef imageDef, int n, int n2, int n3, int n4) {
        double d = imageDef.getColumnCount();
        double d2 = imageDef.getRowCount();
        int n5 = Math.min(n2, n4);
        int n6 = Math.min(n, n3);
        double d3 = (double)(n5 - 1) / d;
        double d4 = (double)(n6 - 1) / d2;
        double d5 = (double)(Math.abs(n4 - n2) + 1) / d;
        double d6 = (double)(Math.abs(n3 - n) + 1) / d2;
        return new DisplayedArea(d3, d4, d5, d6);
    }

    DisplayedArea copy() {
        return new DisplayedArea(this.relativeBounds.x, this.relativeBounds.y, this.relativeBounds.width, this.relativeBounds.height);
    }

    double getAbsoluteZoomFactor(ImageDef imageDef, int n, int n2) {
        double[] dArray = this.getTransformedImageSize(imageDef);
        return FullVisualFitHandler.computeAbsoluteZoomFactor(dArray[0], dArray[1], n, n2);
    }

    void pin() {
        this.pinnedDimension = new DoubleRectangle(this.relativeBounds.x, this.relativeBounds.y, this.relativeBounds.width, this.relativeBounds.height);
    }

    void unpin() {
        this.pinnedDimension = null;
    }

    boolean applyRelativeSizeChange(double d, ImageDef imageDef, AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX, int n, int n2) {
        DoubleDimension doubleDimension = this.pinnedDimension == null ? this.relativeBounds : this.pinnedDimension;
        return this.setDimension(doubleDimension.width * d, doubleDimension.height * d, imageDef, viewportCenterAlignmentX, n, n2);
    }

    DoubleDimension getDimension() {
        return new DoubleDimension(this.relativeBounds);
    }

    boolean setDimension(DoubleDimension doubleDimension, ImageDef imageDef, AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX, int n, int n2) {
        return this.setDimension(doubleDimension.width, doubleDimension.height, imageDef, viewportCenterAlignmentX, n, n2);
    }

    private boolean setDimension(double d, double d2, ImageDef imageDef, AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX, int n, int n2) {
        if (DoubleEquals.equals((double)this.relativeBounds.width, (double)d) && DoubleEquals.equals((double)this.relativeBounds.height, (double)d2)) {
            return false;
        }
        this.relativeBounds.setWidthWithFixedCenter(d, viewportCenterAlignmentX);
        this.relativeBounds.setHeightWithFixedCenter(d2);
        this.updateToCurrentViewSizeRatio(imageDef, viewportCenterAlignmentX, n, n2);
        this.restrictZoomFactor(viewportCenterAlignmentX);
        return true;
    }

    private void restrictZoomFactor(AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX) {
        double d;
        double d2 = 1.0 / Math.min(this.relativeBounds.width, this.relativeBounds.height);
        if (d2 < 0.2) {
            d = d2 / 0.2;
        } else if (d2 > 8.0) {
            d = d2 / 8.0;
        } else {
            return;
        }
        this.scaleWidth(d, viewportCenterAlignmentX);
        this.scaleHeight(d);
    }

    PresentationStateImageBounds getDisplayedAreaForPS(ImageDef imageDef) {
        double d = imageDef.getColumnCount() - 1;
        double d2 = imageDef.getRowCount() - 1;
        int n = (int)Math.round(d * this.relativeBounds.x + 1.0);
        int n2 = (int)Math.round(d2 * this.relativeBounds.y + 1.0);
        int n3 = (int)Math.round(d * (this.relativeBounds.x + this.relativeBounds.width) + 1.0);
        int n4 = (int)Math.round(d2 * (this.relativeBounds.y + this.relativeBounds.height) + 1.0);
        return new PresentationStateImageBounds(n2, n, n4, n3).transform(imageDef);
    }

    void setDisplayedArea(DoubleRectangle doubleRectangle) {
        if (doubleRectangle == null) {
            this.reset();
        } else {
            this.relativeBounds.set(doubleRectangle.x, doubleRectangle.y, doubleRectangle.width, doubleRectangle.height);
        }
    }

    void reset() {
        this.relativeBounds.set(0.0, 0.0, 1.0, 1.0);
    }

    void updatePanPosition(ImageDef imageDef, AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX, int n, int n2) {
        double d;
        AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX2;
        if (imageDef.isFlippedVertically()) {
            switch (viewportCenterAlignmentX) {
                case LEFT: {
                    viewportCenterAlignmentX2 = AreaFitHandler.ViewportCenterAlignmentX.RIGHT;
                    break;
                }
                case RIGHT: {
                    viewportCenterAlignmentX2 = AreaFitHandler.ViewportCenterAlignmentX.LEFT;
                    break;
                }
                default: {
                    viewportCenterAlignmentX2 = viewportCenterAlignmentX;
                    break;
                }
            }
        } else {
            viewportCenterAlignmentX2 = viewportCenterAlignmentX;
        }
        switch (viewportCenterAlignmentX2) {
            case LEFT: {
                d = this.relativeBounds.x;
                break;
            }
            case RIGHT: {
                d = this.relativeBounds.x + this.relativeBounds.width;
                break;
            }
            default: {
                d = this.relativeBounds.getCenterX();
            }
        }
        double d2 = this.relativeBounds.getCenterY();
        Vector2d vector2d = imageDef.getViewportCenter();
        if (DoubleEquals.equals((double)d, (double)vector2d.x) && DoubleEquals.equals((double)d2, (double)vector2d.y)) {
            return;
        }
        this.relativeBounds.x += vector2d.x - d;
        this.relativeBounds.y += vector2d.y - d2;
        this.updateToCurrentViewSizeRatio(imageDef, viewportCenterAlignmentX2, n, n2);
    }

    private void updateToCurrentViewSizeRatio(ImageDef imageDef, AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX, int n, int n2) {
        double d;
        double[] dArray = this.getTransformedImageSize(imageDef);
        double d2 = Math.abs(dArray[0] / dArray[1]);
        if (DoubleEquals.equals((double)d2, (double)(d = (double)n / (double)n2))) {
            return;
        }
        double d3 = d2 < d ? d / d2 : d2 / d;
        if (d2 < d != imageDef.isRotated()) {
            this.scaleWidth(d3, viewportCenterAlignmentX);
        } else {
            this.scaleHeight(d3);
        }
    }

    private double[] getTransformedImageSize(ImageDef imageDef) {
        double[] dArray = new double[]{this.relativeBounds.width * (double)imageDef.getColumnCount(), this.relativeBounds.height * (double)imageDef.getRowCount() * imageDef.getRowScalingFactor()};
        Matrix2d matrix2d = imageDef.getPossibleTransform();
        if (matrix2d != null) {
            matrix2d.transform(dArray);
        }
        return dArray;
    }

    private void scaleWidth(double d, AreaFitHandler.ViewportCenterAlignmentX viewportCenterAlignmentX) {
        this.relativeBounds.setWidthWithFixedCenter(this.relativeBounds.width * d, viewportCenterAlignmentX);
    }

    private void scaleHeight(double d) {
        this.relativeBounds.setHeightWithFixedCenter(this.relativeBounds.height * d);
    }

    public String toString() {
        return this.toString(this.getClass().getSimpleName());
    }

    String toString(String string) {
        return this.relativeBounds.toString(string);
    }
}

