/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.agfa.pacs.impaxee.presentationstate.PresentationStateImageBounds;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.image.DoubleDimension;
import com.tiani.jvision.image.DoubleRectangle;
import com.tiani.jvision.image.IViewDimension;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.DisplayedArea;
import com.tiani.jvision.image.fithandler.ImageDef;

public class FullVisualFitHandler
extends AreaFitHandler {
    private static final ALogger LOGGER = ALogger.getLogger(FullVisualFitHandler.class);
    public static final double MINIMUM_ZOOM_FACTOR = 0.2;
    public static final double MAXIMUM_ZOOM_FACTOR = 8.0;
    private DisplayedArea displayedArea;

    public FullVisualFitHandler() {
        this.displayedArea = DisplayedArea.createFullImage();
    }

    public FullVisualFitHandler(OutputDeviceMetric outputDeviceMetric) {
        super(outputDeviceMetric);
        this.displayedArea = DisplayedArea.createFullImage();
    }

    public FullVisualFitHandler(AreaFitHandler areaFitHandler) {
        super(areaFitHandler);
        this.initDisplayedAreaFrom(areaFitHandler);
    }

    public FullVisualFitHandler(AreaFitHandler areaFitHandler, ImageDef imageDef, int n, int n2, int n3, int n4) {
        super(areaFitHandler);
        this.displayedArea = DisplayedArea.createFromPS(imageDef, n, n2, n3, n4);
    }

    @Override
    public void set(AreaFitHandler areaFitHandler) {
        super.set(areaFitHandler);
        this.initDisplayedAreaFrom(areaFitHandler);
    }

    private void initDisplayedAreaFrom(AreaFitHandler areaFitHandler) {
        this.displayedArea = areaFitHandler instanceof FullVisualFitHandler ? ((FullVisualFitHandler)areaFitHandler).displayedArea.copy() : DisplayedArea.createFullImage();
    }

    @Override
    public FullVisualFitHandler getClone() {
        FullVisualFitHandler fullVisualFitHandler = (FullVisualFitHandler)super.getClone();
        fullVisualFitHandler.displayedArea = this.displayedArea.copy();
        return fullVisualFitHandler;
    }

    @Override
    protected void updateZoomFactor(ImageDef imageDef, int n, int n2) {
        this.displayedArea.updatePanPosition(imageDef, this.getViewportCenterAlignmentX(), n, n2);
        this.updateAbsoluteZoomFactor(imageDef, n, n2);
    }

    private void updateAbsoluteZoomFactor(ImageDef imageDef, int n, int n2) {
        this.setAbsoluteZoomFactor(this.displayedArea.getAbsoluteZoomFactor(imageDef, n, n2));
    }

    public static double computeAbsoluteZoomFactor(double d, double d2, int n, int n2) {
        double d3;
        double d4 = Math.abs(d / d2);
        if (d4 < (d3 = (double)n / (double)n2)) {
            return (double)n2 / Math.abs(d2);
        }
        return (double)n / Math.abs(d);
    }

    @Override
    public boolean isDefaultZoomFactor() {
        DoubleDimension doubleDimension = this.displayedArea.getDimension();
        return DoubleEquals.equals((double)Math.min(doubleDimension.width, doubleDimension.height), (double)1.0);
    }

    @Override
    public void pinZoomFactor() {
        this.displayedArea.pin();
    }

    @Override
    public void unpinZoomFactor() {
        this.displayedArea.unpin();
    }

    @Override
    public void applyRelativeZoomFactorChange(double d, ImageDef imageDef, IViewDimension iViewDimension) {
        if (iViewDimension == null) {
            LOGGER.warn("Setting zoom factor not possible for unknown view");
            return;
        }
        int n = iViewDimension.getcwidth();
        int n2 = iViewDimension.getcheight();
        if (this.displayedArea.applyRelativeSizeChange(1.0 / d, imageDef, this.getViewportCenterAlignmentX(), n, n2)) {
            this.updateAbsoluteZoomFactor(imageDef, n, n2);
        }
    }

    @Override
    public void resetZoomFactor() {
        this.displayedArea.reset();
        this.setAbsoluteZoomFactor(Double.NaN);
    }

    public DoubleDimension getDisplayedAreaSize() {
        return this.displayedArea.getDimension();
    }

    public PresentationStateImageBounds getDisplayedAreaForPS(ImageDef imageDef) {
        return this.displayedArea.getDisplayedAreaForPS(imageDef);
    }

    @Override
    public void setZoomFactor(double d, ImageDef imageDef, IViewDimension iViewDimension) {
        if (iViewDimension == null) {
            LOGGER.warn("Setting zoom factor not possible for unknown view");
            return;
        }
        int n = iViewDimension.getcwidth();
        int n2 = iViewDimension.getcheight();
        double d2 = 1.0 / d;
        if (this.displayedArea.setDimension(new DoubleDimension(d2, d2), imageDef, this.getViewportCenterAlignmentX(), n, n2)) {
            this.updateAbsoluteZoomFactor(imageDef, n, n2);
        }
    }

    public void setDisplayedArea(DoubleRectangle doubleRectangle) {
        this.displayedArea.setDisplayedArea(doubleRectangle);
        this.setAbsoluteZoomFactor(Double.NaN);
    }

    public boolean hasDisplayedAreaSize(DoubleDimension doubleDimension) {
        if (doubleDimension == null) {
            return this.isDefaultZoomFactor();
        }
        return this.hasDisplayedAreaSize(doubleDimension.width, doubleDimension.height);
    }

    private boolean hasDisplayedAreaSize(double d, double d2) {
        DoubleDimension doubleDimension = this.displayedArea.getDimension();
        return DoubleEquals.equals((double)doubleDimension.width, (double)d) && DoubleEquals.equals((double)doubleDimension.height, (double)d2);
    }

    @Override
    public double restrictZoomFactor(double d) {
        return FullVisualFitHandler.restrictZoomFactorToValidRange(d);
    }

    public static double restrictZoomFactorToValidRange(double d) {
        if (d < 0.2) {
            return 0.2;
        }
        if (d > 8.0) {
            return 8.0;
        }
        return d;
    }

    @Override
    protected void checkViewPortCenter(ImageDef imageDef, int n, int n2) {
        if (this.borderLockMode && this.isDefaultZoomFactor()) {
            imageDef.resetTransformedViewportCenter();
            return;
        }
        super.checkViewPortCenter(imageDef, n, n2);
    }

    @Override
    public boolean isUnrestrictedZoom() {
        return true;
    }

    public String toString() {
        return this.displayedArea.toString(this.getClass().getSimpleName());
    }
}

