/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.image.IViewDimension;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;

public class PixelIdentityFitHandler
extends AreaFitHandler {
    private static final int[] ZOOM_FACTORS = new int[]{1, 1, 2, 2, 4, 4, 4, 8, 8};
    private double pinnedZoomFactor = Double.NaN;

    public PixelIdentityFitHandler() {
        this.setAbsoluteZoomFactor(1.0);
    }

    public PixelIdentityFitHandler(AreaFitHandler areaFitHandler) {
        super(areaFitHandler);
    }

    @Override
    public boolean isDefaultZoomFactor() {
        return DoubleEquals.equals((double)this.getZoomFactor(), (double)1.0);
    }

    public double getZoomFactor() {
        return this.zoomFactorX;
    }

    @Override
    public void setZoomFactor(double d, ImageDef imageDef, IViewDimension iViewDimension) {
        this.setZoomFactor(d);
    }

    private void setZoomFactor(double d) {
        this.setAbsoluteZoomFactor(this.restrictZoomFactor(d));
    }

    @Override
    public void resetZoomFactor() {
        this.setAbsoluteZoomFactor(1.0);
    }

    @Override
    public double restrictZoomFactor(double d) {
        if (d >= 1.0) {
            return ZOOM_FACTORS[(int)Math.min(d, 8.0)];
        }
        return 1.0 / (double)ZOOM_FACTORS[(int)Math.min(1.0 / d, 8.0)];
    }

    @Override
    public void pinZoomFactor() {
        this.pinnedZoomFactor = this.getZoomFactor();
    }

    @Override
    public void unpinZoomFactor() {
        this.pinnedZoomFactor = Double.NaN;
    }

    @Override
    public void applyRelativeZoomFactorChange(double d, ImageDef imageDef, IViewDimension iViewDimension) {
        double d2 = Double.isNaN(this.pinnedZoomFactor) ? this.getZoomFactor() : this.pinnedZoomFactor;
        this.setZoomFactor(d2 * d);
    }

    @Override
    protected void updateZoomFactor(ImageDef imageDef, int n, int n2) {
    }

    @Override
    protected final void setAbsoluteZoomFactor(double d) {
        this.zoomFactorX = d;
        this.zoomFactorY = d;
    }
}

