/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.fithandler;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.fithandler.ImageDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class SpacingDef {
    private double dataPixelSizeX = 0.0;
    private double dataPixelSizeY = 0.0;
    private boolean projectiveSpacing = false;
    private Unit sizeUnit = null;

    public String toString() {
        if (this.sizeUnit != null) {
            return this.sizeUnit.toString();
        }
        return "";
    }

    private static SpacingDef getImagerPixelSpacing(IImageInformation iImageInformation) {
        SpacingDef spacingDef = new SpacingDef();
        if (ImageDef.hasProjectiveSpacing(iImageInformation)) {
            spacingDef.setSizeUnit(Unit.mm);
            if (ImageDef.hasEstimation(iImageInformation)) {
                spacingDef.setSizeUnit(Unit.mm_est);
                double d = iImageInformation.getEstimatedRadiographicMagnificationFactor();
                if (d == 0.0) {
                    d = 1.0;
                }
                spacingDef.setDataPixelSizeX(iImageInformation.getImagerPixelSpacing()[1] / d);
                spacingDef.setDataPixelSizeY(iImageInformation.getImagerPixelSpacing()[0] / d);
            } else {
                spacingDef.setSizeUnit(Unit.mm_prj);
                double[] dArray = iImageInformation.getImagerPixelSpacing();
                if (dArray != null && dArray.length > 1) {
                    spacingDef.setDataPixelSizeX(dArray[1]);
                    spacingDef.setDataPixelSizeY(dArray[0]);
                }
            }
            return spacingDef;
        }
        if (ImageDef.hasImagePlanePixelSpacing(iImageInformation)) {
            double d = 1.0;
            spacingDef.setSizeUnit(Unit.mm_prj);
            spacingDef.setDataPixelSizeX(iImageInformation.getImagePlanePixelSpacing()[1] * d);
            spacingDef.setDataPixelSizeY(iImageInformation.getImagePlanePixelSpacing()[0] * d);
            return spacingDef;
        }
        return null;
    }

    private static boolean hasPixelSpacing(double[] dArray) {
        return dArray != null && dArray.length == 2 && dArray[0] != 0.0;
    }

    public static SpacingDef getDefaultSpacingDef(IImageInformation iImageInformation) {
        List<SpacingDef> list = SpacingDef.generateSpacingDefs(iImageInformation);
        return list.get(list.size() - 1);
    }

    public static List<SpacingDef> generateSpacingDefs(IImageInformation iImageInformation) {
        ArrayList<SpacingDef> arrayList = new ArrayList<SpacingDef>(3);
        SpacingDef spacingDef = new SpacingDef();
        spacingDef.setSizeUnit(Unit.pix);
        spacingDef.setDataPixelSizeX(1.0);
        spacingDef.setDataPixelSizeY(1.0);
        arrayList.add(spacingDef);
        double[] dArray = iImageInformation.getPixelSpacing();
        boolean bl = SpacingDef.hasPixelSpacing(dArray);
        boolean bl2 = ImageDef.hasProjectiveSpacing(iImageInformation);
        if (!bl) {
            SpacingDef spacingDef2 = SpacingDef.getImagerPixelSpacing(iImageInformation);
            if (spacingDef2 != null) {
                arrayList.add(spacingDef2);
            }
        } else {
            SpacingDef spacingDef3 = new SpacingDef();
            spacingDef3.setSizeUnit(Unit.mm);
            spacingDef3.setDataPixelSizeX(dArray[1]);
            spacingDef3.setDataPixelSizeY(dArray[0]);
            if (ImageDef.isProjectiveModality(iImageInformation)) {
                SpacingDef spacingDef4 = SpacingDef.getImagerPixelSpacing(iImageInformation);
                if (bl2 && spacingDef4 != null) {
                    if (Arrays.equals(iImageInformation.getPixelSpacing(), iImageInformation.getImagerPixelSpacing())) {
                        arrayList.add(spacingDef4);
                    } else if (spacingDef4.getSizeUnit() == Unit.mm_est) {
                        arrayList.add(spacingDef4);
                    } else {
                        spacingDef3.setSizeUnit(Unit.mm_aprox);
                        arrayList.add(spacingDef3);
                    }
                } else {
                    spacingDef3.setSizeUnit(Unit.mm_prj);
                    arrayList.add(spacingDef3);
                }
            } else if (iImageInformation.getImageClass() == IImageInformation.ImageClass.PDF) {
                spacingDef3.setSizeUnit(Unit.mm_pdf);
                arrayList.add(spacingDef3);
            } else {
                arrayList.add(spacingDef3);
            }
        }
        if (iImageInformation.getImageClass() == IImageInformation.ImageClass.OPT3D && !Config.impaxee.jvision.DISPLAY.Display3DOpthalmoImagesInMM.get()) {
            arrayList.remove(spacingDef);
            arrayList.add(spacingDef);
        }
        return arrayList;
    }

    public double getDataPixelSizeY() {
        return this.dataPixelSizeY;
    }

    public double getDataPixelSizeX() {
        return this.dataPixelSizeX;
    }

    public boolean isProjectiveSpacing() {
        return this.projectiveSpacing;
    }

    public void setProjectiveSpacing(boolean bl) {
        this.projectiveSpacing = bl;
    }

    public double getAspectRatio() {
        return this.dataPixelSizeX / this.dataPixelSizeY;
    }

    public Unit getSizeUnit() {
        return this.sizeUnit;
    }

    public void setSizeUnit(Unit unit) {
        this.sizeUnit = unit;
    }

    public void setDataPixelSizeX(double d) {
        this.dataPixelSizeX = d;
    }

    public void setDataPixelSizeY(double d) {
        this.dataPixelSizeY = d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpacingDef)) {
            return false;
        }
        SpacingDef spacingDef = (SpacingDef)object;
        return spacingDef.getDataPixelSizeX() == this.getDataPixelSizeX() && spacingDef.getDataPixelSizeY() == this.getDataPixelSizeY() && spacingDef.getSizeUnit() == this.getSizeUnit() && spacingDef.isProjectiveSpacing() == this.isProjectiveSpacing();
    }

    public boolean hasEqualSizing(SpacingDef spacingDef) {
        if (this.sizeUnit.isMM() != spacingDef.getSizeUnit().isMM()) {
            return false;
        }
        return DoubleEquals.equals((double)spacingDef.getDataPixelSizeX(), (double)this.getDataPixelSizeX()) && DoubleEquals.equals((double)spacingDef.getDataPixelSizeY(), (double)this.getDataPixelSizeY());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static enum Unit {
        mm,
        pix,
        vox(""),
        mm_aprox(Messages.getString("PIXELSIZE_APPROX")),
        mm_man(Messages.getString("PIXELSIZE_MANUAL_CALIBRATION")),
        mm_prj(Messages.getString("PIXELSIZE_PROJECTIVE_SPACING")),
        mm_est(String.valueOf(Messages.getString("PIXELSIZE_PROJECTIVE_SPACING")) + "/" + Messages.getString("PIXELSIZE_ESTIMATED")),
        mm_pres(Messages.getString("PIXELSIZE_PRESENTATION")),
        mm_pdf(Messages.getString("PIXELSIZE_PDF"));

        private String text;
        private String main;
        private String comment;

        private Unit(String string2) {
            if (string2.length() == 0) {
                this.text = "";
                this.main = "";
                this.comment = "";
            } else {
                this.text = "mm (" + string2 + ")";
                this.main = "mm";
                this.comment = string2;
            }
        }

        private Unit() {
            this.text = this.name();
            this.main = this.name();
            this.comment = null;
        }

        public boolean isMM() {
            return this != pix && this != vox;
        }

        public String toString() {
            return this.text;
        }

        public String mainPart() {
            return this.main;
        }

        public String commentPart() {
            return this.comment;
        }
    }
}

