/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.seriesselection;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.monitor.MonitorConfiguration;
import com.agfa.pacs.base.swing.util.ComponentUtil;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.OnlyOneStudyManager;
import com.agfa.pacs.listtext.swingx.util.ContextSensitiveHelpUtilities;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.seriesselection.MonitorOverviewPanel;
import com.tiani.jvision.image.seriesselection.StudyPanel;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;

public class FastSeriesSelectionPanel
extends JPanel {
    private static final ALogger LOGGER = ALogger.getLogger(FastSeriesSelectionPanel.class);
    private static final PActionIcon INFO_ICON = PActionIconFactory.getInstance().loadIcon(FastSeriesSelectionPanel.class, "Question.svg", null);
    private static final int MAX_DISPLAYSETS_PER_ROW = 8;
    private static final int MINIMAL_WIDTH = GUI.getScaledDiagnosticInt((int)400);
    private static final int VERTICAL_GAP = GUI.getScaledDiagnosticInt((int)5);
    private final OrderedMap<String, StudyPanel> studiesToPanels = new ListOrderedMap();
    private final MouseWheelHandler mouseWheelHandler = new MouseWheelHandler();
    private String currentStudyKey = null;
    private MonitorOverviewPanel monitorOverviewPanel;
    private Dimension preferredDimension;
    private final VisDisplay2 visDisplay;
    private PAction contextSensitiveHelpAction;

    private FastSeriesSelectionPanel(VisDisplay2 visDisplay2, IDisplaySet[] iDisplaySetArray, IDisplaySetSelectionListener iDisplaySetSelectionListener) {
        this.visDisplay = visDisplay2;
        this.init(visDisplay2.getScreen(), iDisplaySetArray, iDisplaySetSelectionListener);
        this.addMouseWheelListener(this.mouseWheelHandler);
        ContextSensitiveHelpUtilities.setRelevantHelpTopicId((JComponent)this, (ContextSensitiveHelpUtilities.HelpTopic)ContextSensitiveHelpUtilities.HelpTopic.FAST_SERIES_SELECTION);
    }

    public static void showAsPopup(final MouseEvent mouseEvent, final VisDisplay2 visDisplay2) {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                final JDialog jDialog = new JDialog(JVision2.getMainFrame());
                FastSeriesSelectionPanel fastSeriesSelectionPanel = new FastSeriesSelectionPanel(visDisplay2, DataSelectionManager.getInstance().getActiveHanging().getSplitAndSortRuntime().getDisplaySets(), new IDisplaySetSelectionListener(){

                    @Override
                    public void selectionChanged(IDisplaySet iDisplaySet) {
                        visDisplay2.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
                        jDialog.dispose();
                    }
                }, null);
                jDialog.addWindowFocusListener(new WindowAdapter(){

                    @Override
                    public void windowLostFocus(WindowEvent windowEvent) {
                        jDialog.dispose();
                    }
                });
                fastSeriesSelectionPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
                jDialog.setContentPane(fastSeriesSelectionPanel);
                int n = visDisplay2.getVisScreen().getSize().height / 2;
                Dimension dimension = fastSeriesSelectionPanel.getPreferredDimension();
                double d = fastSeriesSelectionPanel.monitorOverviewPanel.getPreferredSize().getHeight();
                dimension.height = (int)((double)dimension.height + d);
                n = (int)((double)n + d);
                jDialog.setPreferredSize(new Dimension(Math.max(dimension.width, (int)fastSeriesSelectionPanel.monitorOverviewPanel.getPreferredSize().getWidth() + INFO_ICON.getIcon(false).getIconWidth() * 2), Math.min(n, dimension.height)));
                jDialog.setDefaultCloseOperation(0);
                jDialog.setUndecorated(true);
                jDialog.pack();
                FastSeriesSelectionPanel.setDialogLocation(jDialog, mouseEvent);
                jDialog.setVisible(true);
                fastSeriesSelectionPanel.postShow();
            }
        });
    }

    private static void setDialogLocation(JDialog jDialog, MouseEvent mouseEvent) {
        Component component = ComponentUtil.getDeepComponentAt((Container)JVision2.getMainFrame(), (Point)new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen()));
        if (component != null) {
            double d;
            int n;
            Rectangle rectangle = MonitorConfiguration.getConfiguration().getBoundsOfScreenWithPoint(new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen()));
            Point point = component.getLocationOnScreen();
            int n2 = mouseEvent.getXOnScreen();
            double d2 = jDialog.getPreferredSize().getWidth();
            double d3 = (double)n2 + d2;
            LOGGER.debug("mouse location:       x: " + n2 + ",    y: " + mouseEvent.getYOnScreen());
            LOGGER.debug("component location:   x: " + point.x + ",    y: " + point.y);
            LOGGER.debug("window:               x: " + rectangle.x + ",    y: " + rectangle.y);
            if (d3 > (double)(point.x + component.getWidth())) {
                n = (int)(d3 - (double)(point.x + component.getWidth()));
                n2 -= n;
            }
            if (n2 < rectangle.x) {
                n2 = rectangle.x;
            }
            if ((d = (double)(n = mouseEvent.getYOnScreen()) + jDialog.getPreferredSize().getHeight()) > (double)(point.y + component.getHeight() + rectangle.y)) {
                int n3 = (int)(d - (double)(point.y + component.getHeight()));
                n -= n3;
            }
            if (n2 < rectangle.x) {
                n2 = rectangle.x;
            }
            if (n < rectangle.y) {
                n = rectangle.y;
            }
            jDialog.setLocation(n2, n);
        } else {
            jDialog.setLocationRelativeTo(null);
        }
    }

    private void init(VisScreen2 visScreen2, IDisplaySet[] iDisplaySetArray, IDisplaySetSelectionListener iDisplaySetSelectionListener) {
        JPanel jPanel;
        Object object;
        Object object2;
        Object object3;
        this.studiesToPanels.clear();
        ListOrderedMap listOrderedMap = new ListOrderedMap();
        int n = 1;
        Object object4 = iDisplaySetArray;
        int n2 = iDisplaySetArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IDisplaySet iDisplaySet = object4[n3];
            if (OnlyOneStudyManager.get().isAllowedOnScreen(visScreen2, iDisplaySet.getStudy())) {
                IStudyData object5 = iDisplaySet.getStudy();
                object3 = listOrderedMap.computeIfAbsent(object5, iStudyData -> new ArrayList());
                object3.add(iDisplaySet);
                if (object3.size() > n) {
                    n = object3.size();
                }
            }
            ++n3;
        }
        this.setLayout((LayoutManager)new RowLayout(VERTICAL_GAP));
        if (n > 8) {
            n = 8;
        }
        int n4 = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.SEQPANEL.FastSelectionTokenSize.get()));
        n3 = Math.max(n * n4, MINIMAL_WIDTH);
        JPanel jPanel2 = ComponentFactory.instance.createPanel();
        object4 = ComponentFactory.instance.createScrollPane(jPanel2, 20, 31, true, null);
        ((JScrollPane)object4).setWheelScrollingEnabled(false);
        ((JScrollPane)object4).getViewport().setOpaque(false);
        jPanel2.setLayout((LayoutManager)new RowLayout(VERTICAL_GAP));
        this.monitorOverviewPanel = new MonitorOverviewPanel();
        for (Map.Entry entry : listOrderedMap.entrySet()) {
            object2 = (IStudyData)entry.getKey();
            object = (List)entry.getValue();
            jPanel = new StudyPanel(Math.min(8, object.size()), (IStudyData)object2, (List<IDisplaySet>)object, n3, iDisplaySetSelectionListener, this);
            jPanel.addMouseWheelListener(this.mouseWheelHandler);
            this.studiesToPanels.put((Object)object2.getKey(), (Object)jPanel);
            jPanel2.add(jPanel);
            this.monitorOverviewPanel.addStudyPanel((StudyPanel)jPanel);
            ((StudyPanel)jPanel).setMonitorOverviewPanel(this.monitorOverviewPanel);
        }
        int n5 = this.visDisplay.getVisScreen().getSize().height / 2;
        object3 = this.getPreferredDimension();
        ((JComponent)object4).setPreferredSize(new Dimension(((Dimension)object3).width, Math.min(n5, ((Dimension)object3).height)));
        ((JScrollPane)object4).getViewport().add(jPanel2);
        object2 = ComponentFactory.instance.createPanel();
        ((Container)object2).setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        jPanel = new HelpPanel();
        ((GridBagConstraints)object).anchor = 11;
        ((Container)object2).add((Component)jPanel, object);
        ((GridBagConstraints)object).gridx = 1;
        this.contextSensitiveHelpAction = PActionRegistry.getActionNoException("CONTEXT_SENSITIVE_HELP");
        jPanel.setVisible(this.contextSensitiveHelpAction != null);
        ((GridBagConstraints)object).anchor = 10;
        ((Container)object2).add((Component)this.monitorOverviewPanel, object);
        this.add((Component)object2);
        this.add((Component)object4);
        IStudyData iStudyData2 = null;
        if (VisData.getLastModified() != null) {
            iStudyData2 = VisData.getLastModified().getStudyData();
        } else {
            IStudyContainer iStudyContainer;
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging != null && (iStudyContainer = iHanging.getStudyContainer()) != null) {
                iStudyData2 = iStudyContainer.getBaseStudy();
            }
        }
        if (!(iStudyData2 != null && listOrderedMap.containsKey(iStudyData2) || listOrderedMap.isEmpty())) {
            iStudyData2 = (IStudyData)listOrderedMap.keySet().iterator().next();
        }
        if (iStudyData2 != null) {
            this.setCurrentStudy(iStudyData2.getKey());
        }
    }

    private Dimension getPreferredDimension() {
        if (this.preferredDimension == null) {
            this.setPreferredDimension();
        }
        return this.preferredDimension;
    }

    private void setPreferredDimension() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (!this.studiesToPanels.isEmpty()) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = new Dimension(0, 0);
            for (StudyPanel studyPanel : this.studiesToPanels.values()) {
                Dimension dimension3 = studyPanel.getPreferredExpandedSize();
                Dimension dimension4 = studyPanel.getPreferredCollapsedSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height = Math.max(dimension.height, dimension3.height);
                dimension2.width = Math.max(dimension2.width, dimension4.width);
                dimension2.height = Math.max(dimension2.height, dimension4.height);
            }
            n += Math.max(dimension2.width, dimension.width);
            n += GUI.getScaledDiagnosticInt((int)20);
            n = Math.max(n, MINIMAL_WIDTH);
            n2 += this.studiesToPanels.size() - 1;
            n2 += VERTICAL_GAP;
            n2 += dimension.height;
            n2 += (dimension2.height + VERTICAL_GAP) * Math.min(this.studiesToPanels.size(), 10);
        }
        this.preferredDimension = new Dimension(n, n2);
    }

    private void postShow() {
        final StudyPanel studyPanel = (StudyPanel)this.studiesToPanels.get((Object)this.currentStudyKey);
        if (studyPanel != null) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    FastSeriesSelectionPanel.this.scrollRectToVisible(studyPanel.getBounds());
                }
            });
        }
    }

    void setCurrentStudy(String string) {
        if (!StringUtils.equals((CharSequence)string, (CharSequence)this.currentStudyKey)) {
            for (Object object : this.studiesToPanels.entrySet()) {
                if (StringUtils.equals((CharSequence)string, (CharSequence)((CharSequence)object.getKey()))) continue;
                ((StudyPanel)object.getValue()).collapse();
            }
            this.currentStudyKey = null;
            if (string != null) {
                Object object;
                this.currentStudyKey = string;
                object = (StudyPanel)this.studiesToPanels.get((Object)string);
                if (object != null) {
                    ((StudyPanel)object).expand();
                    this.scrollRectToVisible(((Component)object).getBounds());
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    private String getPreviousStudyKey() {
        return (String)this.studiesToPanels.previousKey((Object)this.currentStudyKey);
    }

    private String getNextStudyKey() {
        return (String)this.studiesToPanels.nextKey((Object)this.currentStudyKey);
    }

    /* synthetic */ FastSeriesSelectionPanel(VisDisplay2 visDisplay2, IDisplaySet[] iDisplaySetArray, IDisplaySetSelectionListener iDisplaySetSelectionListener, FastSeriesSelectionPanel fastSeriesSelectionPanel) {
        this(visDisplay2, iDisplaySetArray, iDisplaySetSelectionListener);
    }

    private class HelpPanel
    extends JPanel {
        private Icon icon = FastSeriesSelectionPanel.access$2().getIcon(true);
        private JLabel iconLabel = ComponentFactory.instance.createLabel(this.icon);

        public HelpPanel() {
            this.iconLabel.setToolTipText(Messages.getString("FastSeriesSelectionPanel.Info"));
            this.iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    FastSeriesSelectionPanel.this.contextSensitiveHelpAction.perform(HelpPanel.this);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    HelpPanel.this.changeIcon(false);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    HelpPanel.this.changeIcon(true);
                }
            });
            this.add(this.iconLabel);
            this.setOpaque(false);
        }

        private void changeIcon(boolean bl) {
            this.icon = bl ? INFO_ICON.getIcon(true) : INFO_ICON.getPopupIcon(true);
            this.iconLabel.removeAll();
            this.iconLabel.setIcon(this.icon);
            this.revalidate();
        }
    }

    public static interface IDisplaySetSelectionListener {
        public void selectionChanged(IDisplaySet var1);
    }

    private class MouseWheelHandler
    extends MouseAdapter {
        private MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            try {
                if (mouseWheelEvent.getScrollType() == 0 && Math.abs(mouseWheelEvent.getWheelRotation()) != 0) {
                    String string;
                    String string2 = string = mouseWheelEvent.getWheelRotation() < 0 ? FastSeriesSelectionPanel.this.getPreviousStudyKey() : FastSeriesSelectionPanel.this.getNextStudyKey();
                    if (string != null) {
                        FastSeriesSelectionPanel.this.setCurrentStudy(string);
                    }
                }
                mouseWheelEvent.consume();
            }
            catch (Exception exception) {
                ALogger.getLogger(FastSeriesSelectionPanel.class).error(null, (Throwable)exception);
            }
        }
    }
}

