/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.seriesselection;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.VariableLayout;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.image.seriesselection.StudyPanel;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.LytScreen;
import com.tiani.jvision.vis.layout.StateLytScreen;
import info.clearthought.layout.TableLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class MonitorOverviewPanel
extends JPanel {
    static final Color HIGHLIGHT_COLOR = GuiUtil.isOnColorMonitor() ? new Color(70, 118, 170) : new Color(120, 120, 120);
    static final Color BRIGHT_HIGHLIGHT_COLOR = GuiUtil.isOnColorMonitor() ? new Color(104, 151, 201) : new Color(145, 145, 145);
    private static final Color OCCUPIED_COLOR = GuiUtil.isOnColorMonitor() ? new Color(89, 94, 103) : new Color(90, 90, 90);
    private static final ALogger LOGGER = ALogger.getLogger(MonitorOverviewPanel.class);
    private final int PANEL_WIDTH = ComponentFactory.instance.scaleInt(120);
    private final int PANEL_HEIGHT = ComponentFactory.instance.scaleInt(80);
    private static final VariableLayout[] LAYOUTS = new VariableLayout[]{VariableLayout.LAYOUT_1x1, VariableLayout.LAYOUT_2x2, VariableLayout.LAYOUT_1x2, VariableLayout.LAYOUT_2x1};
    private Map<VisScreen2, MonitorPanelMouseWheelListener> listeners = new HashMap<VisScreen2, MonitorPanelMouseWheelListener>();
    private int displayNumber = 1;
    private List<StudyPanel> studyPanels = new ArrayList<StudyPanel>();
    private Color defaultPanelColor;
    private Map<Integer, NumberPanel> numberPanels = new HashMap<Integer, NumberPanel>();

    public MonitorOverviewPanel() {
        this.defaultPanelColor = this.getBackground();
        this.initMonitorThumbnails();
    }

    static String getMonitorLetter(int n) {
        return String.valueOf((char)(65 + n));
    }

    void addStudyPanel(StudyPanel studyPanel) {
        this.studyPanels.add(studyPanel);
    }

    void highlightDisplayPanel(int n, boolean bl) {
        NumberPanel numberPanel;
        if (this.numberPanels != null && !this.numberPanels.isEmpty() && (numberPanel = this.numberPanels.get(n)) != null) {
            numberPanel.setPaintPattern(!bl);
            numberPanel.setBackground(bl ? HIGHLIGHT_COLOR : this.defaultPanelColor);
        }
    }

    private void initMonitorThumbnails() {
        this.removeAll();
        this.displayNumber = 1;
        TableLayout tableLayout = new TableLayout();
        tableLayout.insertRow(0, -2.0);
        tableLayout.setHGap(15);
        this.setLayout((LayoutManager)tableLayout);
        int n = ComponentFactory.instance.scaleInt(8);
        this.setBorder(BorderFactory.createEmptyBorder(n > 0 ? n : 8, 0, 0, 0));
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        LOGGER.debug("Number of monitor thumbnails to create: " + list.size());
        int n2 = 0;
        while (n2 < list.size()) {
            tableLayout.insertColumn(n2, -2.0);
            VisScreen2 visScreen2 = list.get(n2);
            LytScreen lytScreen = visScreen2.getLyt();
            int n3 = lytScreen.getRows();
            int n4 = lytScreen.getCols();
            Map<Point, Dimension> map = lytScreen.getMergedCells();
            JPanel jPanel = this.createMonitorPanel(n3, n4, map, n2, visScreen2);
            this.add((Component)jPanel, String.valueOf(n2) + "," + 0);
            ++n2;
        }
        this.revalidate();
    }

    private JPanel createMonitorPanel(int n, int n2, Map<Point, Dimension> map, int n3, VisScreen2 visScreen2) {
        JPanel jPanel = ComponentFactory.instance.createPanel();
        DisplaysPanel displaysPanel = new DisplaysPanel(n, n2, map, n3, visScreen2);
        MonitorStandPanel monitorStandPanel = new MonitorStandPanel(n3, displaysPanel.getPreferredSize().getWidth());
        Dimension dimension = new Dimension(this.PANEL_WIDTH, (int)(displaysPanel.getPreferredSize().getHeight() + monitorStandPanel.getPreferredSize().getHeight() + (double)ComponentFactory.instance.scaleInt(15)));
        jPanel.setPreferredSize(dimension);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0}, new double[]{-2.0, -2.0});
        tableLayout.setVGap(ComponentFactory.instance.scaleInt(4));
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)displaysPanel, "0,0");
        jPanel.add((Component)monitorStandPanel, "0,1");
        LOGGER.debug("Created monitor panel (w: " + dimension.getWidth() + ", h: " + dimension.getHeight() + ", visible: " + jPanel.isVisible() + ")");
        return jPanel;
    }

    private void repaintStudyPanels() {
        for (JComponent jComponent : this.studyPanels) {
            jComponent.invalidate();
            jComponent.repaint();
        }
    }

    private class DisplaysPanel
    extends JPanel {
        private VisScreen2 screen;

        public DisplaysPanel(int n, int n2, Map<Point, Dimension> map, int n3, VisScreen2 visScreen2) {
            Object object;
            this.screen = visScreen2;
            this.setPreferredSize(new Dimension(MonitorOverviewPanel.this.PANEL_WIDTH, MonitorOverviewPanel.this.PANEL_HEIGHT));
            this.setBorder(BorderFactory.createLineBorder(Color.white, ComponentFactory.instance.scaleInt(2)));
            TableLayout tableLayout = new TableLayout();
            int n4 = 0;
            while (n4 < n) {
                tableLayout.insertRow(n4, -1.0);
                ++n4;
            }
            n4 = 0;
            while (n4 < n2) {
                tableLayout.insertColumn(n4, -1.0);
                ++n4;
            }
            this.setLayout((LayoutManager)tableLayout);
            ArrayList<Point> arrayList = new ArrayList<Point>();
            if (map != null && !map.isEmpty()) {
                for (Map.Entry<Point, Dimension> entry : map.entrySet()) {
                    Point point = entry.getKey();
                    object = entry.getValue();
                    int n5 = 0;
                    while ((double)n5 < ((Dimension)object).getWidth()) {
                        int n6 = 0;
                        while ((double)n6 < ((Dimension)object).getHeight()) {
                            arrayList.add(new Point((int)(point.getX() + (double)n5), (int)(point.getY() + (double)n6)));
                            ++n6;
                        }
                        ++n5;
                    }
                }
            }
            int n7 = 1;
            boolean bl = n < 6 && n2 < 6;
            int n8 = 0;
            while (n8 < n) {
                int n9 = 0;
                while (n9 < n2) {
                    String string;
                    Point point = new Point(n9, n8);
                    if (arrayList.contains(point)) {
                        if (map != null && map.containsKey(point)) {
                            string = String.valueOf(n9) + "," + n8 + "," + (n9 + (int)map.get(point).getWidth() - 1) + "," + (n8 + (int)(map.get(point).getHeight() - 1.0));
                            n7 = this.createNumberPanel(n7, n3, bl, this, string, visScreen2.getVisDisplays().get(n7 - 1).hasData());
                        }
                    } else {
                        string = String.valueOf(n9) + "," + n8;
                        n7 = this.createNumberPanel(n7, n3, bl, this, string, visScreen2.getVisDisplays().get(n7 - 1).hasData());
                    }
                    ++n9;
                }
                ++n8;
            }
            if (MonitorOverviewPanel.this.listeners.size() < JVision2.getMainFrame().getScreens().size()) {
                StateLytScreen stateLytScreen = new StateLytScreen(visScreen2.getLyt());
                object = visScreen2.getLytMode();
                boolean bl2 = false;
                int n10 = 0;
                int n11 = 0;
                while (n11 < LAYOUTS.length) {
                    if (StateLytScreen.isEquivalent(stateLytScreen, LAYOUTS[n11])) {
                        bl2 = true;
                        n10 = n11;
                        break;
                    }
                    ++n11;
                }
                MonitorPanelMouseWheelListener monitorPanelMouseWheelListener = new MonitorPanelMouseWheelListener(this, stateLytScreen, (MainLayoutType)((Object)object), bl2, n10);
                MonitorOverviewPanel.this.listeners.put(visScreen2, monitorPanelMouseWheelListener);
            }
            this.addMouseWheelListener((MouseWheelListener)MonitorOverviewPanel.this.listeners.get(visScreen2));
        }

        private int createNumberPanel(int n, int n2, boolean bl, JPanel jPanel, String string, boolean bl2) {
            NumberPanel numberPanel = new NumberPanel(n, n2, bl, bl2);
            MonitorOverviewPanel.this.numberPanels.put(numberPanel.getNumber(), numberPanel);
            jPanel.add((Component)numberPanel, string);
            MonitorOverviewPanel monitorOverviewPanel = MonitorOverviewPanel.this;
            monitorOverviewPanel.displayNumber = monitorOverviewPanel.displayNumber + 1;
            return ++n;
        }

        VisScreen2 getScreen() {
            return this.screen;
        }
    }

    private class MonitorPanelMouseWheelListener
    implements MouseWheelListener {
        private DisplaysPanel monitorDisplaysPanel;
        private IStateLytScreen lytScreen;
        private MainLayoutType lytMode;
        private boolean isVariableLayoutType;
        private int rotation;

        public MonitorPanelMouseWheelListener(DisplaysPanel displaysPanel, IStateLytScreen iStateLytScreen, MainLayoutType mainLayoutType, boolean bl, int n) {
            this.monitorDisplaysPanel = displaysPanel;
            this.lytScreen = iStateLytScreen;
            this.lytMode = mainLayoutType;
            this.isVariableLayoutType = bl;
            this.rotation = n;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.rotation += mouseWheelEvent.getWheelRotation();
            VisScreen2 visScreen2 = this.monitorDisplaysPanel.getScreen();
            if (this.isVariableLayoutType) {
                this.rotation %= LAYOUTS.length;
                if (this.rotation >= 0) {
                    visScreen2.setLytMode(MainLayoutType.variable, LAYOUTS[this.rotation], true);
                } else {
                    visScreen2.setLytMode(MainLayoutType.variable, LAYOUTS[LAYOUTS.length - Math.abs(this.rotation)], true);
                }
            } else {
                this.rotation %= LAYOUTS.length + 1;
                if (this.rotation > 0) {
                    visScreen2.setLytMode(MainLayoutType.variable, LAYOUTS[this.rotation - 1], true);
                } else if (this.rotation == 0) {
                    visScreen2.setLytMode(this.lytMode, this.lytScreen, true);
                } else {
                    visScreen2.setLytMode(MainLayoutType.variable, LAYOUTS[LAYOUTS.length - Math.abs(this.rotation)], true);
                }
            }
            MonitorOverviewPanel.this.initMonitorThumbnails();
            for (StudyPanel studyPanel : MonitorOverviewPanel.this.studyPanels) {
                studyPanel.removeSeriesThumbnailHighlighting();
            }
            MonitorOverviewPanel.this.repaintStudyPanels();
        }
    }

    private class MonitorStandPanel
    extends JPanel {
        private int counter;
        private int displaysPanelWidth;
        private int panelHeight;
        private final Color MONITOR_STAND_COLOR = GuiUtil.isOnColorMonitor() ? new Color(127, 134, 147) : new Color(160, 160, 160);

        public MonitorStandPanel(int n, double d) {
            int n2;
            this.counter = n;
            this.displaysPanelWidth = (int)d;
            Font font = ComponentFactory.instance.getScaledFont(this.getFont());
            Font font2 = font.deriveFont(1);
            this.setFont(font2);
            this.panelHeight = n2 = font.getSize();
            this.setPreferredSize(new Dimension(MonitorOverviewPanel.this.PANEL_WIDTH, this.panelHeight));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = (int)((double)this.displaysPanelWidth / 2.6);
            int n2 = super.getGraphics().getFontMetrics().stringWidth(MonitorOverviewPanel.getMonitorLetter(this.counter));
            if (n < n2) {
                n = n2 + ComponentFactory.instance.scaleInt(10);
            }
            int n3 = this.displaysPanelWidth / 2;
            int n4 = n3 - n / 2;
            int n5 = n3 + n / 2;
            graphics.setColor(this.MONITOR_STAND_COLOR);
            graphics.fillRect(n3 - n / 2, 0, n, this.panelHeight);
            graphics.setColor(Color.black);
            int n6 = n5 - n4;
            graphics.drawString(MonitorOverviewPanel.getMonitorLetter(this.counter), n4 + n6 / 2 - n2 / 2, this.panelHeight - ComponentFactory.instance.scaleInt(2));
        }
    }

    private class NumberPanel
    extends JPanel {
        private int number;
        private int displayNumberOnScreen;
        private int screenNumber;
        private Color originalColor;
        private boolean hasData;
        private boolean paintPattern = true;

        public NumberPanel(int n, int n2, boolean bl, boolean bl2) {
            this.displayNumberOnScreen = n;
            this.screenNumber = n2;
            this.hasData = bl2;
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.addMouseListener(new NumberPanelMouseHandler(this));
            this.setTransferHandler(new TargetTransferHandler());
            DropTarget dropTarget = this.getDropTarget();
            try {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                        NumberPanel.this.originalColor = NumberPanel.this.getBackground();
                    }

                    @Override
                    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                        NumberPanel.this.paintPattern = false;
                        NumberPanel.this.setBackground(BRIGHT_HIGHLIGHT_COLOR);
                    }

                    @Override
                    public void dragExit(DropTargetEvent dropTargetEvent) {
                        if (NumberPanel.this.originalColor != HIGHLIGHT_COLOR) {
                            NumberPanel.this.paintPattern = true;
                        }
                        NumberPanel.this.setBackground(NumberPanel.this.originalColor);
                    }

                    @Override
                    public void drop(DropTargetDropEvent dropTargetDropEvent) {
                        NumberPanel.this.paintPattern = true;
                        NumberPanel.this.hasData = true;
                        NumberPanel.this.setBackground(NumberPanel.this.originalColor);
                    }
                });
            }
            catch (TooManyListenersException tooManyListenersException) {
                LOGGER.error("Error on adding DropTargetListener", (Throwable)tooManyListenersException);
            }
            if (bl) {
                JLabel jLabel = ComponentFactory.instance.createLabel(String.valueOf(MonitorOverviewPanel.this.displayNumber));
                this.add(jLabel);
            }
            this.number = MonitorOverviewPanel.this.displayNumber;
        }

        void setPaintPattern(boolean bl) {
            this.paintPattern = bl;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.hasData && this.paintPattern) {
                Color color = graphics.getColor();
                graphics2D.setColor(OCCUPIED_COLOR);
                int n = this.getWidth() < this.getHeight() ? this.getHeight() * 2 : this.getWidth() * 2;
                int n2 = 0;
                while (n2 < n) {
                    graphics2D.setStroke(new BasicStroke(3.0f));
                    graphics2D.drawLine(0, n2, n2, 0);
                    n2 += 8;
                }
                graphics2D.setColor(color);
            }
        }

        public int getDisplayNumberOnScreen() {
            return this.displayNumberOnScreen;
        }

        public int getScreenNumber() {
            return this.screenNumber;
        }

        public int getNumber() {
            return this.number;
        }
    }

    private class NumberPanelMouseHandler
    extends MouseAdapter {
        private NumberPanel numberPanel;

        public NumberPanelMouseHandler(NumberPanel numberPanel) {
            this.numberPanel = numberPanel;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.highlight(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.highlight(false);
        }

        private void highlight(boolean bl) {
            VisScreen2 visScreen2;
            List<VisDisplay2> list;
            int n = this.numberPanel.getScreenNumber();
            int n2 = this.numberPanel.getDisplayNumberOnScreen() - 1;
            List<VisScreen2> list2 = JVision2.getMainFrame().getScreens();
            if (n <= list2.size() && (list = (visScreen2 = list2.get(n)).getDisplays()).size() > n2) {
                VisDisplay2 visDisplay2 = list.get(n2);
                for (StudyPanel studyPanel : MonitorOverviewPanel.this.studyPanels) {
                    studyPanel.highlightSeriesThumbnail(visDisplay2.getData().getDisplaySet(), bl);
                }
            }
        }
    }

    private class TargetTransferHandler
    extends TransferHandler {
        private TargetTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (transferSupport.isDrop()) {
                return transferSupport.isDataFlavorSupported(StudyPanel.DISPLAY_SET_DATA_FLAVOR);
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            boolean bl = false;
            if (this.canImport(transferSupport)) {
                try {
                    Object object = transferSupport.getTransferable().getTransferData(StudyPanel.DISPLAY_SET_DATA_FLAVOR);
                    Component component = transferSupport.getComponent();
                    if (object instanceof IDisplaySet && component instanceof NumberPanel) {
                        List<VisScreen2> list;
                        NumberPanel numberPanel = (NumberPanel)component;
                        int n = numberPanel.getDisplayNumberOnScreen() - 1;
                        int n2 = numberPanel.getScreenNumber();
                        if (n2 <= (list = JVision2.getMainFrame().getScreens()).size()) {
                            VisScreen2 visScreen2 = list.get(n2);
                            List<VisDisplay2> list2 = visScreen2.getDisplays();
                            list2.get(n).initVisDisplay((IDisplaySet)object, null, true, ActivationMode.MANUAL);
                            MonitorOverviewPanel.this.repaintStudyPanels();
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error on getting transfer data", (Throwable)exception);
                }
            }
            return bl;
        }
    }
}

