/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.image.seriesselection;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.DisplaySetLabelUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.swingx.controls.ArrowIcon;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.seriesselection.FastSeriesSelectionPanel;
import com.tiani.jvision.image.seriesselection.MonitorOverviewPanel;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.demographics.PriorStudyColoring;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabelGroup;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class StudyPanel
extends JPanel {
    private static final String SEPARATOR = " | ";
    private static final String ETC = " ...";
    static final DataFlavor DISPLAY_SET_DATA_FLAVOR = new DataFlavor(IDisplaySet.class, "DisplaySet");
    private JLabel titleLabel;
    private JComponent indicator;
    private JPanel displaySetsPanel;
    private TableLayout displaySetsLayout;
    private int currentColumnIndex = 0;
    private int maxColumnIndex;
    private int currentRowIndex = 0;
    private Icon expandedIcon = null;
    private Icon collapsedIcon = null;
    private Color collapsedBackground = null;
    private Color expandedBackground = null;
    private Dimension prefCollapsedSize = null;
    private Dimension prefExpandedSize = null;
    private MonitorOverviewPanel monitorOverviewPanel;
    private FastSeriesSelectionPanel.IDisplaySetSelectionListener displaySetSelectionListener;
    private Map<JComponent, IDisplaySet> componentMap;

    public StudyPanel(int n, final IStudyData iStudyData, List<IDisplaySet> list, int n2, FastSeriesSelectionPanel.IDisplaySetSelectionListener iDisplaySetSelectionListener, final FastSeriesSelectionPanel fastSeriesSelectionPanel) {
        this.displaySetSelectionListener = iDisplaySetSelectionListener;
        this.componentMap = new HashMap<JComponent, IDisplaySet>();
        this.displaySetsLayout = new TableLayout();
        this.displaySetsPanel = ComponentFactory.instance.createPanel((LayoutManager)this.displaySetsLayout);
        this.maxColumnIndex = n - 1;
        int n3 = 0;
        while (n3 < n) {
            this.displaySetsLayout.insertColumn(n3, -2.0);
            ++n3;
        }
        this.displaySetsLayout.insertRow(0, -2.0);
        this.displaySetsLayout.setVGap(2);
        this.displaySetsLayout.setHGap(2);
        for (IDisplaySet iDisplaySet : list) {
            this.appendDisplaySet(iDisplaySet);
        }
        Color color = this.getPriorColor(iStudyData);
        String string = DisplaySetLabelGroup.getStudyDigest(iStudyData);
        String string2 = iStudyData.getDicomObject().getString(528432);
        this.titleLabel = ComponentFactory.instance.createLabel("");
        String string3 = this.getTitleLabelText(string, string2, n2);
        this.titleLabel.setText(string3);
        if (!string3.equals(string)) {
            this.titleLabel.setToolTipText(String.valueOf(string) + SEPARATOR + string2);
        }
        this.titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() <= 1) {
                    fastSeriesSelectionPanel.setCurrentStudy(iStudyData.getKey());
                }
            }
        });
        this.titleLabel.setCursor(Cursor.getPredefinedCursor(12));
        if (color != null) {
            this.titleLabel.setForeground(color);
        }
        this.expandedBackground = ColorUtils.blend((Color)ColorUtils.getPrimary1(), (Color)this.getBackground(), (float)0.5f);
        this.collapsedBackground = this.getBackground();
        this.expandedIcon = ArrowIcon.getDownArrowIcon((Color)this.titleLabel.getForeground(), (int)GUI.getScaledDiagnosticInt((int)10), (int)GUI.getScaledDiagnosticInt((int)5));
        this.collapsedIcon = ArrowIcon.getRightArrowIcon((Color)this.titleLabel.getForeground(), (int)GUI.getScaledDiagnosticInt((int)6), (int)GUI.getScaledDiagnosticInt((int)12));
        this.titleLabel.setIcon(this.expandedIcon);
        this.setBackground(this.expandedBackground);
        this.indicator = (JComponent)Box.createHorizontalStrut(GUI.getScaledDiagnosticInt((int)5));
        this.indicator.setOpaque(true);
        this.indicator.setBackground(this.titleLabel.getForeground());
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)new RowLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, GUI.getScaledDiagnosticInt((int)5), 0, GUI.getScaledDiagnosticInt((int)10)));
        jPanel.add(this.titleLabel);
        jPanel.add(this.displaySetsPanel);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.indicator);
        this.add(jPanel);
        this.add(Box.createHorizontalGlue());
        this.prefExpandedSize = this.getPreferredSize();
        this.prefCollapsedSize = this.titleLabel.getPreferredSize();
        this.prefCollapsedSize.width += this.getInsets().left + this.getInsets().right + this.indicator.getPreferredSize().width;
        this.prefCollapsedSize.height += this.getInsets().top + this.getInsets().bottom;
    }

    void setMonitorOverviewPanel(MonitorOverviewPanel monitorOverviewPanel) {
        this.monitorOverviewPanel = monitorOverviewPanel;
    }

    private String getTitleLabelText(String string, String string2, int n) {
        this.titleLabel.setText(string);
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        Font font = this.titleLabel.getFont();
        if (string2 != null) {
            int n2 = (int)font.getStringBounds(String.valueOf(string) + SEPARATOR, fontRenderContext).getWidth();
            if (n2 > n) {
                string = String.valueOf(string) + ETC;
            } else {
                String string3 = SEPARATOR + string2;
                int n3 = (int)font.getStringBounds(string3, fontRenderContext).getWidth();
                int n4 = (int)font.getStringBounds(ETC, fontRenderContext).getWidth();
                double d = n - n2 - n4;
                if (d < (double)n3) {
                    int n5 = SEPARATOR.length();
                    while (n5 < string3.length()) {
                        String string4 = string3.substring(0, n5);
                        int n6 = (int)font.getStringBounds(string4, fontRenderContext).getWidth();
                        if ((double)n6 >= d) {
                            string = String.valueOf(string) + (string4.equals(SEPARATOR) ? ETC : String.valueOf(string4) + ETC);
                            break;
                        }
                        ++n5;
                    }
                } else {
                    string = String.valueOf(string) + string3;
                }
            }
        }
        return string;
    }

    public void collapse() {
        this.displaySetsPanel.setVisible(false);
        this.indicator.setVisible(false);
        this.titleLabel.setIcon(this.collapsedIcon);
        this.setBackground(this.collapsedBackground);
    }

    public void expand() {
        this.displaySetsPanel.setVisible(true);
        this.indicator.setVisible(true);
        this.titleLabel.setIcon(this.expandedIcon);
        this.setBackground(this.expandedBackground);
    }

    public Dimension getPreferredCollapsedSize() {
        return this.prefCollapsedSize;
    }

    public Dimension getPreferredExpandedSize() {
        return this.prefExpandedSize;
    }

    public void highlightSeriesThumbnail(IDisplaySet iDisplaySet, boolean bl) {
        for (Map.Entry<JComponent, IDisplaySet> entry : this.componentMap.entrySet()) {
            if (entry.getValue() != iDisplaySet) continue;
            JComponent jComponent = entry.getKey();
            if (bl) {
                jComponent.setBorder(BorderFactory.createLineBorder(ColorUtils.brighter((Color)MonitorOverviewPanel.BRIGHT_HIGHLIGHT_COLOR, (float)0.9f), GUI.getScaledDiagnosticInt((int)2)));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder());
            }
            return;
        }
    }

    public void removeSeriesThumbnailHighlighting() {
        for (Map.Entry<JComponent, IDisplaySet> entry : this.componentMap.entrySet()) {
            entry.getKey().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void appendDisplaySet(IDisplaySet iDisplaySet) {
        if (this.currentColumnIndex > this.maxColumnIndex) {
            this.currentColumnIndex = 0;
            ++this.currentRowIndex;
            this.displaySetsLayout.insertRow(this.currentRowIndex, -2.0);
        }
        int n = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.SEQPANEL.FastSelectionTokenSize.get()));
        JComponent jComponent = DisplaySetLabelUtils.getIcon(iDisplaySet, n, () -> this.getDescription(iDisplaySet), DisplaySetLabelUtils.DisplaySetIconFlag.FRAME_COUNT_SHOWN);
        jComponent.setTransferHandler(new SourceTransferHandler(iDisplaySet));
        String string = DisplaySetLabelUtils.getLabel(iDisplaySet);
        jComponent.setToolTipText(string);
        MouseEventsHandler mouseEventsHandler = new MouseEventsHandler(jComponent, iDisplaySet);
        jComponent.addMouseListener(mouseEventsHandler);
        jComponent.addMouseMotionListener(mouseEventsHandler);
        this.componentMap.put(jComponent, iDisplaySet);
        JPanel jPanel = ComponentFactory.instance.createPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setLayout((LayoutManager)new RowLayout(0));
        jPanel.setBackground(Color.BLACK);
        int n2 = (int)Config.impaxee.jvision.SEQPANEL.FastSelectionDescriptionLines.get();
        if (n2 > 0) {
            String string2 = iDisplaySet.getOneObject().getDicomObject().getString(528446);
            if (string2 == null) {
                string2 = "";
            }
            JLabel jLabel = ComponentFactory.instance.createLabel("<html>" + string2 + "</html>");
            jLabel.setVerticalAlignment(1);
            jLabel.setToolTipText(string);
            jLabel.setBorder(BorderFactory.createEmptyBorder());
            jLabel.setBackground(Color.BLACK);
            jLabel.setForeground(OverlayConfig.mappingColor);
            Color color = this.getPriorColor(iDisplaySet.getStudy());
            if (color != null) {
                jLabel.setForeground(color);
            }
            int n3 = n2 * jLabel.getFontMetrics(jLabel.getFont()).getHeight();
            jLabel.setPreferredSize(new Dimension(n, n3));
            jPanel.setPreferredSize(new Dimension(n, n + n3));
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        this.displaySetsPanel.add((Component)jPanel, String.valueOf(this.currentColumnIndex) + "," + this.currentRowIndex);
        ++this.currentColumnIndex;
    }

    private String getDescription(IDisplaySet iDisplaySet) {
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        int n = 1;
        String string = "";
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            List<VisDisplay2> list2 = list.get(n3).getDisplays();
            int n4 = 0;
            while (n4 < list2.size()) {
                if (iDisplaySet == list2.get(n4).getData().getDisplaySet()) {
                    if (n2 > 1) {
                        string = String.valueOf(string) + "...";
                        return string;
                    }
                    string = String.valueOf(string) + MonitorOverviewPanel.getMonitorLetter(n3) + Integer.toString(n) + ", ";
                    ++n2;
                }
                ++n;
                ++n4;
            }
            ++n3;
        }
        if (!string.isEmpty()) {
            string = string.substring(0, string.lastIndexOf(44));
        }
        return string;
    }

    private Color getPriorColor(IStudyData iStudyData) {
        if (PriorStudyColoring.useDifferentColorsForPriors && GuiUtil.isOnColorMonitor()) {
            StudyType studyType = StudyType.UNKNOWN;
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging != null && iHanging.getStudyContainer() != null) {
                studyType = iHanging.getStudyContainer().getStudyType(iStudyData.getKey());
            }
            if (studyType != null && !studyType.equals((Object)StudyType.UNKNOWN)) {
                switch (studyType) {
                    case BASE_STUDY: 
                    case UNKNOWN: {
                        return null;
                    }
                    case FIRST_PRIOR: {
                        return PriorStudyColoring.mappingColorPrior1;
                    }
                    case MERGED: {
                        return PriorStudyColoring.mappingColorMergedStudies;
                    }
                }
                return PriorStudyColoring.mappingColorPriorX;
            }
        }
        return null;
    }

    private static class DisplaySetTransferable
    implements Transferable {
        private IDisplaySet displaySet;

        public DisplaySetTransferable(IDisplaySet iDisplaySet) {
            this.displaySet = iDisplaySet;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DISPLAY_SET_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor != null) {
                return dataFlavor.equals(DISPLAY_SET_DATA_FLAVOR);
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor != null && dataFlavor.equals(DISPLAY_SET_DATA_FLAVOR)) {
                return this.displaySet;
            }
            return null;
        }
    }

    private class MouseEventsHandler
    extends MouseAdapter {
        private JComponent component;
        private IDisplaySet displaySet;
        private boolean mouseDragged = false;

        public MouseEventsHandler(JComponent jComponent, IDisplaySet iDisplaySet) {
            this.component = jComponent;
            this.displaySet = iDisplaySet;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.component.setBorder(BorderFactory.createLineBorder(ColorUtils.brighter((Color)MonitorOverviewPanel.HIGHLIGHT_COLOR, (float)0.8f), GUI.getScaledDiagnosticInt((int)2)));
            this.handleDisplayPanelHighlighting(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.component.setBorder(BorderFactory.createEmptyBorder());
            this.handleDisplayPanelHighlighting(false);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.mouseDragged) {
                this.mouseDragged = false;
            } else {
                this.fireDisplaySetSelected(this.displaySet);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TransferHandler transferHandler = this.component.getTransferHandler();
            if (transferHandler != null) {
                transferHandler.exportAsDrag(this.component, mouseEvent, 1);
                this.mouseDragged = true;
            }
        }

        private void fireDisplaySetSelected(IDisplaySet iDisplaySet) {
            if (StudyPanel.this.displaySetSelectionListener != null) {
                StudyPanel.this.displaySetSelectionListener.selectionChanged(iDisplaySet);
            }
        }

        private void handleDisplayPanelHighlighting(boolean bl) {
            if (StudyPanel.this.monitorOverviewPanel != null) {
                List<VisScreen2> list = JVision2.getMainFrame().getScreens();
                int n = 1;
                int n2 = 0;
                while (n2 < list.size()) {
                    List<VisDisplay2> list2 = list.get(n2).getDisplays();
                    int n3 = 0;
                    while (n3 < list2.size()) {
                        if (list2.get(n3).getData().getDisplaySet() == this.displaySet) {
                            StudyPanel.this.monitorOverviewPanel.highlightDisplayPanel(n, bl);
                        }
                        ++n;
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
    }

    private static class SourceTransferHandler
    extends TransferHandler {
        private IDisplaySet displaySet;

        public SourceTransferHandler(IDisplaySet iDisplaySet) {
            this.displaySet = iDisplaySet;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            return new DisplaySetTransferable(this.displaySet);
        }

        @Override
        public void exportDone(JComponent jComponent, Transferable transferable, int n) {
        }
    }
}

