/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.info;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.pacs.math.Matrix2d;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.IWindowSettings;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.AbstractImageState;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.util.TicketOffice;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ImageState
extends AbstractImageState
implements IMutableImageState {
    private static final ImageState DEFAULT_IMAGE_STATE = new ImageState();
    private Matrix2d transform;
    private Rectangle validBounds;
    private Matrix2d i2s = new Matrix2d();
    private Matrix2d s2i = new Matrix2d();
    private double pixelSizeX;
    private double pixelSizeY;
    private List<SpacingDef> spacingDefs;
    private int currentSpacingDef;
    private WindowDef window;
    private IValueMapping currentValueMapping;
    private long updateStamp = 0L;

    public ImageState() {
        this.spacingDefs = Collections.emptyList();
    }

    public ImageState(List<SpacingDef> list) {
        this(list, null);
    }

    protected ImageState(List<SpacingDef> arrayList, Matrix2d matrix2d) {
        this.transform = matrix2d;
        this.spacingDefs = arrayList.isEmpty() ? arrayList : new ArrayList(arrayList);
    }

    public void setImageBounds(Rectangle rectangle) {
        this.validBounds = rectangle;
    }

    public Rectangle getImageBounds() {
        return this.validBounds;
    }

    public void setTransform(Matrix2d matrix2d) {
        this.transform = matrix2d;
    }

    @Override
    public Matrix2d getTransform() {
        return this.transform;
    }

    @Override
    public void updated() {
        this.updateStamp = TicketOffice.getNewStamp();
    }

    @Override
    public Matrix2d getImageToScreenTransform() {
        return this.i2s;
    }

    public Matrix2d getScreenToImageTransform() {
        return this.s2i;
    }

    @Override
    public void screenToImage(double[] dArray, double[] dArray2, Object object) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        this.s2i.transform(dArray2);
        dArray2[0] = dArray2[0] + this.visOrig[0];
        dArray2[1] = dArray2[1] + this.visOrig[1];
    }

    @Override
    public void imageToScreen(double[] dArray, double[] dArray2, Object object) {
        dArray2[0] = dArray[0] - this.visOrig[0];
        dArray2[1] = dArray[1] - this.visOrig[1];
        this.i2s.transform(dArray2);
    }

    @Override
    public void imageToScreen(float f, float f2, double[] dArray, Object object) {
        dArray[0] = (double)f - this.visOrig[0];
        dArray[1] = (double)f2 - this.visOrig[1];
        this.i2s.transform(dArray);
    }

    public boolean setVisOrientationAndOrigin(double d, double d2, double d3, double d4, boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = 1 - n;
        boolean bl2 = false;
        double[] dArray = new double[]{this.getColumVectorX(), this.getColumVectorY()};
        double[] dArray2 = new double[]{this.getRowVectorX(), this.getRowVectorY()};
        double d5 = dArray[0];
        double d6 = dArray[1];
        dArray[n] = d;
        dArray[n2] = 0.0;
        bl2 |= d5 != dArray[0];
        bl2 |= d6 != dArray[1];
        d5 = dArray2[0];
        d6 = dArray2[1];
        dArray2[n] = 0.0;
        dArray2[n2] = d2;
        bl2 |= d5 != dArray2[0];
        bl2 |= d6 != dArray2[1];
        d5 = this.visOrig[0];
        d6 = this.visOrig[1];
        this.setVisOriginAt(n, d3);
        this.setVisOriginAt(n2, d4);
        bl2 |= d5 != d3;
        boolean bl3 = d6 != d4;
        this.s2i.set(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        this.i2s.invert(this.s2i);
        return bl2 |= bl3;
    }

    public void setVisOrigin(double d, double d2) {
        this.setVisOriginAt(0, d);
        this.setVisOriginAt(1, d2);
    }

    private void setVisOriginAt(int n, double d) {
        this.visOrig[n] = d;
    }

    @Override
    public double getColumVectorX() {
        return this.s2i.m00;
    }

    @Override
    public double getColumVectorY() {
        return this.s2i.m10;
    }

    @Override
    public double getRowVectorX() {
        return this.s2i.m01;
    }

    @Override
    public double getRowVectorY() {
        return this.s2i.m11;
    }

    public static ImageState getDefaultImageState() {
        return DEFAULT_IMAGE_STATE;
    }

    @Override
    public void setToCommon(IMutableImageState iMutableImageState, IMutableImageState iMutableImageState2) {
        if (DoubleEquals.equals((double)iMutableImageState.getScreenPixelSizeX(), (double)iMutableImageState2.getScreenPixelSizeX(), (double)0.001) && DoubleEquals.equals((double)iMutableImageState.getScreenPixelSizeY(), (double)iMutableImageState2.getScreenPixelSizeY(), (double)0.001)) {
            this.setScreenPixelSize(iMutableImageState.getScreenPixelSizeX(), iMutableImageState.getScreenPixelSizeY());
            this.setVisOrigin(iMutableImageState.getVisOriginX(), iMutableImageState.getVisOriginY());
        } else {
            this.setScreenPixelSize(0.0, 0.0);
        }
        if (iMutableImageState.getCurrentSpacingDef().equals(iMutableImageState2.getCurrentSpacingDef())) {
            this.setCurrentSpacingDef(iMutableImageState.getCurrentSpacingDef());
        } else if (iMutableImageState.getCurrentSpacingDef().getSizeUnit() == iMutableImageState2.getCurrentSpacingDef().getSizeUnit()) {
            SpacingDef spacingDef = this.getCurrentSpacingDef();
            if (spacingDef != null) {
                spacingDef.setSizeUnit(iMutableImageState.getCurrentSpacingDef().getSizeUnit());
            }
        } else {
            this.setScreenPixelSize(0.0, 0.0);
        }
        if (this.transform == null) {
            this.transform = new Matrix2d();
        }
        this.transform.set(Matrix2d.trafoUnity);
        this.setTransform(this.transform);
        this.updated();
    }

    public void initSpacing(IImageInformation iImageInformation) {
        this.spacingDefs = SpacingDef.generateSpacingDefs(iImageInformation);
        this.currentSpacingDef = this.spacingDefs.size() - 1;
    }

    protected void removePixelSpacing() {
        SpacingDef spacingDef;
        Iterator<SpacingDef> iterator = this.spacingDefs.iterator();
        while (iterator.hasNext()) {
            spacingDef = iterator.next();
            if (spacingDef.getSizeUnit() != SpacingDef.Unit.pix) continue;
            iterator.remove();
        }
        if (this.spacingDefs.isEmpty()) {
            spacingDef = new SpacingDef();
            spacingDef.setSizeUnit(null);
            this.spacingDefs.add(spacingDef);
        }
        this.currentSpacingDef = this.spacingDefs.size() - 1;
    }

    @Override
    public SpacingDef getCurrentSpacingDef() {
        if (this.spacingDefs.isEmpty()) {
            return new SpacingDef();
        }
        SpacingDef spacingDef = null;
        try {
            spacingDef = this.spacingDefs.get(this.currentSpacingDef);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return spacingDef;
    }

    public void setCurrentSpacingDef(int n) {
        if (n < this.spacingDefs.size()) {
            this.currentSpacingDef = n;
        }
        this.updated();
    }

    public void setCurrentSpacingDef(SpacingDef spacingDef) {
        if (spacingDef != null) {
            this.spacingDefs.add(spacingDef);
            this.currentSpacingDef = this.spacingDefs.size() - 1;
        }
        int n = this.spacingDefs.size();
        int n2 = 0;
        while (n2 < n) {
            if (n2 != this.currentSpacingDef && this.getCurrentSpacingDef().toString().equals(this.spacingDefs.get(n2).toString())) {
                this.spacingDefs.remove(n2);
                if (n2 >= this.currentSpacingDef) break;
                --this.currentSpacingDef;
                break;
            }
            ++n2;
        }
        this.updated();
    }

    @Override
    public void selectCurrentSpacingDef(SpacingDef spacingDef) {
        int n = this.spacingDefs.indexOf(spacingDef);
        if (n >= 0) {
            spacingDef = this.spacingDefs.remove(n);
            this.spacingDefs.add(spacingDef);
            this.currentSpacingDef = this.spacingDefs.size() - 1;
        }
    }

    public void removeSpacingDef(SpacingDef spacingDef) {
        int n;
        if (spacingDef != null && (n = this.spacingDefs.indexOf(spacingDef)) > -1) {
            this.spacingDefs.remove(n);
            if (n <= this.currentSpacingDef) {
                --this.currentSpacingDef;
            }
        }
        this.updated();
    }

    public void removeSpacingDef(int n) {
        if (n > -1 && this.spacingDefs.size() > n) {
            this.spacingDefs.remove(n);
            if (n <= this.currentSpacingDef) {
                --this.currentSpacingDef;
            }
        }
        this.updated();
    }

    @Override
    public IValueMapping getCurrentValueMapping() {
        if (this.currentValueMapping != null) {
            return this.currentValueMapping;
        }
        return this.window;
    }

    @Override
    public void setCurrentValueMapping(IValueMapping iValueMapping) {
        this.currentValueMapping = iValueMapping;
        this.updated();
    }

    @Override
    public double getScreenPixelSizeX() {
        return this.pixelSizeX;
    }

    @Override
    public void setScreenPixelSize(double d, double d2) {
        this.pixelSizeX = d;
        this.pixelSizeY = d2;
    }

    @Override
    public double getScreenPixelSizeY() {
        return this.pixelSizeY;
    }

    public void setDataPixelSizeX(double d) {
        this.getCurrentSpacingDef().setDataPixelSizeX(d);
    }

    @Override
    public double getDataPixelSizeX() {
        return this.getCurrentSpacingDef().getDataPixelSizeX();
    }

    public void setDataPixelSizeY(double d) {
        this.getCurrentSpacingDef().setDataPixelSizeY(d);
    }

    @Override
    public double getDataPixelSizeY() {
        return this.getCurrentSpacingDef().getDataPixelSizeY();
    }

    @Override
    public double getDataPixelSizeY(Object object) {
        return this.getDataPixelSizeY();
    }

    @Override
    public double getDataPixelSizeX(Object object) {
        return this.getDataPixelSizeX();
    }

    public void setProjectiveSpacing(boolean bl) {
        this.getCurrentSpacingDef().setProjectiveSpacing(bl);
    }

    @Override
    public String getDimensionUnit() {
        return this.getCurrentSpacingDef().toString();
    }

    public void setSizeUnit(SpacingDef.Unit unit) {
        this.getCurrentSpacingDef().setSizeUnit(unit);
    }

    @Override
    public SpacingDef.Unit getSizeUnit() {
        return this.getCurrentSpacingDef().getSizeUnit();
    }

    @Override
    public List<SpacingDef> spacingDefs() {
        return this.spacingDefs;
    }

    public void setWindowValues(double d, double d2) {
        this.window.setCenter(d);
        this.window.setWidth(d2);
    }

    public void setWindow(WindowDef windowDef) {
        this.window = windowDef;
    }

    @Override
    public IWindowSettings getWindow() {
        return this.window;
    }

    @Override
    public long getUpdateStamp() {
        return this.updateStamp;
    }
}

