/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionPersistenceContainer;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.GestureBinding;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutAction;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KeypressRegistry {
    private static final ALogger log = ALogger.getLogger(KeypressRegistry.class);
    private static final List<PluginName> ALLOWED_SCOPES = Arrays.stream(PluginName.values()).filter(KeypressRegistry::isAllowedScope).collect(Collectors.toList());
    private static KeypressRegistry instance = new KeypressRegistry();
    private static final String configKeyUseGestures = Config.impaxee.jvision.Gestures.isEnabled.getKey();
    private ShortcutBlock globalShortCuts = new ShortcutBlock(true);
    private Map<PluginName, ShortcutBlock> shortCuts = new EnumMap<PluginName, ShortcutBlock>(PluginName.class);
    private boolean useGestures;
    private boolean modified = false;
    private PActionPersistenceContainer<ShortcutAction> container;

    public static KeypressRegistry getInstance() {
        return instance;
    }

    public KeypressRegistry(IConfigurationProvider iConfigurationProvider) {
        this.container = new ShortcutActionPersistenceContainer(iConfigurationProvider);
    }

    private KeypressRegistry() {
        this.container = new ShortcutActionPersistenceContainer(ConfigurationProviderFactory.getConfig());
    }

    public static boolean isAllowedScope(PluginName pluginName) {
        return pluginName == null || pluginName == PluginName.LTA || pluginName.isPlugin();
    }

    public ShortcutBlock getCopyOfGlobalShortcuts() {
        return this.globalShortCuts.clone();
    }

    public boolean handleMouse(KeyShortcut keyShortcut, Component component, PluginName pluginName) {
        boolean bl = false;
        if (pluginName != PluginName.DEFAULT) {
            bl = this.shortCuts.get((Object)pluginName).handleMouse(keyShortcut, component);
        }
        if (!bl) {
            bl = this.globalShortCuts.handleMouse(keyShortcut, component);
        }
        return bl;
    }

    public Map<PluginName, ShortcutBlock> getCopyOfPluginShortcuts() {
        EnumMap<PluginName, ShortcutBlock> enumMap = new EnumMap<PluginName, ShortcutBlock>(PluginName.class);
        for (Map.Entry<PluginName, ShortcutBlock> entry : this.shortCuts.entrySet()) {
            enumMap.put(entry.getKey(), entry.getValue().clone());
        }
        return enumMap;
    }

    public void modifyShortcuts(ShortcutBlock shortcutBlock, Map<PluginName, ShortcutBlock> map, boolean bl) {
        this.globalShortCuts = shortcutBlock;
        this.shortCuts = map;
        this.useGestures = bl;
        this.modified = true;
    }

    public boolean handleLTAKeyEvent(KeyEvent keyEvent) {
        return this.shortCuts.get((Object)PluginName.LTA).handle(keyEvent);
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        log.info("Writing modified shortcuts");
        this.container.removeAll();
        for (ShortcutAction object : this.globalShortCuts.getShortcuts()) {
            this.container.addActionRef(object);
        }
        for (ShortcutBlock shortcutBlock : this.shortCuts.values()) {
            for (ShortcutAction shortcutAction : shortcutBlock.getShortcuts()) {
                this.container.addActionRef(shortcutAction);
            }
        }
        try {
            this.container.getConfigurationProvider().setBoolean(configKeyUseGestures, this.useGestures);
            this.container.save(true);
        }
        catch (Exception exception) {
            log.error("Could not store user shortcuts", (Throwable)exception);
        }
    }

    public String toXML() {
        return this.container.toXML();
    }

    public boolean useGestures() {
        return this.useGestures;
    }

    public List<GestureBinding> getGestureBindings() {
        return GestureBinding.createList(this.container.getConfigurationProvider());
    }

    public void init() {
        this.init(false);
    }

    public void init(Document document) {
        this.globalShortCuts = new ShortcutBlock(true);
        this.modified = true;
        this.startInitialization(false, document);
    }

    public void reset() {
        this.modified = true;
        this.globalShortCuts = new ShortcutBlock(true);
        this.init(true);
    }

    public void resetToRole() {
        this.globalShortCuts = new ShortcutBlock(true);
        this.container.resetToRole();
        this.container.getConfigurationProvider().updateCache(this.container.getConfigurationKey());
        this.init(false);
        this.modified = false;
    }

    private void init(boolean bl) {
        this.startInitialization(bl, null);
        String string = System.getProperty("shortCutsHTML.directory");
        if (string != null) {
            this.printShortcutsHTML(string);
        }
        if (this.container.getConfigurationProvider().exists(configKeyUseGestures)) {
            this.useGestures = this.container.getConfigurationProvider().getBoolean(configKeyUseGestures);
        }
    }

    private void startInitialization(boolean bl, Document document) {
        Object object;
        for (PluginName object22 : ALLOWED_SCOPES) {
            this.shortCuts.put(object22, new ShortcutBlock());
        }
        List<PAction> list = PActionRegistry.getShortcutActions();
        if (document != null) {
            this.container.init(document);
        } else {
            this.container.init();
        }
        HashSet hashSet = new HashSet(32);
        if (!bl) {
            for (ShortcutAction shortcutAction : this.container.getActionRefs()) {
                if (shortcutAction.getKeyCode() != -1 && shortcutAction.getModifier() != -1) {
                    try {
                        object = PActionRegistry.getAction(shortcutAction.getActionId());
                        this.addShortCut((PAction)object, shortcutAction.getAsKeyShortcut());
                    }
                    catch (Exception exception) {
                        log.debug("Configured Shortcut action not found:" + shortcutAction.getActionId());
                    }
                }
                hashSet.add(shortcutAction.getActionId());
            }
        }
        for (PAction pAction : list) {
            if (hashSet.contains(pAction.getID()) || (object = pAction.getDefaultShortcut()) == null) continue;
            this.addShortCut(pAction, (KeyShortcut)object);
        }
    }

    public void addShortCut(PAction pAction, KeyShortcut keyShortcut) {
        if (keyShortcut.keyCode == 32 && keyShortcut.modifiers == 0) {
            log.info("Pure space cannot be used as shortcut anymore");
            return;
        }
        PluginName[] pluginNameArray = pAction.getScopes();
        if (pluginNameArray == null) {
            this.globalShortCuts.addShortCut(keyShortcut, pAction);
        } else {
            PluginName[] pluginNameArray2 = pluginNameArray;
            int n = pluginNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginName pluginName = pluginNameArray2[n2];
                ShortcutBlock shortcutBlock = this.shortCuts.get((Object)pluginName);
                if (shortcutBlock == null) {
                    shortcutBlock = this.globalShortCuts;
                }
                shortcutBlock.addShortCut(keyShortcut, pAction);
                ++n2;
            }
        }
    }

    public boolean handleMainFrameKeyEvent(KeyEvent keyEvent) {
        PluginName pluginName;
        VisData visData = VisData.getLastModified();
        boolean bl = false;
        if (visData != null && (pluginName = visData.getParent().getPlugin().getPluginName()) != PluginName.DEFAULT) {
            bl = this.shortCuts.get((Object)pluginName).handle(keyEvent);
        }
        if (!bl) {
            bl = this.globalShortCuts.handle(keyEvent);
        }
        return bl;
    }

    private void printShortcutsHTML(String string) {
        Path path = Paths.get(string, "keyboard-shortcuts.html");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0])));){
                String string2 = System.getProperty("line.separator");
                bufferedWriter.write("<html><head><title>Shortcuts</title></head><body>");
                bufferedWriter.write(string2);
                bufferedWriter.write("<center><h1>Shortcuts</h1></center>");
                bufferedWriter.write(string2);
                bufferedWriter.write(string2);
                bufferedWriter.write("<table border='1'>");
                bufferedWriter.write(string2);
                bufferedWriter.write("<tr><th>Keystroke</th><th>Scope</th><th>ActionGroup</th><th>Action-ID</th><th>Action</th><th>Description</th></tr>");
                Iterator<ShortCut> iterator = this.globalShortCuts.getIterator();
                while (iterator.hasNext()) {
                    ShortCut object = iterator.next();
                    KeypressRegistry.writeTableRow(bufferedWriter, string2, object, "tr", "td");
                }
                for (ShortcutBlock shortcutBlock : this.shortCuts.values()) {
                    iterator = shortcutBlock.getIterator();
                    while (iterator.hasNext()) {
                        ShortCut shortCut = iterator.next();
                        KeypressRegistry.writeTableRow(bufferedWriter, string2, shortCut, "tr", "td");
                    }
                }
                bufferedWriter.write("</table>");
                bufferedWriter.write(string2);
                bufferedWriter.write("</body></html>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.error("Error on writing shortcuts", (Throwable)exception);
        }
    }

    private static void writeTableRow(Writer writer, String string, ShortCut shortCut, String string2, String string3) throws IOException {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder("");
        if (shortCut.action.getScopes() != null) {
            object2 = shortCut.action.getScopes();
            int n = ((PluginName[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                if (object == null) {
                    stringBuilder.append("Global,");
                } else {
                    stringBuilder.append(((PluginName)((Object)object)).getCaption()).append(',');
                }
                ++n2;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        object = shortCut.action.getID();
        String string4 = shortCut.action.getGroupName();
        String string5 = shortCut.action.getCaption();
        object2 = shortCut.action.getToolTipText();
        String string6 = KeyEvent.getKeyModifiersText(shortCut.getModifiers());
        writer.write(60);
        writer.write(string2);
        writer.write("><");
        writer.write(string3);
        writer.write(62);
        writer.write(string6);
        if (string6.length() > 0) {
            writer.write(43);
        }
        writer.write(KeyEvent.getKeyText(shortCut.getKeyCode()));
        writer.write("</");
        writer.write(string3);
        writer.write("><");
        writer.write(string3);
        writer.write(62);
        writer.write(stringBuilder.toString());
        writer.write("</");
        writer.write(string3);
        writer.write("><");
        writer.write(string3);
        writer.write(62);
        writer.write(string4);
        writer.write("</");
        writer.write(string3);
        writer.write("><");
        writer.write(string3);
        writer.write(62);
        writer.write((String)object);
        writer.write("</");
        writer.write(string3);
        writer.write("><");
        writer.write(string3);
        writer.write(62);
        if (string5 != null) {
            writer.write(string5);
        }
        writer.write("</");
        writer.write(string3);
        writer.write("></");
        writer.write(string3);
        writer.write("><");
        writer.write(string3);
        writer.write(62);
        if (object2 != null) {
            writer.write((String)object2);
        }
        writer.write("</");
        writer.write(string2);
        writer.write(62);
        writer.write(string);
    }

    private static class ShortcutActionPersistenceContainer
    extends PActionPersistenceContainer<ShortcutAction> {
        public ShortcutActionPersistenceContainer(IConfigurationProvider iConfigurationProvider) {
            super(iConfigurationProvider, "impaxee.jvision.Shortcuts", null);
        }

        @Override
        protected ShortcutAction createActionRef(Node node) throws Exception {
            return ShortcutAction.create(node);
        }

        @Override
        public void save() throws Exception {
            if (this.getActionRefCount() == 0 && this.getConfigurationProvider().exists(this.getConfigurationKey())) {
                this.getConfigurationProvider().removeValue(this.getConfigurationKey());
            } else {
                super.save();
            }
        }
    }
}

