/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutAction;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ShortcutBlock {
    private static final ALogger log = ALogger.getLogger(ShortcutBlock.class);
    private List<ShortCut> shortcuts;
    private Set<PAction> actionsWithPotentiallyNoShortcuts = new HashSet<PAction>();
    private BitSet[] usedKeys = new BitSet[600];

    ShortcutBlock(boolean bl) {
        int n = 0;
        while (n < this.usedKeys.length) {
            this.usedKeys[n] = new BitSet(12);
            ++n;
        }
        this.shortcuts = new ArrayList<ShortCut>(bl ? 128 : 16);
    }

    private ShortcutBlock(ShortcutBlock shortcutBlock) {
        this.shortcuts = new ArrayList<ShortCut>(shortcutBlock.shortcuts.size());
        for (ShortCut shortCut : shortcutBlock.shortcuts) {
            this.shortcuts.add(new ShortCut(shortCut));
        }
    }

    Iterator<ShortCut> getIterator() {
        return Collections.unmodifiableList(this.shortcuts).iterator();
    }

    public ShortcutBlock clone() {
        return new ShortcutBlock(this);
    }

    public ShortcutBlock() {
        this(false);
    }

    List<ShortcutAction> getShortcuts() {
        ArrayList<ShortcutAction> arrayList = new ArrayList<ShortcutAction>(32);
        for (PAction object : this.actionsWithPotentiallyNoShortcuts) {
            KeyShortcut keyShortcut = object.getDefaultShortcut();
            if (keyShortcut == null) continue;
            boolean bl = false;
            for (ShortCut shortCut : this.shortcuts) {
                if (!shortCut.equalsKey(keyShortcut) || shortCut.action != object) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new ShortcutAction(object.getID(), -1, -1));
        }
        for (ShortCut shortCut : this.shortcuts) {
            arrayList.add(new ShortcutAction(shortCut.action.getID(), shortCut.getKeyCode(), shortCut.getModifiers()));
        }
        return arrayList;
    }

    boolean addShortCut(KeyShortcut keyShortcut, PAction pAction) {
        BitSet bitSet = this.usedKeys[keyShortcut.keyCode];
        if (bitSet.get(keyShortcut.modifiers)) {
            log.warn("Shortcut " + keyShortcut + " of action " + pAction.getName() + " already occupied");
            return false;
        }
        if (this.actionsWithPotentiallyNoShortcuts.contains(pAction)) {
            this.actionsWithPotentiallyNoShortcuts.remove(pAction);
        }
        this.shortcuts.add(new ShortCut(keyShortcut.modifiers, keyShortcut.keyCode, pAction));
        bitSet.set(keyShortcut.modifiers);
        return true;
    }

    public PAction isOccupied(int n, int n2) {
        for (ShortCut shortCut : this.shortcuts) {
            if (!this.keyCodesEqualIgnoringNumberOfMouseClicks(shortCut.getKeyCode(), n) || !this.modifiersEqual(shortCut.getModifiers(), n2)) continue;
            return shortCut.action;
        }
        return null;
    }

    public boolean addShortCutOnRuntime(int n, int n2, PAction pAction) {
        if (this.isOccupied(n, n2) != null) {
            return false;
        }
        this.shortcuts.add(new ShortCut(n2, n, pAction));
        return true;
    }

    public void removeShortcutForAction(int n, int n2, PAction pAction) {
        for (ShortCut shortCut : this.shortcuts) {
            if (!this.keyCodesEqualIgnoringNumberOfMouseClicks(shortCut.getKeyCode(), n) || !this.modifiersEqual(shortCut.getModifiers(), n2) || shortCut.action != pAction) continue;
            this.shortcuts.remove(shortCut);
            this.actionsWithPotentiallyNoShortcuts.add(pAction);
            return;
        }
    }

    public void removeShortcutForAction(String string, PAction pAction) {
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.action != pAction || shortCut.toString().compareTo(string) != 0) continue;
            this.shortcuts.remove(shortCut);
            this.actionsWithPotentiallyNoShortcuts.add(pAction);
            return;
        }
    }

    public void removeAllShortcutsForAction(PAction pAction) {
        ArrayList<ShortCut> arrayList = new ArrayList<ShortCut>();
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.action != pAction) continue;
            arrayList.add(shortCut);
        }
        for (ShortCut shortCut : arrayList) {
            this.shortcuts.remove(shortCut);
        }
        this.actionsWithPotentiallyNoShortcuts.add(pAction);
    }

    public List<ShortCut> getShortcutsForAction(PAction pAction) {
        ArrayList<ShortCut> arrayList = new ArrayList<ShortCut>();
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.action != pAction) continue;
            arrayList.add(shortCut);
        }
        return arrayList;
    }

    public boolean handle(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        if (keyEvent.getKeyCode() != 32 && ModifierKeys.isSpacePressed()) {
            n |= 0x100;
        }
        for (ShortCut shortCut : this.shortcuts) {
            if (shortCut.getKeyCode() != keyEvent.getKeyCode() || !this.modifiersEqual(shortCut.getModifiers(), n)) continue;
            if (shortCut.action.isEnabled()) {
                return shortCut.action.perform(keyEvent.getComponent());
            }
            return false;
        }
        return false;
    }

    public boolean handleMouse(KeyShortcut keyShortcut, Component component) {
        for (ShortCut shortCut : this.shortcuts) {
            if (!shortCut.equalsKey(keyShortcut)) continue;
            if (shortCut.action.isEnabled()) {
                return shortCut.action.perform(component);
            }
            return false;
        }
        return false;
    }

    private boolean keyCodesEqualIgnoringNumberOfMouseClicks(int n, int n2) {
        return n == n2 || n == 400 && n2 == 402 || n == 402 && n2 == 400;
    }

    private boolean modifiersEqual(int n, int n2) {
        if ((n & 8) != (n2 & 8)) {
            return false;
        }
        if ((n & 0x20) != (n2 & 0x20)) {
            return false;
        }
        if ((n & 2) != (n2 & 2)) {
            return false;
        }
        if ((n & 1) != (n2 & 1)) {
            return false;
        }
        if ((n & 0x10) != (n2 & 0x10)) {
            return false;
        }
        if ((n & 8) != (n2 & 8)) {
            return false;
        }
        if ((n & 4) != (n2 & 4)) {
            return false;
        }
        if ((n & MouseEvent.getMaskForButton(4)) != (n2 & MouseEvent.getMaskForButton(4))) {
            return false;
        }
        if ((n & MouseEvent.getMaskForButton(5)) != (n2 & MouseEvent.getMaskForButton(5))) {
            return false;
        }
        if ((n & 4) != (n2 & 4)) {
            return false;
        }
        if ((n & 0x200) != (n2 & 0x200)) {
            return false;
        }
        if ((n & 0x2000) != (n2 & 0x2000)) {
            return false;
        }
        if ((n & 0x80) != (n2 & 0x80)) {
            return false;
        }
        if ((n & 0x40) != (n2 & 0x40)) {
            return false;
        }
        if ((n & 0x400) != (n2 & 0x400)) {
            return false;
        }
        if ((n & 0x800) != (n2 & 0x800)) {
            return false;
        }
        if ((n & 0x1000) != (n2 & 0x1000)) {
            return false;
        }
        return (n & 0x100) == (n2 & 0x100);
    }
}

