/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.jvision.keypress.GestureBinding;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.keypress.gui.ActionTree;
import com.tiani.jvision.keypress.gui.ActionTreeModel;
import com.tiani.jvision.keypress.gui.ActionsDlg;
import com.tiani.jvision.keypress.gui.ShortcutListener;
import com.tiani.jvision.keypress.gui.ShortcutTextArea;
import com.tiani.jvision.plugin.PluginName;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ActionTreePanel
extends JPanel
implements TreeSelectionListener {
    private static final int[] SUPPORTED_MODIFIERS = new int[]{2, 8, 1};
    ActionTree tree;
    private JScrollPane treeScroller;
    private JPanel treePanel = new JPanel();
    private JPanel descriptionPanel = new JPanel();
    private JPanel shortcutPanel = new JPanel();
    private ShortcutTextArea textAreaShortcut;
    private JTextField textFieldSearch;
    private boolean editShortcuts;
    private JToggleButton btnAddShortcut;
    private JButton btnResetShortcut;
    private JButton btnRemoveShortcut;
    private PAction selectedAction;
    private ShortcutListener listener;
    private JTextArea txtDescription;
    private JScrollPane txtDescriptionScroller;
    private boolean shortcutsModified = false;
    private JCheckBox useGesturesCheckBox;
    private boolean originalUseGestures;

    public ActionTreePanel(ShortcutBlock shortcutBlock, Map<PluginName, ShortcutBlock> map, Collection<GestureBinding> collection, boolean bl, IComponentFactory iComponentFactory, boolean bl2) {
        JPanel jPanel;
        Object object;
        TableLayout tableLayout = new TableLayout(new double[]{-1.0}, new double[]{-1.0, -2.0, -2.0, -2.0});
        this.setLayout((LayoutManager)tableLayout);
        this.originalUseGestures = bl;
        this.editShortcuts = Permissions.getInstance().isAllowed("ImageArea/AllowToEditShortCuts");
        this.tree = new ActionTree(shortcutBlock, map, iComponentFactory);
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 8: 
                    case 127: {
                        ActionTreePanel.this.removeSelectedShortcut();
                    }
                }
            }
        });
        this.treeScroller = iComponentFactory.createScrollPane((Component)this.tree);
        this.treePanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_LABEL_ACTIONS")));
        this.treePanel.setLayout(new BorderLayout());
        this.textFieldSearch = iComponentFactory.createTextField();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("ActionTreePanel.Search")) + ':'), "West");
        jPanel2.add((Component)this.textFieldSearch, "Center");
        jPanel2.setOpaque(false);
        this.textFieldSearch.addKeyListener(this.tree);
        this.treePanel.add((Component)jPanel2, "North");
        this.treePanel.add((Component)this.treeScroller, "Center");
        this.add((Component)this.treePanel, "0,0");
        this.descriptionPanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_LABEL_DESCRIPTION")));
        this.descriptionPanel.setLayout(new BorderLayout());
        this.txtDescription = iComponentFactory.createTextArea();
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        this.txtDescription.setEditable(false);
        Border border = this.txtDescription.getBorder();
        Insets insets = border.getBorderInsets(this.txtDescription);
        this.txtDescription.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        this.txtDescription.setRows(2);
        this.txtDescriptionScroller = iComponentFactory.createScrollPane((Component)this.txtDescription);
        this.descriptionPanel.add((Component)this.txtDescriptionScroller, "Center");
        this.add((Component)this.descriptionPanel, "0,1");
        if (this.editShortcuts) {
            this.textAreaShortcut = new ShortcutTextArea();
            iComponentFactory.scaleFont((Component)this.textAreaShortcut);
            this.textAreaShortcut.setRows(3);
            object = new JScrollPane(this.textAreaShortcut, 20, 31);
            this.shortcutPanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_LABEL_SHORTCUTS")));
            this.shortcutPanel.setLayout(new BorderLayout(4, 4));
            this.shortcutPanel.add((Component)object, "Center");
            this.textAreaShortcut.setEditable(false);
            this.listener = new ShortcutListener(this.textAreaShortcut, this);
            jPanel = iComponentFactory.createPanel((LayoutManager)new GridBagLayout());
            jPanel.setOpaque(false);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body>");
            stringBuilder.append(Messages.getString("SHORTCUTS_HELPSTRING1"));
            stringBuilder.append(Messages.getString("SHORTCUTS_HELP_MODIFIERS"));
            stringBuilder.append(": ");
            int[] nArray = SUPPORTED_MODIFIERS;
            int n = SUPPORTED_MODIFIERS.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                stringBuilder.append(KeyEvent.getKeyModifiersText(n3));
                stringBuilder.append(", ");
                ++n2;
            }
            stringBuilder.append(Messages.getString("SpaceKey"));
            stringBuilder.append("<br>");
            stringBuilder.append(Messages.getString("SHORTCUTS_HELPSTRING2"));
            stringBuilder.append("</body></html>");
            JLabel jLabel = ActionTreePanel.createHelpLabel(iComponentFactory, stringBuilder.toString());
            this.shortcutPanel.add((Component)jLabel, "South");
            this.btnRemoveShortcut = iComponentFactory.createButton((Action)new RemoveShortcut());
            this.btnAddShortcut = iComponentFactory.createToggleButton((Action)new AddShortcut());
            this.btnResetShortcut = iComponentFactory.createButton((Action)new ResetShortcut());
            this.btnResetShortcut.setEnabled(false);
            this.btnAddShortcut.setEnabled(false);
            this.btnRemoveShortcut.setEnabled(false);
            this.addComponent(jPanel, 0, 0, 1, this.btnRemoveShortcut);
            this.addComponent(jPanel, 1, 0, 1, Box.createHorizontalStrut(4));
            this.addComponent(jPanel, 2, 0, 1, this.btnAddShortcut);
            this.addComponent(jPanel, 3, 0, 1, Box.createHorizontalStrut(4));
            this.addComponent(jPanel, 4, 0, 1, this.btnResetShortcut);
            this.shortcutPanel.add((Component)jPanel, "East");
            this.add((Component)this.shortcutPanel, "0, 2");
        }
        if (this.editShortcuts || bl && !collection.isEmpty()) {
            boolean bl3 = bl2 || !this.editShortcuts;
            jPanel = new JPanel();
            jPanel.setBorder(iComponentFactory.createTitledBorder(Messages.getString("ACTIONS_GESTURES")));
            jPanel.setLayout(new BorderLayout(4, 4));
            this.useGesturesCheckBox = iComponentFactory.createCheckBox(Messages.getString("ACTIONS_USE_GESTURES"));
            this.useGesturesCheckBox.setSelected(bl);
            if (!bl3 && !collection.isEmpty()) {
                this.useGesturesCheckBox.setToolTipText(this.buildGesturesHelpText(collection));
            }
            if (this.editShortcuts) {
                jPanel.add((Component)this.useGesturesCheckBox, "Center");
            }
            if (bl3 && !collection.isEmpty()) {
                jPanel.add((Component)ActionTreePanel.createHelpLabel(iComponentFactory, this.buildGesturesHelpText(collection)), this.editShortcuts ? "South" : "Center");
            }
            this.add((Component)jPanel, "0, 3");
        }
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        if (this.editShortcuts) {
            object = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = ActionTreePanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = ActionTreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1) {
                        if (mouseEvent.getClickCount() == 2) {
                            Object object = treePath.getLastPathComponent();
                            if (!(object instanceof PAction)) {
                                return;
                            }
                            ActionTreePanel.this.addNewShortcut();
                        } else {
                            ActionTreePanel.this.editModeOff(true);
                        }
                    } else {
                        ActionTreePanel.this.editModeOff(false);
                    }
                }
            };
            this.tree.addMouseListener((MouseListener)object);
        }
    }

    private String buildGesturesHelpText(Collection<GestureBinding> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        if (this.editShortcuts) {
            stringBuilder.append(Messages.getString("ACTIONS_USE_GESTURES_HELPSTRING_CONFIG"));
        } else {
            stringBuilder.append(Messages.getString("ACTIONS_USE_GESTURES_HELPSTRING_INFO"));
        }
        stringBuilder.append("<ul>");
        TreeSet<GestureBinding> treeSet = new TreeSet<GestureBinding>(ActionTreePanel::compareGesturesByActionName);
        treeSet.addAll(collection);
        for (GestureBinding gestureBinding : treeSet) {
            stringBuilder.append("<li>");
            stringBuilder.append(gestureBinding.getAction().getName());
            stringBuilder.append(" [");
            stringBuilder.append(Messages.getString("ACTIONS_USE_GESTURES_" + gestureBinding.getGesture().name()));
            stringBuilder.append("]</li>");
        }
        stringBuilder.append("</ul></body></html>");
        return stringBuilder.toString();
    }

    private static int compareGesturesByActionName(GestureBinding gestureBinding, GestureBinding gestureBinding2) {
        return ActionTreeModel.ACTION_SORTER.compare(gestureBinding.getAction(), gestureBinding2.getAction());
    }

    private static JLabel createHelpLabel(IComponentFactory iComponentFactory, String string) {
        JLabel jLabel = iComponentFactory.createLabel(string);
        jLabel.setForeground(ColorUtils.ensureAWTColor((Color)ColorUtils.getSecondary4()));
        return jLabel;
    }

    private void removeSelectedShortcut() {
        String string = this.textAreaShortcut.getShortcutSelectedForDeletion();
        if (this.selectedAction != null && string != null) {
            for (ShortcutBlock shortcutBlock : this.tree.getBlockForAction(this.selectedAction)) {
                shortcutBlock.removeShortcutForAction(string, this.selectedAction);
            }
            this.shortcutsModified = true;
            this.reloadTree();
            this.editModeOff(true);
        }
    }

    private void addNewShortcut() {
        if (!this.textAreaShortcut.isEditable()) {
            this.editModeOn();
        }
        this.textAreaShortcut.newLine();
    }

    private void editModeOn() {
        this.textAreaShortcut.setEditable(true);
        this.listener.setShortcutScope(this.tree.getBlockForAction(this.selectedAction));
        this.textAreaShortcut.setKeyAndMouseListener(this.listener);
        this.textAreaShortcut.requestFocusInWindow();
        this.btnAddShortcut.setSelected(true);
    }

    private void editModeOff(boolean bl) {
        if (this.textAreaShortcut.isEditable()) {
            this.textAreaShortcut.setEditable(false);
            this.textAreaShortcut.resetAfterEdit(this.listener, bl);
        }
        this.btnAddShortcut.setSelected(false);
        this.tree.requestFocusInWindow();
        this.listener.reset();
    }

    void handleChange() {
        if (this.listener != null && this.textAreaShortcut != null) {
            this.textAreaShortcut.removeKeyListener(this.listener);
            if (this.selectedAction != null && this.textAreaShortcut.isEditable()) {
                if (this.listener.getResultKeyCode() > 0) {
                    List<ShortcutBlock> list = this.tree.getBlockForAction(this.selectedAction);
                    for (ShortcutBlock shortcutBlock : list) {
                        shortcutBlock.addShortCutOnRuntime(this.listener.getResultKeyCode(), this.listener.getResultModifier(), this.selectedAction);
                    }
                    this.shortcutsModified = true;
                    this.reloadTree();
                } else if (this.listener.getResultMouseButton() > -1 && this.listener.getResultClickCount() > -1) {
                    List<ShortcutBlock> list = this.tree.getBlockForAction(this.selectedAction);
                    int n = this.listener.getResultClickCount() == 1 ? 400 : 402;
                    int n2 = this.listener.getResultModifier();
                    MouseEvent mouseEvent = this.listener.getLastMouseClickEvent();
                    n2 |= MouseEvent.getMaskForButton(mouseEvent.getButton());
                    for (ShortcutBlock shortcutBlock : list) {
                        shortcutBlock.addShortCutOnRuntime(n, n2, this.selectedAction);
                    }
                    this.shortcutsModified = true;
                    this.reloadTree();
                } else {
                    this.textAreaShortcut.setLine("");
                }
            }
            this.editModeOff(true);
        }
    }

    public boolean wasModified() {
        return this.shortcutsModified && this.editShortcuts || this.originalUseGestures != this.useGesturesCheckBox.isSelected();
    }

    public void setShortcutsModified() {
        this.shortcutsModified = true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        Object object = null;
        if (treePath != null) {
            object = treePath.getLastPathComponent();
        }
        if (treeSelectionEvent.getNewLeadSelectionPath() == treeSelectionEvent.getOldLeadSelectionPath()) {
            this.handleChange();
        }
        if (object instanceof PAction) {
            this.selectedAction = (PAction)object;
            String string = this.selectedAction.getDescription();
            if (string == null || string.startsWith("<html")) {
                string = this.selectedAction.getCaption();
            }
            this.txtDescription.setText(string);
            if (this.editShortcuts) {
                this.btnResetShortcut.setEnabled(true);
                this.btnAddShortcut.setEnabled(true);
                List<ShortCut> list = this.tree.getShortcutsForAction(this.selectedAction);
                if (list.isEmpty()) {
                    this.btnRemoveShortcut.setEnabled(false);
                    this.textAreaShortcut.setText("");
                } else {
                    this.btnRemoveShortcut.setEnabled(true);
                    StringBuilder stringBuilder = new StringBuilder();
                    Iterator<ShortCut> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        stringBuilder.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append("\n");
                    }
                    this.textAreaShortcut.setText(stringBuilder.toString());
                }
            }
        } else {
            this.txtDescription.setText("");
            this.selectedAction = null;
            if (this.editShortcuts) {
                this.textAreaShortcut.setText("");
                this.btnResetShortcut.setEnabled(false);
                this.btnAddShortcut.setEnabled(false);
                this.btnRemoveShortcut.setEnabled(false);
            }
        }
    }

    public final void addComponent(JPanel jPanel, int n, int n2, int n3, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(component, gridBagConstraints);
    }

    public ActionTree getTree() {
        return this.tree;
    }

    public void reloadTree() {
        TreePath treePath = this.tree.getSelectionPath();
        this.tree.reload(this.textFieldSearch);
        this.tree.getSelectionModel().setSelectionPath(treePath);
    }

    public boolean isUseGesturesChecked() {
        return this.useGesturesCheckBox.isSelected();
    }

    private class AddShortcut
    extends AbstractAction {
        private static final long serialVersionUID = -716713698689022726L;

        public AddShortcut() {
            super(null, IconUtil.getAddIcon((int)22));
            super.putValue("ShortDescription", Messages.getString("ActionTreePanel.AddTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JToggleButton)actionEvent.getSource()).isSelected()) {
                ActionTreePanel.this.addNewShortcut();
            } else {
                ActionTreePanel.this.editModeOff(false);
                ActionTreePanel.this.reloadTree();
            }
        }
    }

    private class RemoveShortcut
    extends AbstractAction {
        private static final long serialVersionUID = 9059301664413496168L;

        public RemoveShortcut() {
            super(null, (Icon)IAIconFactory.DEFAULT_FACTORY.loadIcon(ActionsDlg.class, "close.svg"));
            super.putValue("ShortDescription", Messages.getString("ActionTreePanel.RemoveTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionTreePanel.this.removeSelectedShortcut();
        }
    }

    private class ResetShortcut
    extends AbstractAction {
        private static final long serialVersionUID = -4305641568390431313L;

        public ResetShortcut() {
            super(Messages.getString("ActionTreePanel.Reset"));
            super.putValue("ShortDescription", Messages.getString("ActionTreePanel.ResetTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ActionTreePanel.this.selectedAction != null) {
                for (ShortcutBlock shortcutBlock : ActionTreePanel.this.tree.getBlockForAction(ActionTreePanel.this.selectedAction)) {
                    shortcutBlock.removeAllShortcutsForAction(ActionTreePanel.this.selectedAction);
                }
                KeyShortcut keyShortcut = ActionTreePanel.this.selectedAction.getDefaultShortcut();
                if (keyShortcut != null) {
                    for (ShortcutBlock shortcutBlock : ActionTreePanel.this.tree.getBlockForAction(ActionTreePanel.this.selectedAction)) {
                        if (shortcutBlock.isOccupied(keyShortcut.keyCode, keyShortcut.modifiers) != null) continue;
                        shortcutBlock.addShortCutOnRuntime(keyShortcut.keyCode, keyShortcut.modifiers, ActionTreePanel.this.selectedAction);
                    }
                }
                ActionTreePanel.this.shortcutsModified = true;
                ActionTreePanel.this.reloadTree();
            }
        }
    }
}

