/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.keypress.KeypressRegistry;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.keypress.gui.ActionTreePanel;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ActionsDlg
extends StandardDialog {
    private KeypressRegistry actionManager = KeypressRegistry.getInstance();
    private ActionTreePanel actionTreePanel;
    private ShortcutBlock globalShortcuts;
    private Map<PluginName, ShortcutBlock> pluginShortcuts;

    public ActionsDlg(JFrame jFrame) {
        super((Frame)jFrame, Messages.getString("ACTIONS_ACTIONSDLG_TITLE"));
        this.disableDisposeOnPatientChange();
        this.globalShortcuts = this.actionManager.getCopyOfGlobalShortcuts();
        this.pluginShortcuts = this.actionManager.getCopyOfPluginShortcuts();
        this.actionTreePanel = new ActionTreePanel(this.globalShortcuts, this.pluginShortcuts, this.actionManager.getGestureBindings(), this.actionManager.useGestures(), ComponentFactory.instance, false);
        if (Permissions.getInstance().isAllowed("ImageArea/AllowToEditShortCuts")) {
            this.addOKButton(new OKAction());
            this.addButton(new ResetAction());
        }
        this.addCancelButton(new CancelAction());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.actionTreePanel, "Center");
        Dimension dimension = new Dimension(720, (int)((float)this.getParent().getHeight() * 0.8f));
        this.setPreferredSize(dimension);
        this.setContent(jPanel);
        this.pack();
        this.initLocation();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super.putValue("ShortDescription", Messages.getString("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionsDlg.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            super.putValue("ShortDescription", Messages.getString("ActionsDlg.ApplyTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ActionsDlg.this.actionTreePanel.wasModified()) {
                ActionsDlg.this.actionManager.modifyShortcuts(ActionsDlg.this.globalShortcuts, ActionsDlg.this.pluginShortcuts, ActionsDlg.this.actionTreePanel.isUseGesturesChecked());
            }
            ActionsDlg.this.setVisible(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super(null, (Icon)IAIconFactory.DEFAULT_FACTORY.loadIcon(ActionsDlg.class, "reset.svg"));
            super.putValue("ShortDescription", Messages.getString("ActionsDlg.ResetTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Message.yesNo(Messages.getString("ActionsDlg.ResetUserQuestion"));
            if (n == 1) {
                return;
            }
            KeypressRegistry.getInstance().reset();
            ActionsDlg.this.setVisible(false);
        }
    }
}

