/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.ShortcutBlock;
import com.tiani.jvision.keypress.gui.ActionTreePanel;
import com.tiani.jvision.keypress.gui.ShortcutTextArea;
import com.tiani.util.message.Message;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;

public class ShortcutListener
implements KeyListener,
MouseListener,
MouseMotionListener {
    static final int NONE = 0;
    static final int SHIFT = 1;
    static final int CTRL = 2;
    static final int ALT = 8;
    static final int SPACE = 16;
    static final int KEY_EVENT_SPACE_MODIFIER_MASK = 256;
    private ShortcutTextArea textArea;
    private int modifiers = 0;
    private int mouseButton = -1;
    private int mouseClickCount = -1;
    private KeyEvent lastPressEvent;
    private List<ShortcutBlock> blocks = null;
    private String originalShortcut;
    private ActionTreePanel panel;
    private MouseEvent lastMouseClickEvent;
    private int lastMousePressModifiers;
    private int lastKeyPressModifiers;
    private static final ALogger log = ALogger.getLogger(ShortcutListener.class);

    public ShortcutListener(ShortcutTextArea shortcutTextArea, ActionTreePanel actionTreePanel) {
        this.textArea = shortcutTextArea;
        this.panel = actionTreePanel;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.lastPressEvent = null;
        this.setControl(keyEvent.isControlDown());
        this.setAlt(keyEvent.isAltDown());
        this.setShift(keyEvent.isShiftDown());
        switch (keyEvent.getKeyCode()) {
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                this.setSpace(true);
                int n = keyEvent.getModifiers();
                if (n == 0 || n == 1024 || n == 16) break;
            }
            case 27: {
                if (keyEvent.getModifiers() == 0) {
                    return;
                }
            }
            default: {
                this.lastPressEvent = keyEvent;
                this.lastKeyPressModifiers = keyEvent.getModifiers();
                if (!this.isSpace()) break;
                this.lastKeyPressModifiers |= 0x100;
            }
        }
        keyEvent.consume();
        this.textArea.setLine(this.getString());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 17: {
                if (this.lastPressEvent != null) break;
                this.setControl(false);
                break;
            }
            case 18: {
                if (this.lastPressEvent != null) break;
                this.setAlt(false);
                break;
            }
            case 16: {
                if (this.lastPressEvent != null) break;
                this.setShift(false);
                break;
            }
            case 32: {
                if (this.lastPressEvent == null) {
                    this.setSpace(false);
                }
                if (keyEvent.getModifiers() != 0 || this.lastMousePressModifiers != 0) break;
                this.panel.handleChange();
                return;
            }
        }
        keyEvent.consume();
        this.finalizeShortcutDefinition();
    }

    private void finalizeShortcutDefinition() {
        int n = -1;
        int n2 = -1;
        LinkedList<PAction> linkedList = new LinkedList<PAction>();
        if (this.blocks != null && this.lastPressEvent != null && this.lastMouseClickEvent == null) {
            n = this.lastPressEvent.getKeyCode();
            n2 = this.lastKeyPressModifiers;
            for (ShortcutBlock object2 : this.blocks) {
                PAction pAction = object2.isOccupied(n, n2);
                if (pAction == null) continue;
                linkedList.add(pAction);
            }
        } else if (this.blocks != null && this.lastMouseClickEvent != null) {
            this.lastPressEvent = null;
            for (ShortcutBlock shortcutBlock : this.blocks) {
                PAction pAction = shortcutBlock.isOccupied(n = this.mouseClickCount == 1 ? 400 : 402, n2 = this.lastMousePressModifiers | MouseEvent.getMaskForButton(this.lastMouseClickEvent.getButton()));
                if (pAction == null) continue;
                linkedList.add(pAction);
            }
        }
        if (!linkedList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(512);
            stringBuilder.append(String.valueOf(Messages.getString("ShortcutListener.KeysOccupied")) + "\n\n");
            for (Object object3 : linkedList) {
                stringBuilder.append(String.valueOf(object3.getName()) + " [" + new KeyShortcut(n, n2).toString() + "]").append("\n\n");
            }
            stringBuilder.append(Messages.getString("ShortcutListener.Continue"));
            int n3 = Message.yesNo(stringBuilder);
            if (n3 == 1) {
                this.textArea.setText(this.originalShortcut);
                this.lastMouseClickEvent = null;
                this.mouseButton = -1;
                this.lastMousePressModifiers = 0;
                this.lastKeyPressModifiers = 0;
                this.modifiers = 0;
                this.lastPressEvent = null;
                return;
            }
            for (ShortcutBlock shortcutBlock : this.blocks) {
                for (PAction pAction : linkedList) {
                    if (this.lastPressEvent != null) {
                        shortcutBlock.removeShortcutForAction(this.lastPressEvent.getKeyCode(), this.lastKeyPressModifiers, pAction);
                        continue;
                    }
                    if (this.lastMouseClickEvent == null) continue;
                    n = this.mouseClickCount == 1 ? 400 : 402;
                    n2 = this.lastMousePressModifiers | MouseEvent.getMaskForButton(this.lastMouseClickEvent.getButton());
                    shortcutBlock.removeShortcutForAction(n, n2, pAction);
                }
            }
        }
        this.textArea.setLine(this.getString());
        this.panel.handleChange();
        this.mouseButton = -1;
        this.mouseClickCount = -1;
        this.lastMouseClickEvent = null;
    }

    public void setShortcutScope(List<ShortcutBlock> list) {
        this.blocks = list;
        this.originalShortcut = this.textArea.getText();
    }

    public int getResultModifier() {
        if (this.lastPressEvent != null) {
            return this.lastKeyPressModifiers;
        }
        if (this.mouseButton > -1 && this.mouseClickCount > -1) {
            return this.lastMousePressModifiers;
        }
        return 0;
    }

    public int getResultKeyCode() {
        if (this.lastPressEvent != null) {
            return this.lastPressEvent.getKeyCode();
        }
        return 0;
    }

    public int getResultMouseButton() {
        return this.mouseButton;
    }

    public int getResultClickCount() {
        return this.mouseClickCount;
    }

    public MouseEvent getLastMouseClickEvent() {
        return this.lastMouseClickEvent;
    }

    private void setControl(boolean bl) {
        if (this.isControl() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 2) : (this.modifiers ^= 2);
    }

    private void setAlt(boolean bl) {
        if (this.isAlt() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 8) : (this.modifiers ^= 8);
    }

    private void setShift(boolean bl) {
        if (this.isShift() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 1) : (this.modifiers ^= 1);
    }

    private void setSpace(boolean bl) {
        if (this.isSpace() == bl) {
            return;
        }
        this.modifiers = bl ? (this.modifiers |= 0x10) : (this.modifiers ^= 0x10);
    }

    private boolean isControl() {
        return (this.modifiers & 2) != 0;
    }

    private boolean isAlt() {
        return (this.modifiers & 8) != 0;
    }

    private boolean isShift() {
        return (this.modifiers & 1) != 0;
    }

    private boolean isSpace() {
        return (this.modifiers & 0x10) != 0;
    }

    private String getString() {
        String string = this.getModifierString();
        String string2 = this.getKeyString();
        String string3 = this.getMouseString();
        return String.valueOf(string) + string2 + string3;
    }

    private String getMouseString() {
        if (this.mouseButton == -1 || this.mouseClickCount == -1) {
            return "";
        }
        String string = "";
        if (this.mouseButton == 1) {
            string = String.valueOf(string) + Messages.getString("LeftMouseButton") + "-";
        } else if (this.mouseButton == 2) {
            string = String.valueOf(string) + Messages.getString("MiddleMouseButton") + "-";
        } else if (this.mouseButton == 3) {
            string = String.valueOf(string) + Messages.getString("RightMouseButton") + "-";
        } else if (this.mouseButton == 4) {
            string = String.valueOf(string) + Messages.getString("ShortcutListener_MouseButton4") + "-";
        } else if (this.mouseButton == 5) {
            string = String.valueOf(string) + Messages.getString("ShortcutListener_Button5") + "-";
        }
        string = this.mouseClickCount > 1 ? String.valueOf(string) + Messages.getString("DoubleClick") : String.valueOf(string) + Messages.getString("SingleClick");
        return string;
    }

    private String getModifierString() {
        if (this.modifiers == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isSpace()) {
            stringBuilder.append(Messages.getString("SpaceKey")).append("+");
        }
        if (this.isControl()) {
            stringBuilder.append(KeyEvent.getKeyText(17)).append("+");
        }
        if (this.isAlt()) {
            stringBuilder.append(KeyEvent.getKeyText(18)).append("+");
        }
        if (this.isShift()) {
            stringBuilder.append(KeyEvent.getKeyText(16)).append("+");
        }
        return stringBuilder.toString();
    }

    private String getKeyString() {
        if (this.lastPressEvent == null) {
            return "";
        }
        if (this.isSpace() && this.lastPressEvent.getKeyCode() == 32) {
            return "";
        }
        String string = KeyEvent.getKeyText(this.lastPressEvent.getKeyCode());
        return string;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = this.isAlt() || this.isControl() || this.isShift() || this.isSpace();
        if (!(bl || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 3)) {
            return;
        }
        this.mouseButton = mouseEvent.getButton();
        this.mouseClickCount = mouseEvent.getClickCount();
        this.lastMouseClickEvent = mouseEvent;
        this.textArea.setLine(this.getString());
        if (mouseEvent.getClickCount() == 1) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean bl3;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        log.error("thread interrupted");
                    }
                    boolean bl2 = bl3 = ShortcutListener.this.mouseButton == 3 && !bl;
                    if (ShortcutListener.this.mouseClickCount == 1 && bl3) {
                        ShortcutListener.this.textArea.setLine("");
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMousePressModifiers = mouseEvent.getModifiersEx();
        if (this.isSpace()) {
            this.lastMousePressModifiers |= 0x100;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void reset() {
        this.lastMouseClickEvent = null;
        this.lastPressEvent = null;
        this.modifiers = 0;
        this.mouseButton = -1;
        this.mouseClickCount = -1;
    }
}

