/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.keypress.gui;

import com.agfa.pacs.impaxee.Messages;
import com.tiani.jvision.keypress.gui.ShortcutListener;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextArea;

public class ShortcutTextArea
extends JTextArea {
    private int currentlyEditedLineNumber = 0;
    private int lineHighlighted = -1;
    private ShortcutTextAreaMouseListener regularMouseListener = new ShortcutTextAreaMouseListener();
    private boolean rectangleDrawn = false;
    private static final long serialVersionUID = 8367997168331818898L;

    public ShortcutTextArea() {
        this.addMouseListener(this.regularMouseListener);
        this.addMouseMotionListener(this.regularMouseListener);
        this.setHighlighter(null);
    }

    public void setLine(String string) {
        List<String> list = this.getIndividualStrings();
        if (this.currentlyEditedLineNumber == list.size()) {
            list.add(string);
        } else {
            list.set(this.currentlyEditedLineNumber, string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        this.setText(stringBuilder.toString());
        this.resetHighlight();
    }

    public void newLine() {
        this.currentlyEditedLineNumber = this.getIndividualStrings().size();
        this.resetHighlight();
    }

    public String getShortcutSelectedForDeletion() {
        List<String> list = this.getIndividualStrings();
        if (list.isEmpty()) {
            return null;
        }
        int n = 0;
        if (list.size() > 1) {
            if (this.lineHighlighted != -1) {
                n = this.lineHighlighted;
            } else {
                Message.info(Messages.getString("ShortcutTextArea.ChooseShortcutToDelete"));
                return null;
            }
        }
        this.resetHighlight();
        return list.get(n);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.resetHighlight();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getFontMetrics(this.getFont()).getHeight();
        if (this.lineHighlighted > -1) {
            int n2 = n * this.lineHighlighted + 5;
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.GRAY);
            graphics.drawRect(3, n2, rectangle.width - 6 - 2, n);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(4, n2 + 1, rectangle.width - 6 - 4, n - 2);
            graphics.setColor(Color.GRAY);
            graphics.drawRect(5, n2 + 2, rectangle.width - 6 - 6, n - 4);
            this.rectangleDrawn = true;
        } else if (this.rectangleDrawn) {
            this.rectangleDrawn = false;
            this.invalidate();
            this.repaint();
        }
    }

    public void setKeyAndMouseListener(ShortcutListener shortcutListener) {
        this.removeAllMouseListeners();
        this.addMouseListener(shortcutListener);
        this.addMouseMotionListener(shortcutListener);
        this.addKeyListener(shortcutListener);
    }

    public void resetAfterEdit(KeyListener keyListener, boolean bl) {
        this.removeAllMouseListeners();
        this.addMouseListener(this.regularMouseListener);
        this.addMouseMotionListener(this.regularMouseListener);
        this.removeKeyListener(keyListener);
        if (!bl) {
            this.setLine("");
            --this.currentlyEditedLineNumber;
        }
    }

    private void removeAllMouseListeners() {
        Object object;
        MouseListener[] mouseListenerArray;
        MouseListener[] mouseListenerArray2 = mouseListenerArray = this.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = mouseListenerArray2[n2];
            this.removeMouseListener((MouseListener)object);
            ++n2;
        }
        MouseMotionListener[] mouseMotionListenerArray = object = this.getMouseMotionListeners();
        int n3 = ((MouseMotionListener[])object).length;
        n = 0;
        while (n < n3) {
            MouseMotionListener mouseMotionListener = mouseMotionListenerArray[n];
            this.removeMouseMotionListener(mouseMotionListener);
            ++n;
        }
    }

    private void resetHighlight() {
        this.lineHighlighted = -1;
    }

    private void mouseClickAt(Point point, boolean bl) {
        int n;
        int n2 = Math.max(0, point.y - 5);
        int n3 = n2 / this.getFontMetrics(this.getFont()).getHeight();
        List<String> list = this.getIndividualStrings();
        this.lineHighlighted = bl ? (this.lineHighlighted == (n = Math.min(n3, list.size() - 1)) ? -1 : Math.min(n3, list.size() - 1)) : Math.min(n3, list.size() - 1);
        this.repaint();
    }

    private List<String> getIndividualStrings() {
        String string = this.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private class ShortcutTextAreaMouseListener
    implements MouseListener,
    MouseMotionListener {
        private ShortcutTextAreaMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ShortcutTextArea.this.mouseClickAt(mouseEvent.getPoint(), true);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ShortcutTextArea.this.mouseClickAt(mouseEvent.getPoint(), false);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

