/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfoListener;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.impaxee.mousemodeinfo.POCreationStatus;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.IViewportRestoreHandler;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.OverlayType;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.ROIFactory;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.event.mouse.MousePreChargeHandlerFactory;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.vecmath.Vector2d;
import sun.awt.image.ToolkitImage;

public abstract class AbstractMouseModeInfo
implements IMouseModeInfo {
    private static final ALogger log = ALogger.getLogger(AbstractMouseModeInfo.class);
    private static final Map<MouseSubModes, OverlayType> OVERLAY_TYPES_PER_MOUSE_SUB_MODE = new EnumMap<MouseSubModes, OverlayType>(MouseSubModes.class);
    protected boolean areHotRegionsInside = true;
    public MouseSubModes subMode;
    public MouseSubModes lastSubMode = this.subMode = MouseSubModes.DEFAULT;
    private final List<IMouseModeInfoListener> mouseModeListeners = new CopyOnWriteArrayList<IMouseModeInfoListener>();
    protected PresentationObject poInCreation;
    private boolean clone;
    private Object zoomValueBeforePO;
    private Vector2d centreBeforPO;
    private IViewportRestoreHandler restoreHandler;
    boolean isROIShuttered = false;
    boolean isROIFilled = false;
    boolean isROIRelativeScreen = false;

    static {
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_ANGLE, OverlayType.ANGLE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_COBB_ANGLE, OverlayType.COBB_ANGLE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_ARROW, OverlayType.ARROW);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_TEXT, OverlayType.TEXT);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_CIRCLE, OverlayType.CIRCLE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_CIRCLE_3POINT, OverlayType.CIRCLE_3POINT);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_ELLIPSE, OverlayType.ELLIPSE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_RECTANGLE, OverlayType.RECTANGLE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_POLYGON, OverlayType.POLYGON);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.EMPR_SEGMENTATION_DRAW_BACKGROUND_POLYGON, OverlayType.POLY_MARKER);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.EMPR_SEGMENTATION_DRAW_STRUCTURE_POLYGON, OverlayType.POLY_MARKER);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_SPLINECURVE, OverlayType.CURVE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_MAGNETIC_CONTOUR, OverlayType.MAGNETIC_CONTOUR);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_DISTANCE, OverlayType.LENGTH);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_NORMAL_DISTANCE, OverlayType.NORMAL_DISTANCE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_RATIO, OverlayType.RATIO);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_BIDIMENSIONAL_LENGTH, OverlayType.BIDIMENSIONAL_LENGTH);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_HORIZONTAL_DISTANCE, OverlayType.HORIZONTAL_DISTANCE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.DRAW_CENTERLINE, OverlayType.CENTERLINE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.MEASURE_DOUBLE_CENTERLINE, OverlayType.DOUBLE_CENTERLINE);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.LEFT, OverlayType.LEFT);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.RIGHT, OverlayType.RIGHT);
        OVERLAY_TYPES_PER_MOUSE_SUB_MODE.put(MouseSubModes.STRAIGHTEN_IMAGE, OverlayType.STRAIGHTEN_IMAGE);
    }

    public AbstractMouseModeInfo() {
    }

    public AbstractMouseModeInfo(IMouseModeInfoListener iMouseModeInfoListener) {
        this();
        this.addMouseModeInfoListener(iMouseModeInfoListener);
    }

    @Override
    public void addMouseModeInfoListener(IMouseModeInfoListener iMouseModeInfoListener) {
        if (!this.mouseModeListeners.contains(iMouseModeInfoListener)) {
            this.mouseModeListeners.add(iMouseModeInfoListener);
        }
    }

    @Override
    public boolean allowsSelection() {
        return false;
    }

    @Override
    public boolean areHotRegionsEnabled() {
        return true;
    }

    @Override
    public boolean areHotRegionsInside() {
        return this.areHotRegionsInside;
    }

    @Override
    public void setHotRegionsInside(boolean bl) {
        if (this.areHotRegionsInside != bl) {
            this.areHotRegionsInside = bl;
            this.informHotregionOutsideModeListeners();
        }
    }

    @Override
    public MouseSubModes getSubMode() {
        return this.subMode;
    }

    @Override
    public void handleEscape() {
        if (VisData.getLastModified() != null) {
            IViewMouseHandler iViewMouseHandler = VisData.getLastModified().getView().getMouseHandler();
            if (iViewMouseHandler.roiCreationInProgress()) {
                iViewMouseHandler.onROIDelete();
            } else {
                iViewMouseHandler.deSelect();
            }
        }
        this.resetSubMode();
        this.informMouseModeListeners();
    }

    @Override
    public boolean isNavigationAllowed() {
        return false;
    }

    @Override
    public void resetSubMode() {
        this.setSubMode(MouseSubModes.DEFAULT);
    }

    @Override
    public void setLastSubMode() {
        if (this.lastSubMode == MouseSubModes.DEFAULT && this.subMode == MouseSubModes.DEFAULT) {
            return;
        }
        if (this.lastSubMode == this.subMode) {
            this.setSubMode(MouseSubModes.DEFAULT);
        } else {
            this.setSubMode(this.lastSubMode);
        }
    }

    @Override
    public void setSubMode(MouseSubModes mouseSubModes) {
        OverlayType overlayType;
        this.subMode = mouseSubModes;
        if (mouseSubModes != MouseSubModes.DEFAULT) {
            this.lastSubMode = mouseSubModes;
            this.setHotRegionsInside(false);
            if (Product.isCDViewer()) {
                JVision2.getMainFrame().setTitle(String.valueOf(Product.getProductName()) + "  " + Product.getVersionString() + Product.getReleaseConstraintsText() + " - " + Messages.getString("WindowTitleAddonTextForMeasurementInCDViewer"));
            }
        } else {
            this.setHotRegionsInside(true);
        }
        if ((overlayType = OVERLAY_TYPES_PER_MOUSE_SUB_MODE.get((Object)mouseSubModes)) == null) {
            this.placePresentationObject(null, true);
        } else {
            this.placePresentationObject(ROIFactory.getInstance(overlayType), true);
        }
        this.informMouseModeListeners();
        if (!(this instanceof MouseModeInfoGlobal) && mouseSubModes.isPluginMouseMode()) {
            MouseModeInfoGlobal.getInstance().resetSubMode();
        }
    }

    protected void informMouseModeListeners() {
        for (IMouseModeInfoListener iMouseModeInfoListener : this.mouseModeListeners) {
            iMouseModeInfoListener.mouseModeChanged();
        }
    }

    @Override
    public void removeMouseModeInfoListener(IMouseModeInfoListener iMouseModeInfoListener) {
        this.mouseModeListeners.remove(iMouseModeInfoListener);
    }

    protected void informHotregionOutsideModeListeners() {
        for (IMouseModeInfoListener iMouseModeInfoListener : this.mouseModeListeners) {
            iMouseModeInfoListener.hotregionOutsideModeChanged(this.areHotRegionsInside);
        }
    }

    @Override
    public POCreationStatus getPresentationObjectCreationStatus() {
        return new POCreationStatus(this.poInCreation, this.clone, this.isROIFilled, this.isROIShuttered, this.isROIRelativeScreen);
    }

    @Override
    public void setPresentationObjectCreationStatus(POCreationStatus pOCreationStatus) {
        this.poInCreation = pOCreationStatus.getPOInCreation();
        this.clone = pOCreationStatus.isCloneMode();
        this.isROIFilled = pOCreationStatus.isROIFilled();
        this.isROIShuttered = pOCreationStatus.isROIShuttered();
        this.isROIRelativeScreen = pOCreationStatus.isROIRelativeScreen();
    }

    @Override
    public void storeStateBeforeMeasurement(IViewportRestoreHandler iViewportRestoreHandler, Vector2d vector2d, Object object) {
        if (this.restoreHandler == null) {
            this.restoreHandler = iViewportRestoreHandler;
            this.centreBeforPO = new Vector2d(vector2d);
            this.zoomValueBeforePO = object;
        }
    }

    @Override
    public void restoreStateAfterMeasurement(View view) {
        if (this.restoreHandler != null) {
            this.restoreHandler.restoreZoom(view, this.zoomValueBeforePO);
            this.restoreHandler.restoreViewportCenter(view, this.centreBeforPO.x, this.centreBeforPO.y);
            this.zoomValueBeforePO = null;
            this.centreBeforPO = null;
            this.restoreHandler = null;
        }
    }

    @Override
    public PresentationObject getPlacedPresentationObject() {
        return this.poInCreation;
    }

    @Override
    public void setPlacedPresentationObject(PresentationObject presentationObject) {
        this.poInCreation = presentationObject;
    }

    @Override
    public void placePresentationObject(PresentationObject presentationObject, boolean bl) {
        this.poInCreation = presentationObject;
        this.clone = bl;
    }

    @Override
    public PresentationObject getPresentationObjectToPlace() {
        if (this.poInCreation == null) {
            return null;
        }
        if (this.clone) {
            try {
                PresentationObject presentationObject = (PresentationObject)this.poInCreation.getClass().newInstance();
                presentationObject.setColor(this.poInCreation.objCol);
                this.poInCreation.copySetupTo(presentationObject);
                return presentationObject;
            }
            catch (Exception exception) {
                return null;
            }
        }
        PresentationObject presentationObject = this.poInCreation;
        this.poInCreation = null;
        return presentationObject;
    }

    @Override
    public boolean isAnyPresentationObjectToPlace() {
        return this.poInCreation != null;
    }

    @Override
    public Cursor getCursor(Vis2 vis2) {
        MouseSubModes mouseSubModes = this.getSubMode();
        if (mouseSubModes == MouseSubModes.DEFAULT) {
            return CursorHolder.DEFAULT_CURSOR;
        }
        Cursor cursor = MousePreChargeHandlerFactory.getInstance().getCursor(mouseSubModes);
        if (cursor == null) {
            cursor = CursorHolder.CROSSHAIR_CURSOR;
        }
        return cursor;
    }

    @Override
    public boolean isROIShuttered() {
        return this.isROIShuttered;
    }

    @Override
    public void setROIShuttered(boolean bl) {
        this.isROIShuttered = bl;
    }

    @Override
    public boolean isROIFilled() {
        return this.isROIFilled;
    }

    @Override
    public void setROIFilled(boolean bl) {
        this.isROIFilled = bl;
    }

    public boolean isROIRelativeScreen() {
        return this.isROIRelativeScreen;
    }

    public void setROIRelativeScreen(boolean bl) {
        this.isROIRelativeScreen = bl;
    }

    protected static class CursorHolder {
        public static final Cursor DEFAULT_CURSOR = new Cursor(0);
        public static final Cursor DEFAULT_PAN_CURSOR = new Cursor(13);
        public static final Cursor CROSSHAIR_CURSOR = CursorHolder.createCrosshairCursor();

        protected CursorHolder() {
        }

        private static Cursor createCrosshairCursor() {
            if (Product.isHeadless()) {
                return null;
            }
            if (Config.impaxee.jvision.MAIN.UseJavaDefaultCrosshair.get()) {
                log.debug("Using Java Default Crosshair");
                return Cursor.getPredefinedCursor(1);
            }
            TIcon tIcon = new TIcon("/icons/cursor_zoomrect.gif");
            BufferedImage bufferedImage = ((ToolkitImage)tIcon.getImage()).getBufferedImage();
            int n = 0;
            while ((long)n < Config.impaxee.jvision.MEASUREMENT.CrossCursorGap.get()) {
                bufferedImage.setRGB(15 - n, 15, 0);
                bufferedImage.setRGB(15 + n, 15, 0);
                bufferedImage.setRGB(15, 15 - n, 0);
                bufferedImage.setRGB(15, 15 + n, 0);
                ++n;
            }
            return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(15, 15), "CROSSHAIR");
        }
    }
}

