/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.Orientation;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.DisplaySetProperties;
import com.tiani.jvision.main.DisplaySetType;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluablePrivateData;
import com.tiani.util.expressions.IEvaluationContext;
import java.util.EnumSet;
import org.dcm4che3.data.Attributes;

public class DisplaySetEvaluable
implements IEvaluableData,
IEvaluationContext {
    private IEvaluableData series;
    private IFrameObjectData frame;
    private IStudyContainer studyContainer;
    private IDisplaySet displayset;
    private View view;

    public DisplaySetEvaluable(IDisplaySet iDisplaySet) {
        this.displayset = iDisplaySet;
        this.frame = iDisplaySet.getOneObject();
        this.series = this.frame.getMainFrame().getParent();
    }

    public DisplaySetEvaluable(IFrameObjectData iFrameObjectData, IDisplaySet iDisplaySet) {
        this.displayset = iDisplaySet;
        this.frame = iFrameObjectData;
        this.series = this.frame.getMainFrame().getParent();
    }

    public DisplaySetEvaluable(IEvaluableData iEvaluableData, IDisplaySet iDisplaySet, View view) {
        this.displayset = iDisplaySet;
        this.frame = null;
        this.series = iEvaluableData;
        this.view = view;
    }

    public DisplaySetEvaluable(IFrameObjectData iFrameObjectData, IDisplaySet iDisplaySet, IStudyContainer iStudyContainer) {
        this.displayset = iDisplaySet;
        this.frame = iFrameObjectData;
        this.series = iFrameObjectData.getMainFrame().getParent();
        this.studyContainer = iStudyContainer;
        this.view = null;
    }

    public DisplaySetEvaluable(IFrameObjectData iFrameObjectData, IDisplaySet iDisplaySet, View view) {
        this.displayset = iDisplaySet;
        this.frame = iFrameObjectData;
        this.series = iFrameObjectData.getMainFrame().getParent();
        this.studyContainer = null;
        this.view = view;
    }

    public IStudyContainer getStudyContainer() {
        if (this.studyContainer == null) {
            this.studyContainer = DataSelectionManager.getInstance().getActiveHanging().getStudyContainer();
        }
        return this.studyContainer;
    }

    @Override
    public String resolveString(int n) {
        String string = this.resolveStringInt(n);
        if (string != null) {
            return string;
        }
        if (n == 524296 && this.frame != null) {
            String[] stringArray = this.frame.resolveStrings(n);
            if (stringArray == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(10 * stringArray.length);
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                stringBuffer.append(string2).append('\\');
                ++n3;
            }
            return stringBuffer.toString();
        }
        if (this.frame != null) {
            string = this.frame.resolveString(n);
        }
        if (string == null && this.series != null) {
            string = this.series.resolveString(n);
        }
        return string;
    }

    private String resolveStringInt(int n) {
        if (PrivateTagDictionary.studyLoadOrderTag == n) {
            IStudyContainer iStudyContainer = this.getStudyContainer();
            if (iStudyContainer == null) {
                return null;
            }
            return iStudyContainer.getIndexStringOfStudy(this.getStudyKey());
        }
        if (PrivateTagDictionary.studyLoadOrderReverseTag == n) {
            IStudyContainer iStudyContainer = this.getStudyContainer();
            if (iStudyContainer == null) {
                return null;
            }
            int n2 = iStudyContainer.getIndexOfStudy(this.getStudyKey());
            return Integer.toString(iStudyContainer.getLoadedPriorCount() - n2);
        }
        if (-65528 == n) {
            Orientation orientation = this.displayset.getDisplaySetOrientation();
            return orientation != null ? orientation.getValue() : null;
        }
        if (-65527 == n) {
            DisplaySetType displaySetType = this.displayset.getDisplaySetType();
            return displaySetType == null ? "" : displaySetType.getValue();
        }
        if (-65523 == n) {
            IStudyContainer iStudyContainer = this.getStudyContainer();
            IPatientRepresentation iPatientRepresentation = iStudyContainer.getPatientRepresentation();
            IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
            String string = iStudyContainer.getBaseStudy().getStudyInstanceUID();
            int n3 = 0;
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
            int n4 = iDisplaySetArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IDisplaySet iDisplaySet = iDisplaySetArray2[n5];
                if (iDisplaySet.getStudyUID().equals(string)) {
                    ++n3;
                }
                ++n5;
            }
            return Integer.toString(n3);
        }
        if (PrivateTagDictionary.displaySetNumberOfImagesTag == n || PrivateTagDictionary.seriesNumberOfImagesTag == n) {
            return Integer.toString(this.displayset.getTotalFrameCount());
        }
        if (PrivateTagDictionary.displaySetPropertiesTag == n) {
            return DisplaySetEvaluable.DSPropertiesToString(this.displayset.getDisplaySetProperties());
        }
        if (-65521 == n) {
            if (this.view != null) {
                return Integer.toString(this.view.getVis().getParent().get4DProperties().getNumberOf4DRuns());
            }
            if (this.displayset.isPrimaryNavigationInSpace()) {
                return Integer.toString(this.displayset.getFrames().length);
            }
            return Integer.toString(this.displayset.getFrames()[0].length);
        }
        if (-65525 == n) {
            return Integer.toString(this.getStudyContainer().getRelevantPriorCount());
        }
        if (-65522 == n) {
            return this.displayset.getStudy().resolveString(n);
        }
        return null;
    }

    private static String DSPropertiesToString(EnumSet<DisplaySetProperties> enumSet) {
        if (enumSet.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DisplaySetProperties displaySetProperties : enumSet) {
            stringBuilder.append((Object)displaySetProperties).append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        Attributes attributes = null;
        if (this.frame != null) {
            attributes = this.frame.resolveStringEnhanced(nArray, n);
        }
        if (attributes == null && this.series != null) {
            attributes = this.series.resolveStringEnhanced(nArray, n);
        }
        return attributes;
    }

    @Override
    public String[] resolveStrings(int n) {
        String string = this.resolveStringInt(n);
        if (string != null) {
            return new String[]{string};
        }
        if (n == 524296 && this.frame != null) {
            String[] stringArray = this.frame.resolveStrings(n);
            return stringArray;
        }
        String[] stringArray = null;
        if (this.frame != null) {
            stringArray = this.frame.resolveStrings(n);
        }
        if (stringArray == null && this.series != null) {
            stringArray = this.series.resolveStrings(n);
        }
        return stringArray;
    }

    protected String getStudyKey() {
        return this.displayset.getStudyUID();
    }

    public IDisplaySet getDisplayset() {
        return this.displayset;
    }

    public IFrameObjectData getFrameObjectData() {
        return this.frame;
    }

    public IDataObject getSeries() {
        if (this.series instanceof IDataObject) {
            return (IDataObject)this.series;
        }
        if (this.frame != null) {
            return this.frame;
        }
        return null;
    }

    @Override
    public IEvaluableData getData() {
        return this;
    }

    @Override
    public IEvaluablePrivateData getVisual() {
        return this.view;
    }
}

