/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum DisplaySetProperties {
    LARGEST,
    BONE_WINDOW,
    SOFT_TISSUE_WINDOW,
    LUNG_WINDOW,
    BOLUS,
    CTA_ARTERIAL,
    CTA_PORTAL_VEIN,
    CTA_VEIN,
    CTA_POST_VEIN;


    public static EnumSet<DisplaySetProperties> getDisplaySetProperties(IDisplaySet iDisplaySet, List<IDisplaySet> list) {
        IImageInformation iImageInformation = iDisplaySet.getOneObject().getImageInformation();
        IImageInformation.ImageClass imageClass = iImageInformation.getImageClass();
        if (imageClass == IImageInformation.ImageClass.CT || imageClass == IImageInformation.ImageClass.MR) {
            String string;
            EnumSet<DisplaySetProperties> enumSet = EnumSet.noneOf(DisplaySetProperties.class);
            boolean bl = true;
            int n = iDisplaySet.getTotalFrameCount();
            for (IDisplaySet object2 : list) {
                if (object2.getTotalFrameCount() <= n) continue;
                bl = false;
                break;
            }
            if (bl && list.size() > 1) {
                enumSet.add(LARGEST);
            }
            if (!StringUtils.isBlank((CharSequence)(string = iImageInformation.getDataset().getString(0x180010)))) {
                enumSet.add(BOLUS);
            }
            if (imageClass == IImageInformation.ImageClass.CT) {
                int n2;
                IVOILUT iVOILUT = iImageInformation.getVOILUT();
                if (iVOILUT != null && iVOILUT.hasWindow()) {
                    n2 = (int)iVOILUT.getWindowCenter();
                    if (n2 > 280) {
                        enumSet.add(BONE_WINDOW);
                    } else if (n2 < -200) {
                        enumSet.add(LUNG_WINDOW);
                    } else if (n2 > 0) {
                        enumSet.add(SOFT_TISSUE_WINDOW);
                    }
                }
                if (enumSet.contains((Object)BOLUS)) {
                    n2 = DisplaySetProperties.countContrastSeriesBeforeThis(list, iDisplaySet);
                    switch (n2) {
                        case 0: {
                            enumSet.add(CTA_ARTERIAL);
                            break;
                        }
                        case 1: {
                            enumSet.add(CTA_PORTAL_VEIN);
                            break;
                        }
                        case 2: {
                            enumSet.add(CTA_VEIN);
                            break;
                        }
                        default: {
                            enumSet.add(CTA_POST_VEIN);
                        }
                    }
                }
            }
            return enumSet;
        }
        return EnumSet.noneOf(DisplaySetProperties.class);
    }

    private static int countContrastSeriesBeforeThis(List<IDisplaySet> list, IDisplaySet iDisplaySet) {
        int n = 0;
        for (IDisplaySet iDisplaySet2 : list) {
            if (iDisplaySet2 == iDisplaySet) break;
            IFrameObjectData iFrameObjectData = iDisplaySet2.getOneObject();
            IImageInformation iImageInformation = iFrameObjectData.getImageInformation();
            if (!iImageInformation.getImageType().contains(ImageType.PRIMARY) || !iImageInformation.getImageType().contains(ImageType.ORIGINAL) || !iImageInformation.getDataset().containsValue(0x180010)) continue;
            ++n;
        }
        return n;
    }
}

