/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.data.shared.code.MammoCode;
import com.agfa.pacs.impaxee.hanging.impl.MammoCREvaluation;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ImageInformation2;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;
import org.jfree.util.Log;

public enum DisplaySetType {
    NONE(""),
    PRIMARY,
    LOCALIZER,
    SECONDARY_CAPTURE,
    CT_MPR("MPR"),
    ML,
    MLO,
    CC,
    LM,
    LMO,
    FB,
    SIO,
    ISO,
    XCCL,
    XCCM,
    XCC,
    T1,
    T2,
    PD,
    DWI,
    ADC,
    EADC,
    FLAIR,
    STIR,
    TIRM,
    AP,
    PA,
    LL,
    RL,
    RLO,
    LLO;

    public static final String LATERAL_LEGACY = "LA";
    public static final String AP_LEGACY = "AP";
    public static final String PA_LEGACY = "PA";
    private static final int PD_MINIMAL_TR = 1000;
    private static final int PD_MAXIMAL_TE = 50;
    private static final int T1_NORMAL_TR = 900;
    private static final int T1_NORMAL_TE = 90;
    private static final int FLAIR_INVERSION = 1500;
    private static final int STIR_INVERSION = 200;
    private static final int TIRM_INVERSION = 500;
    private static final int TR_ULTRA_SHORT = 50;
    private static final String T2_ULTRA_SHORT_PREFIX = "t2";
    private String value;

    private DisplaySetType(String string2) {
        this.value = string2;
    }

    private DisplaySetType() {
        this.value = this.name();
    }

    public String getValue() {
        return this.value;
    }

    public static DisplaySetType getDisplaySetType(IImageInformation iImageInformation) {
        DisplaySetType displaySetType;
        Set<ImageType> set = iImageInformation.getImageType();
        if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MG || ImageInformation2.isTomosynthesisImage(iImageInformation)) {
            MammoCode mammoCode = MammoCode.getMammoCode((Attributes)iImageInformation.getDataset());
            if (mammoCode != null) {
                return DisplaySetType.valueOf(mammoCode.getViewCode());
            }
        } else if (iImageInformation.getImageClass() == IImageInformation.ImageClass.CR) {
            DisplaySetType displaySetType2 = DisplaySetType.getTypeForCR(iImageInformation);
            if (displaySetType2 != null) {
                return displaySetType2;
            }
        } else if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MR && (displaySetType = DisplaySetType.getTypeForMR(iImageInformation, set)) != null) {
            return displaySetType;
        }
        if (iImageInformation.isLocalizer()) {
            return LOCALIZER;
        }
        if (set.contains(ImageType.MPR) || set.contains(ImageType.REFORMATTED) || set.contains(ImageType.REFORMATED)) {
            return CT_MPR;
        }
        if (set.contains(ImageType.SECONDARY) || iImageInformation.getImageClass() == IImageInformation.ImageClass.SC) {
            return SECONDARY_CAPTURE;
        }
        if (set.contains(ImageType.PRIMARY) && set.contains(ImageType.ORIGINAL)) {
            return PRIMARY;
        }
        return NONE;
    }

    private static DisplaySetType getTypeForCR(IImageInformation iImageInformation) {
        String string;
        if (MammoCREvaluation.getInstance().isMammoImage(iImageInformation)) {
            return MammoCREvaluation.getInstance().getDisplaySetType(iImageInformation);
        }
        String string2 = iImageInformation.getDataset().getString(1593601);
        if (string2 != null) {
            try {
                return DisplaySetType.valueOf(string2);
            }
            catch (Exception exception) {
                Log.debug((Object)"Could not detect CR Type", (Exception)exception);
            }
        }
        if ((string = iImageInformation.getDataset().getString(528446)) != null) {
            if (StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)LATERAL_LEGACY)) {
                return LL;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)AP_LEGACY)) {
                return AP;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)PA_LEGACY)) {
                return PA;
            }
        }
        return null;
    }

    private static DisplaySetType getTypeForMR(IImageInformation iImageInformation, Set<ImageType> set) {
        if (set.contains(ImageType.ADC)) {
            return ADC;
        }
        if (set.contains(ImageType.EADC)) {
            return EADC;
        }
        Double d = iImageInformation.getDiffusionBValue();
        if (d != null && d != 0.0) {
            return DWI;
        }
        Double d2 = iImageInformation.getRepetitionTime();
        Double d3 = iImageInformation.getEchoTime();
        if (d2 != null && d3 != null) {
            Object object;
            DisplaySetType displaySetType = d2 >= 1000.0 && d3 < 50.0 ? PD : (d2 < 900.0 && d3 < 90.0 ? T1 : T2);
            if (d2 < 50.0 && StringUtils.startsWithIgnoreCase((CharSequence)(object = iImageInformation.getDataset().getString(528446)), (CharSequence)T2_ULTRA_SHORT_PREFIX)) {
                displaySetType = T2;
            }
            if (displaySetType == T2 && (object = iImageInformation.getInversionTime()) != null) {
                if ((Double)object > 1500.0) {
                    return FLAIR;
                }
                if ((Double)object < 200.0) {
                    return STIR;
                }
                if ((Double)object < 500.0) {
                    return TIRM;
                }
            }
            return displaySetType;
        }
        return null;
    }
}

