/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.main;

import com.agfa.pacs.base.swing.ILTAFrame;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.tiani.gui.util.panel.flexible.FlexiblePanel;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.keypress.KeypressRegistry;
import com.tiani.jvision.main.IKeyEventHandler;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;

public class MainFrame2KeyListener
extends DefaultKeyboardFocusManager {
    private KeypressRegistry keypressRegistry = KeypressRegistry.getInstance();
    private MainFrame2 mainFrame;
    private final Set<KeyShortcut> consumedKeyPresses = new HashSet<KeyShortcut>();
    private List<WeakReference<IKeyEventHandler>> additionalKeyListeners;

    public MainFrame2KeyListener(MainFrame2 mainFrame2) {
        this.mainFrame = mainFrame2;
        this.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.additionalKeyListeners = new ArrayList<WeakReference<IKeyEventHandler>>();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        RootPaneContainer rootPaneContainer;
        Window window = this.getFocusedWindow();
        if ((window == this.mainFrame || window.getParent() == this.mainFrame) && keyEvent.getKeyCode() != 9) {
            if (window != this.mainFrame && keyEvent.getKeyCode() == 10) {
                return super.dispatchKeyEvent(keyEvent);
            }
            boolean bl = this.processMainFrameKeyEvent(keyEvent);
            if (keyEvent.getKeyCode() == 32) {
                bl = true;
            }
            return bl ? bl : super.dispatchKeyEvent(keyEvent);
        }
        if ((window instanceof ILTAFrame || window.getParent() instanceof ILTAFrame) && keyEvent.getKeyCode() != 9) {
            boolean bl = this.processLTAKeyEvent(keyEvent);
            return bl ? bl : super.dispatchKeyEvent(keyEvent);
        }
        if (window instanceof RootPaneContainer && (rootPaneContainer = (RootPaneContainer)((Object)window)).getContentPane() != null && rootPaneContainer.getContentPane().getComponentCount() > 0 && rootPaneContainer.getContentPane().getComponent(0) instanceof FlexiblePanel) {
            this.redispatchEvent(rootPaneContainer.getContentPane().getComponent(0), keyEvent);
            if (keyEvent.isConsumed()) {
                return true;
            }
            boolean bl = this.processMainFrameKeyEvent(keyEvent);
            return bl ? bl : super.dispatchKeyEvent(keyEvent);
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public void registerKeyEventHandler(IKeyEventHandler iKeyEventHandler) {
        this.additionalKeyListeners.add(new WeakReference<IKeyEventHandler>(iKeyEventHandler));
    }

    private boolean processLTAKeyEvent(KeyEvent keyEvent) {
        block5: {
            block4: {
                if (keyEvent.isConsumed()) break block4;
                switch (keyEvent.getID()) {
                    case 401: {
                        if (!this.keypressRegistry.handleLTAKeyEvent(keyEvent)) {
                            return false;
                        } else {
                            break;
                        }
                    }
                }
                break block5;
            }
            return true;
        }
        return false;
    }

    private boolean processMainFrameKeyEvent(KeyEvent keyEvent) {
        JTextComponent jTextComponent = null;
        VisData visData = VisData.getLastModified();
        if (visData != null && visData.getVisual() != null && this.checkEscapeOnTextROIEditing(visData, keyEvent)) {
            return true;
        }
        Component component = this.getFocusOwner();
        if (component instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component;
        }
        if (jTextComponent != null) {
            this.redispatchEvent(jTextComponent, keyEvent);
            return false;
        }
        boolean bl = false;
        Iterator<WeakReference<IKeyEventHandler>> iterator = this.additionalKeyListeners.iterator();
        while (iterator.hasNext() && !bl) {
            WeakReference<IKeyEventHandler> weakReference = iterator.next();
            IKeyEventHandler iKeyEventHandler = (IKeyEventHandler)weakReference.get();
            if (iKeyEventHandler == null) {
                iterator.remove();
                continue;
            }
            bl = iKeyEventHandler.handleKeyEvent(keyEvent);
        }
        if (!bl) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (!this.keypressRegistry.handleMainFrameKeyEvent(keyEvent)) {
                        if (keyEvent.getKeyCode() == 18) {
                            keyEvent.consume();
                        }
                        return false;
                    }
                    this.consumedKeyPresses.add(new KeyShortcut(keyEvent));
                    break;
                }
                case 402: {
                    if (this.consumedKeyPresses.remove(new KeyShortcut(keyEvent))) break;
                    return false;
                }
            }
        }
        keyEvent.consume();
        return true;
    }

    private boolean checkEscapeOnTextROIEditing(VisData visData, KeyEvent keyEvent) {
        IViewMouseHandler iViewMouseHandler = visData.getVisual().getViewMouseHandler();
        if (iViewMouseHandler.isEditingTextROI() && keyEvent.getKeyCode() == 27 && keyEvent.getID() == 401) {
            iViewMouseHandler.stopEditingTextROI();
            keyEvent.consume();
            return true;
        }
        return false;
    }
}

